% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.R
\name{formula.recipe}
\alias{formula.recipe}
\title{Create a Formula from a Prepared Recipe}
\usage{
\method{formula}{recipe}(x, ...)
}
\arguments{
\item{x}{A recipe object where all steps have been prepared.}

\item{...}{Note currently used.}
}
\value{
A formula.
}
\description{
In case a model formula is required, the formula method can
be used on a recipe to show what predictors and outcome(s)
could be used.
}
\examples{

formula(recipe(Species + Sepal.Length ~ ., data = iris))

iris_rec <- recipe(Species ~ ., data = iris) \%>\%
  step_center(all_numeric()) \%>\%
  prep(training = iris)
formula(iris_rec)
}
