# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class ApiOperation(msrest.serialization.Model):
    """REST API operation description: see https://github.com/Azure/azure-rest-api-specs/blob/master/documentation/openapi-authoring-automated-guidelines.md#r3023-operationsapiimplementation.

    :param display: The object that represents the operation.
    :type display: ~storage_cache_management_client.models.ApiOperationDisplay
    :param origin: Origin of the operation.
    :type origin: str
    :param is_data_action: The flag that indicates whether the operation applies to data plane.
    :type is_data_action: bool
    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param service_specification: Specification of the all the metrics provided for a resource
     type.
    :type service_specification:
     ~storage_cache_management_client.models.ApiOperationPropertiesServiceSpecification
    """

    _attribute_map = {
        'display': {'key': 'display', 'type': 'ApiOperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'ApiOperationPropertiesServiceSpecification'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiOperation, self).__init__(**kwargs)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.is_data_action = kwargs.get('is_data_action', None)
        self.name = kwargs.get('name', None)
        self.service_specification = kwargs.get('service_specification', None)


class ApiOperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    :param operation: Operation type: Read, write, delete, etc.
    :type operation: str
    :param provider: Service provider: Microsoft.StorageCache.
    :type provider: str
    :param resource: Resource on which the operation is performed: Cache, etc.
    :type resource: str
    :param description: The description of the operation.
    :type description: str
    """

    _attribute_map = {
        'operation': {'key': 'operation', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiOperationDisplay, self).__init__(**kwargs)
        self.operation = kwargs.get('operation', None)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.description = kwargs.get('description', None)


class ApiOperationListResult(msrest.serialization.Model):
    """Result of the request to list Resource Provider operations. It contains a list of operations and a URL link to get the next set of results.

    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    :param value: List of Resource Provider operations supported by the Microsoft.StorageCache
     resource provider.
    :type value: list[~storage_cache_management_client.models.ApiOperation]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ApiOperation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiOperationListResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class ApiOperationPropertiesServiceSpecification(msrest.serialization.Model):
    """Specification of the all the metrics provided for a resource type.

    :param metric_specifications: Details about operations related to metrics.
    :type metric_specifications: list[~storage_cache_management_client.models.MetricSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiOperationPropertiesServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = kwargs.get('metric_specifications', None)


class AscOperation(msrest.serialization.Model):
    """The status of operation.

    :param id: The operation Id.
    :type id: str
    :param name: The operation name.
    :type name: str
    :param start_time: The start time of the operation.
    :type start_time: str
    :param end_time: The end time of the operation.
    :type end_time: str
    :param status: The status of the operation.
    :type status: str
    :param error: The error detail of the operation if any.
    :type error: ~storage_cache_management_client.models.ErrorResponse
    :param output: Additional operation-specific output.
    :type output: dict[str, any]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorResponse'},
        'output': {'key': 'properties.output', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AscOperation, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.status = kwargs.get('status', None)
        self.error = kwargs.get('error', None)
        self.output = kwargs.get('output', None)


class BlobNfsTarget(msrest.serialization.Model):
    """Properties pertaining to the BlobNfsTarget.

    :param target: Resource ID of the storage container.
    :type target: str
    :param usage_model: Identifies the StorageCache usage model to be used for this storage target.
    :type usage_model: str
    """

    _attribute_map = {
        'target': {'key': 'target', 'type': 'str'},
        'usage_model': {'key': 'usageModel', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobNfsTarget, self).__init__(**kwargs)
        self.target = kwargs.get('target', None)
        self.usage_model = kwargs.get('usage_model', None)


class Cache(msrest.serialization.Model):
    """A Cache instance. Follows Azure Resource Manager standards: https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/resource-api-reference.md.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar id: Resource ID of the Cache.
    :vartype id: str
    :param location: Region name string.
    :type location: str
    :ivar name: Name of Cache.
    :vartype name: str
    :ivar type: Type of the Cache; Microsoft.StorageCache/Cache.
    :vartype type: str
    :param identity: The identity of the cache, if configured.
    :type identity: ~storage_cache_management_client.models.CacheIdentity
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~storage_cache_management_client.models.SystemData
    :param sku: SKU for the Cache.
    :type sku: ~storage_cache_management_client.models.CacheSku
    :param cache_size_gb: The size of this Cache, in GB.
    :type cache_size_gb: int
    :ivar health: Health of the Cache.
    :vartype health: ~storage_cache_management_client.models.CacheHealth
    :ivar mount_addresses: Array of IP addresses that can be used by clients mounting this Cache.
    :vartype mount_addresses: list[str]
    :ivar provisioning_state: ARM provisioning state, see
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property.
     Possible values include: "Succeeded", "Failed", "Cancelled", "Creating", "Deleting",
     "Updating".
    :vartype provisioning_state: str or
     ~storage_cache_management_client.models.ProvisioningStateType
    :param subnet: Subnet used for the Cache.
    :type subnet: str
    :ivar upgrade_status: Upgrade status of the Cache.
    :vartype upgrade_status: ~storage_cache_management_client.models.CacheUpgradeStatus
    :param network_settings: Specifies network settings of the cache.
    :type network_settings: ~storage_cache_management_client.models.CacheNetworkSettings
    :param encryption_settings: Specifies encryption settings of the cache.
    :type encryption_settings: ~storage_cache_management_client.models.CacheEncryptionSettings
    :param security_settings: Specifies security settings of the cache.
    :type security_settings: ~storage_cache_management_client.models.CacheSecuritySettings
    :param directory_services_settings: Specifies Directory Services settings of the cache.
    :type directory_services_settings:
     ~storage_cache_management_client.models.CacheDirectorySettings
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^[-0-9a-zA-Z_]{1,80}$'},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'health': {'readonly': True},
        'mount_addresses': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'upgrade_status': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'CacheIdentity'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'sku': {'key': 'sku', 'type': 'CacheSku'},
        'cache_size_gb': {'key': 'properties.cacheSizeGB', 'type': 'int'},
        'health': {'key': 'properties.health', 'type': 'CacheHealth'},
        'mount_addresses': {'key': 'properties.mountAddresses', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'str'},
        'upgrade_status': {'key': 'properties.upgradeStatus', 'type': 'CacheUpgradeStatus'},
        'network_settings': {'key': 'properties.networkSettings', 'type': 'CacheNetworkSettings'},
        'encryption_settings': {'key': 'properties.encryptionSettings', 'type': 'CacheEncryptionSettings'},
        'security_settings': {'key': 'properties.securitySettings', 'type': 'CacheSecuritySettings'},
        'directory_services_settings': {'key': 'properties.directoryServicesSettings', 'type': 'CacheDirectorySettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Cache, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.id = None
        self.location = kwargs.get('location', None)
        self.name = None
        self.type = None
        self.identity = kwargs.get('identity', None)
        self.system_data = None
        self.sku = kwargs.get('sku', None)
        self.cache_size_gb = kwargs.get('cache_size_gb', None)
        self.health = None
        self.mount_addresses = None
        self.provisioning_state = None
        self.subnet = kwargs.get('subnet', None)
        self.upgrade_status = None
        self.network_settings = kwargs.get('network_settings', None)
        self.encryption_settings = kwargs.get('encryption_settings', None)
        self.security_settings = kwargs.get('security_settings', None)
        self.directory_services_settings = kwargs.get('directory_services_settings', None)


class CacheActiveDirectorySettings(msrest.serialization.Model):
    """Active Directory settings used to join a cache to a domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param primary_dns_ip_address: Required. Primary DNS IP address used to resolve the Active
     Directory domain controller's fully qualified domain name.
    :type primary_dns_ip_address: str
    :param secondary_dns_ip_address: Secondary DNS IP address used to resolve the Active Directory
     domain controller's fully qualified domain name.
    :type secondary_dns_ip_address: str
    :param domain_name: Required. The fully qualified domain name of the Active Directory domain
     controller.
    :type domain_name: str
    :param domain_net_bios_name: Required. The Active Directory domain's NetBIOS name.
    :type domain_net_bios_name: str
    :param cache_net_bios_name: Required. The NetBIOS name to assign to the HPC Cache when it joins
     the Active Directory domain as a server. Length must 1-15 characters from the class
     [-0-9a-zA-Z].
    :type cache_net_bios_name: str
    :ivar domain_joined: True if the HPC Cache is joined to the Active Directory domain. Possible
     values include: "Yes", "No", "Error".
    :vartype domain_joined: str or ~storage_cache_management_client.models.DomainJoinedType
    :param credentials: Active Directory admin credentials used to join the HPC Cache to a domain.
    :type credentials:
     ~storage_cache_management_client.models.CacheActiveDirectorySettingsCredentials
    """

    _validation = {
        'primary_dns_ip_address': {'required': True},
        'domain_name': {'required': True},
        'domain_net_bios_name': {'required': True},
        'cache_net_bios_name': {'required': True, 'pattern': r'^[-0-9a-zA-Z]{1,15}$'},
        'domain_joined': {'readonly': True},
    }

    _attribute_map = {
        'primary_dns_ip_address': {'key': 'primaryDnsIpAddress', 'type': 'str'},
        'secondary_dns_ip_address': {'key': 'secondaryDnsIpAddress', 'type': 'str'},
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'domain_net_bios_name': {'key': 'domainNetBiosName', 'type': 'str'},
        'cache_net_bios_name': {'key': 'cacheNetBiosName', 'type': 'str'},
        'domain_joined': {'key': 'domainJoined', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'CacheActiveDirectorySettingsCredentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CacheActiveDirectorySettings, self).__init__(**kwargs)
        self.primary_dns_ip_address = kwargs['primary_dns_ip_address']
        self.secondary_dns_ip_address = kwargs.get('secondary_dns_ip_address', None)
        self.domain_name = kwargs['domain_name']
        self.domain_net_bios_name = kwargs['domain_net_bios_name']
        self.cache_net_bios_name = kwargs['cache_net_bios_name']
        self.domain_joined = None
        self.credentials = kwargs.get('credentials', None)


class CacheActiveDirectorySettingsCredentials(msrest.serialization.Model):
    """Active Directory admin credentials used to join the HPC Cache to a domain.

    All required parameters must be populated in order to send to Azure.

    :param username: Required. Username of the Active Directory domain administrator. This value is
     stored encrypted and not returned on response.
    :type username: str
    :param password: Required. Plain text password of the Active Directory domain administrator.
     This value is stored encrypted and not returned on response.
    :type password: str
    """

    _validation = {
        'username': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CacheActiveDirectorySettingsCredentials, self).__init__(**kwargs)
        self.username = kwargs['username']
        self.password = kwargs['password']


class CacheDirectorySettings(msrest.serialization.Model):
    """Cache Directory Services settings.

    :param active_directory: Specifies settings for joining the HPC Cache to an Active Directory
     domain.
    :type active_directory: ~storage_cache_management_client.models.CacheActiveDirectorySettings
    :param username_download: Specifies settings for Extended Groups. Extended Groups allows users
     to be members of more than 16 groups.
    :type username_download: ~storage_cache_management_client.models.CacheUsernameDownloadSettings
    """

    _attribute_map = {
        'active_directory': {'key': 'activeDirectory', 'type': 'CacheActiveDirectorySettings'},
        'username_download': {'key': 'usernameDownload', 'type': 'CacheUsernameDownloadSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CacheDirectorySettings, self).__init__(**kwargs)
        self.active_directory = kwargs.get('active_directory', None)
        self.username_download = kwargs.get('username_download', None)


class CacheEncryptionSettings(msrest.serialization.Model):
    """Cache encryption settings.

    :param key_encryption_key: Specifies the location of the key encryption key in Key Vault.
    :type key_encryption_key: ~storage_cache_management_client.models.KeyVaultKeyReference
    :param rotation_to_latest_key_version_enabled: Specifies whether the service will automatically
     rotate to the newest version of the key in the Key Vault.
    :type rotation_to_latest_key_version_enabled: bool
    """

    _attribute_map = {
        'key_encryption_key': {'key': 'keyEncryptionKey', 'type': 'KeyVaultKeyReference'},
        'rotation_to_latest_key_version_enabled': {'key': 'rotationToLatestKeyVersionEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CacheEncryptionSettings, self).__init__(**kwargs)
        self.key_encryption_key = kwargs.get('key_encryption_key', None)
        self.rotation_to_latest_key_version_enabled = kwargs.get('rotation_to_latest_key_version_enabled', None)


class CacheHealth(msrest.serialization.Model):
    """An indication of Cache health. Gives more information about health than just that related to provisioning.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param state: List of Cache health states. Possible values include: "Unknown", "Healthy",
     "Degraded", "Down", "Transitioning", "Stopping", "Stopped", "Upgrading", "Flushing".
    :type state: str or ~storage_cache_management_client.models.HealthStateType
    :param status_description: Describes explanation of state.
    :type status_description: str
    :ivar conditions: Outstanding conditions that need to be investigated and resolved.
    :vartype conditions: list[~storage_cache_management_client.models.Condition]
    """

    _validation = {
        'conditions': {'readonly': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'status_description': {'key': 'statusDescription', 'type': 'str'},
        'conditions': {'key': 'conditions', 'type': '[Condition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CacheHealth, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.status_description = kwargs.get('status_description', None)
        self.conditions = None


class CacheIdentity(msrest.serialization.Model):
    """Cache identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID for the system-assigned identity of the cache.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID associated with the cache.
    :vartype tenant_id: str
    :param type: The type of identity used for the cache. Possible values include:
     "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", "None".
    :type type: str or ~storage_cache_management_client.models.CacheIdentityType
    :param user_assigned_identities: A dictionary where each key is a user assigned identity
     resource ID, and each key's value is an empty dictionary.
    :type user_assigned_identities: dict[str,
     ~storage_cache_management_client.models.UserAssignedIdentitiesValue]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentitiesValue}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CacheIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class CacheNetworkSettings(msrest.serialization.Model):
    """Cache network settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param mtu: The IPv4 maximum transmission unit configured for the subnet.
    :type mtu: int
    :ivar utility_addresses: Array of additional IP addresses used by this Cache.
    :vartype utility_addresses: list[str]
    :param dns_servers: DNS servers for the cache to use.  It will be set from the network
     configuration if no value is provided.
    :type dns_servers: list[str]
    :param dns_search_domain: DNS search domain.
    :type dns_search_domain: str
    :param ntp_server: NTP server IP Address or FQDN for the cache to use. The default is
     time.windows.com.
    :type ntp_server: str
    """

    _validation = {
        'mtu': {'maximum': 1500, 'minimum': 576},
        'utility_addresses': {'readonly': True},
    }

    _attribute_map = {
        'mtu': {'key': 'mtu', 'type': 'int'},
        'utility_addresses': {'key': 'utilityAddresses', 'type': '[str]'},
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
        'dns_search_domain': {'key': 'dnsSearchDomain', 'type': 'str'},
        'ntp_server': {'key': 'ntpServer', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CacheNetworkSettings, self).__init__(**kwargs)
        self.mtu = kwargs.get('mtu', 1500)
        self.utility_addresses = None
        self.dns_servers = kwargs.get('dns_servers', None)
        self.dns_search_domain = kwargs.get('dns_search_domain', None)
        self.ntp_server = kwargs.get('ntp_server', "time.windows.com")


class CacheSecuritySettings(msrest.serialization.Model):
    """Cache security settings.

    :param access_policies: NFS access policies defined for this cache.
    :type access_policies: list[~storage_cache_management_client.models.NfsAccessPolicy]
    """

    _attribute_map = {
        'access_policies': {'key': 'accessPolicies', 'type': '[NfsAccessPolicy]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CacheSecuritySettings, self).__init__(**kwargs)
        self.access_policies = kwargs.get('access_policies', None)


class CacheSku(msrest.serialization.Model):
    """SKU for the Cache.

    :param name: SKU name for this Cache.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CacheSku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class CachesListResult(msrest.serialization.Model):
    """Result of the request to list Caches. It contains a list of Caches and a URL link to get the next set of results.

    :param next_link: URL to get the next set of Cache list results, if there are any.
    :type next_link: str
    :param value: List of Caches.
    :type value: list[~storage_cache_management_client.models.Cache]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Cache]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CachesListResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class CacheUpgradeStatus(msrest.serialization.Model):
    """Properties describing the software upgrade state of the Cache.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar current_firmware_version: Version string of the firmware currently installed on this
     Cache.
    :vartype current_firmware_version: str
    :ivar firmware_update_status: True if there is a firmware update ready to install on this
     Cache. The firmware will automatically be installed after firmwareUpdateDeadline if not
     triggered earlier via the upgrade operation. Possible values include: "available",
     "unavailable".
    :vartype firmware_update_status: str or
     ~storage_cache_management_client.models.FirmwareStatusType
    :ivar firmware_update_deadline: Time at which the pending firmware update will automatically be
     installed on the Cache.
    :vartype firmware_update_deadline: ~datetime.datetime
    :ivar last_firmware_update: Time of the last successful firmware update.
    :vartype last_firmware_update: ~datetime.datetime
    :ivar pending_firmware_version: When firmwareUpdateAvailable is true, this field holds the
     version string for the update.
    :vartype pending_firmware_version: str
    """

    _validation = {
        'current_firmware_version': {'readonly': True},
        'firmware_update_status': {'readonly': True},
        'firmware_update_deadline': {'readonly': True},
        'last_firmware_update': {'readonly': True},
        'pending_firmware_version': {'readonly': True},
    }

    _attribute_map = {
        'current_firmware_version': {'key': 'currentFirmwareVersion', 'type': 'str'},
        'firmware_update_status': {'key': 'firmwareUpdateStatus', 'type': 'str'},
        'firmware_update_deadline': {'key': 'firmwareUpdateDeadline', 'type': 'iso-8601'},
        'last_firmware_update': {'key': 'lastFirmwareUpdate', 'type': 'iso-8601'},
        'pending_firmware_version': {'key': 'pendingFirmwareVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CacheUpgradeStatus, self).__init__(**kwargs)
        self.current_firmware_version = None
        self.firmware_update_status = None
        self.firmware_update_deadline = None
        self.last_firmware_update = None
        self.pending_firmware_version = None


class CacheUsernameDownloadSettings(msrest.serialization.Model):
    """Settings for Extended Groups username and group download.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param extended_groups: Whether or not Extended Groups is enabled.
    :type extended_groups: bool
    :param username_source: This setting determines how the cache gets username and group names for
     clients. Possible values include: "AD", "LDAP", "File", "None". Default value: "None".
    :type username_source: str or ~storage_cache_management_client.models.UsernameSource
    :param group_file_uri: The URI of the file containing group information (in /etc/group file
     format). This field must be populated when 'usernameSource' is set to 'File'.
    :type group_file_uri: str
    :param user_file_uri: The URI of the file containing user information (in /etc/passwd file
     format). This field must be populated when 'usernameSource' is set to 'File'.
    :type user_file_uri: str
    :param ldap_server: The fully qualified domain name or IP address of the LDAP server to use.
    :type ldap_server: str
    :param ldap_base_dn: The base distinguished name for the LDAP domain.
    :type ldap_base_dn: str
    :param encrypt_ldap_connection: Whether or not the LDAP connection should be encrypted.
    :type encrypt_ldap_connection: bool
    :param require_valid_certificate: Determines if the certificates must be validated by a
     certificate authority. When true, caCertificateURI must be provided.
    :type require_valid_certificate: bool
    :param auto_download_certificate: Determines if the certificate should be automatically
     downloaded. This applies to 'caCertificateURI' only if 'requireValidCertificate' is true.
    :type auto_download_certificate: bool
    :param ca_certificate_uri: The URI of the CA certificate to validate the LDAP secure
     connection. This field must be populated when 'requireValidCertificate' is set to true.
    :type ca_certificate_uri: str
    :ivar username_downloaded: Indicates whether or not the HPC Cache has performed the username
     download successfully. Possible values include: "Yes", "No", "Error".
    :vartype username_downloaded: str or
     ~storage_cache_management_client.models.UsernameDownloadedType
    :param credentials: When present, these are the credentials for the secure LDAP connection.
    :type credentials:
     ~storage_cache_management_client.models.CacheUsernameDownloadSettingsCredentials
    """

    _validation = {
        'username_downloaded': {'readonly': True},
    }

    _attribute_map = {
        'extended_groups': {'key': 'extendedGroups', 'type': 'bool'},
        'username_source': {'key': 'usernameSource', 'type': 'str'},
        'group_file_uri': {'key': 'groupFileURI', 'type': 'str'},
        'user_file_uri': {'key': 'userFileURI', 'type': 'str'},
        'ldap_server': {'key': 'ldapServer', 'type': 'str'},
        'ldap_base_dn': {'key': 'ldapBaseDN', 'type': 'str'},
        'encrypt_ldap_connection': {'key': 'encryptLdapConnection', 'type': 'bool'},
        'require_valid_certificate': {'key': 'requireValidCertificate', 'type': 'bool'},
        'auto_download_certificate': {'key': 'autoDownloadCertificate', 'type': 'bool'},
        'ca_certificate_uri': {'key': 'caCertificateURI', 'type': 'str'},
        'username_downloaded': {'key': 'usernameDownloaded', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'CacheUsernameDownloadSettingsCredentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CacheUsernameDownloadSettings, self).__init__(**kwargs)
        self.extended_groups = kwargs.get('extended_groups', None)
        self.username_source = kwargs.get('username_source', "None")
        self.group_file_uri = kwargs.get('group_file_uri', None)
        self.user_file_uri = kwargs.get('user_file_uri', None)
        self.ldap_server = kwargs.get('ldap_server', None)
        self.ldap_base_dn = kwargs.get('ldap_base_dn', None)
        self.encrypt_ldap_connection = kwargs.get('encrypt_ldap_connection', None)
        self.require_valid_certificate = kwargs.get('require_valid_certificate', None)
        self.auto_download_certificate = kwargs.get('auto_download_certificate', None)
        self.ca_certificate_uri = kwargs.get('ca_certificate_uri', None)
        self.username_downloaded = None
        self.credentials = kwargs.get('credentials', None)


class CacheUsernameDownloadSettingsCredentials(msrest.serialization.Model):
    """When present, these are the credentials for the secure LDAP connection.

    :param bind_dn: The Bind Distinguished Name identity to be used in the secure LDAP connection.
     This value is stored encrypted and not returned on response.
    :type bind_dn: str
    :param bind_password: The Bind password to be used in the secure LDAP connection. This value is
     stored encrypted and not returned on response.
    :type bind_password: str
    """

    _attribute_map = {
        'bind_dn': {'key': 'bindDn', 'type': 'str'},
        'bind_password': {'key': 'bindPassword', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CacheUsernameDownloadSettingsCredentials, self).__init__(**kwargs)
        self.bind_dn = kwargs.get('bind_dn', None)
        self.bind_password = kwargs.get('bind_password', None)


class ClfsTarget(msrest.serialization.Model):
    """Properties pertaining to the ClfsTarget.

    :param target: Resource ID of storage container.
    :type target: str
    """

    _attribute_map = {
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClfsTarget, self).__init__(**kwargs)
        self.target = kwargs.get('target', None)


class CloudErrorBody(msrest.serialization.Model):
    """An error response.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param details: A list of additional details about the error.
    :type details: list[~storage_cache_management_client.models.CloudErrorBody]
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    :param target: The target of the particular error. For example, the name of the property in
     error.
    :type target: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.details = kwargs.get('details', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)


class Condition(msrest.serialization.Model):
    """Outstanding conditions that will need to be resolved.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: The time when the condition was raised.
    :vartype timestamp: ~datetime.datetime
    :ivar message: The issue requiring attention.
    :vartype message: str
    """

    _validation = {
        'timestamp': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Condition, self).__init__(**kwargs)
        self.timestamp = None
        self.message = None


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class KeyVaultKeyReference(msrest.serialization.Model):
    """Describes a reference to Key Vault Key.

    All required parameters must be populated in order to send to Azure.

    :param key_url: Required. The URL referencing a key encryption key in Key Vault.
    :type key_url: str
    :param source_vault: Required. Describes a resource Id to source Key Vault.
    :type source_vault: ~storage_cache_management_client.models.KeyVaultKeyReferenceSourceVault
    """

    _validation = {
        'key_url': {'required': True},
        'source_vault': {'required': True},
    }

    _attribute_map = {
        'key_url': {'key': 'keyUrl', 'type': 'str'},
        'source_vault': {'key': 'sourceVault', 'type': 'KeyVaultKeyReferenceSourceVault'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyVaultKeyReference, self).__init__(**kwargs)
        self.key_url = kwargs['key_url']
        self.source_vault = kwargs['source_vault']


class KeyVaultKeyReferenceSourceVault(msrest.serialization.Model):
    """Describes a resource Id to source Key Vault.

    :param id: Resource Id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyVaultKeyReferenceSourceVault, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class MetricDimension(msrest.serialization.Model):
    """Specifications of the Dimension of metrics.

    :param name: Name of the dimension.
    :type name: str
    :param display_name: Localized friendly display name of the dimension.
    :type display_name: str
    :param internal_name: Internal name of the dimension.
    :type internal_name: str
    :param to_be_exported_for_shoebox: To be exported to shoe box.
    :type to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'internal_name': {'key': 'internalName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricDimension, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.internal_name = kwargs.get('internal_name', None)
        self.to_be_exported_for_shoebox = kwargs.get('to_be_exported_for_shoebox', None)


class MetricSpecification(msrest.serialization.Model):
    """Details about operation related to metrics.

    :param name: The name of the metric.
    :type name: str
    :param display_name: Localized display name of the metric.
    :type display_name: str
    :param display_description: The description of the metric.
    :type display_description: str
    :param unit: The unit that the metric is measured in.
    :type unit: str
    :param aggregation_type: The type of metric aggregation.
    :type aggregation_type: str
    :param supported_aggregation_types: Support metric aggregation type.
    :type supported_aggregation_types: list[str or
     ~storage_cache_management_client.models.MetricAggregationType]
    :param metric_class: Type of metrics.
    :type metric_class: str
    :param dimensions: Dimensions of the metric.
    :type dimensions: list[~storage_cache_management_client.models.MetricDimension]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
        'metric_class': {'key': 'metricClass', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[MetricDimension]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.display_description = kwargs.get('display_description', None)
        self.unit = kwargs.get('unit', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.supported_aggregation_types = kwargs.get('supported_aggregation_types', None)
        self.metric_class = kwargs.get('metric_class', None)
        self.dimensions = kwargs.get('dimensions', None)


class NamespaceJunction(msrest.serialization.Model):
    """A namespace junction.

    :param namespace_path: Namespace path on a Cache for a Storage Target.
    :type namespace_path: str
    :param target_path: Path in Storage Target to which namespacePath points.
    :type target_path: str
    :param nfs_export: NFS export where targetPath exists.
    :type nfs_export: str
    :param nfs_access_policy: Name of the access policy applied to this junction.
    :type nfs_access_policy: str
    """

    _attribute_map = {
        'namespace_path': {'key': 'namespacePath', 'type': 'str'},
        'target_path': {'key': 'targetPath', 'type': 'str'},
        'nfs_export': {'key': 'nfsExport', 'type': 'str'},
        'nfs_access_policy': {'key': 'nfsAccessPolicy', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NamespaceJunction, self).__init__(**kwargs)
        self.namespace_path = kwargs.get('namespace_path', None)
        self.target_path = kwargs.get('target_path', None)
        self.nfs_export = kwargs.get('nfs_export', None)
        self.nfs_access_policy = kwargs.get('nfs_access_policy', "default")


class Nfs3Target(msrest.serialization.Model):
    """Properties pertaining to the Nfs3Target.

    :param target: IP address or host name of an NFSv3 host (e.g., 10.0.44.44).
    :type target: str
    :param usage_model: Identifies the StorageCache usage model to be used for this storage target.
    :type usage_model: str
    """

    _validation = {
        'target': {'pattern': r'^[-.,0-9a-zA-Z]+$'},
    }

    _attribute_map = {
        'target': {'key': 'target', 'type': 'str'},
        'usage_model': {'key': 'usageModel', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Nfs3Target, self).__init__(**kwargs)
        self.target = kwargs.get('target', None)
        self.usage_model = kwargs.get('usage_model', None)


class NfsAccessPolicy(msrest.serialization.Model):
    """A set of rules describing access policies applied to NFSv3 clients of the cache.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name identifying this policy. Access Policy names are not case
     sensitive.
    :type name: str
    :param access_rules: Required. The set of rules describing client accesses allowed under this
     policy.
    :type access_rules: list[~storage_cache_management_client.models.NfsAccessRule]
    """

    _validation = {
        'name': {'required': True},
        'access_rules': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'access_rules': {'key': 'accessRules', 'type': '[NfsAccessRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NfsAccessPolicy, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.access_rules = kwargs['access_rules']


class NfsAccessRule(msrest.serialization.Model):
    """Rule to place restrictions on portions of the cache namespace being presented to clients.

    All required parameters must be populated in order to send to Azure.

    :param scope: Required. Scope for this rule. The scope and filter determine which clients match
     the rule. Possible values include: "default", "network", "host".
    :type scope: str or ~storage_cache_management_client.models.NfsAccessRuleScope
    :param filter: Filter applied to the scope for this rule. The filter's format depends on its
     scope. 'default' scope matches all clients and has no filter value. 'network' scope takes a
     filter in CIDR format (for example, 10.99.1.0/24). 'host' takes an IP address or fully
     qualified domain name as filter. If a client does not match any filter rule and there is no
     default rule, access is denied.
    :type filter: str
    :param access: Required. Access allowed by this rule. Possible values include: "no", "ro",
     "rw".
    :type access: str or ~storage_cache_management_client.models.NfsAccessRuleAccess
    :param suid: Allow SUID semantics.
    :type suid: bool
    :param submount_access: For the default policy, allow access to subdirectories under the root
     export. If this is set to no, clients can only mount the path '/'. If set to yes, clients can
     mount a deeper path, like '/a/b'.
    :type submount_access: bool
    :param root_squash: Map root accesses to anonymousUID and anonymousGID.
    :type root_squash: bool
    :param anonymous_uid: UID value that replaces 0 when rootSquash is true. 65534 will be used if
     not provided.
    :type anonymous_uid: str
    :param anonymous_gid: GID value that replaces 0 when rootSquash is true. This will use the
     value of anonymousUID if not provided.
    :type anonymous_gid: str
    """

    _validation = {
        'scope': {'required': True},
        'access': {'required': True},
    }

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'str'},
        'filter': {'key': 'filter', 'type': 'str'},
        'access': {'key': 'access', 'type': 'str'},
        'suid': {'key': 'suid', 'type': 'bool'},
        'submount_access': {'key': 'submountAccess', 'type': 'bool'},
        'root_squash': {'key': 'rootSquash', 'type': 'bool'},
        'anonymous_uid': {'key': 'anonymousUID', 'type': 'str'},
        'anonymous_gid': {'key': 'anonymousGID', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NfsAccessRule, self).__init__(**kwargs)
        self.scope = kwargs['scope']
        self.filter = kwargs.get('filter', None)
        self.access = kwargs['access']
        self.suid = kwargs.get('suid', None)
        self.submount_access = kwargs.get('submount_access', None)
        self.root_squash = kwargs.get('root_squash', None)
        self.anonymous_uid = kwargs.get('anonymous_uid', None)
        self.anonymous_gid = kwargs.get('anonymous_gid', None)


class ResourceSku(msrest.serialization.Model):
    """A resource SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :param capabilities: A list of capabilities of this SKU, such as throughput or ops/sec.
    :type capabilities: list[~storage_cache_management_client.models.ResourceSkuCapabilities]
    :ivar locations: The set of locations where the SKU is available. This is the supported and
     registered Azure Geo Regions (e.g., West US, East US, Southeast Asia, etc.).
    :vartype locations: list[str]
    :param location_info: The set of locations where the SKU is available.
    :type location_info: list[~storage_cache_management_client.models.ResourceSkuLocationInfo]
    :param name: The name of this SKU.
    :type name: str
    :param restrictions: The restrictions preventing this SKU from being used. This is empty if
     there are no restrictions.
    :type restrictions: list[~storage_cache_management_client.models.Restriction]
    """

    _validation = {
        'resource_type': {'readonly': True},
        'locations': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'capabilities': {'key': 'capabilities', 'type': '[ResourceSkuCapabilities]'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'location_info': {'key': 'locationInfo', 'type': '[ResourceSkuLocationInfo]'},
        'name': {'key': 'name', 'type': 'str'},
        'restrictions': {'key': 'restrictions', 'type': '[Restriction]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSku, self).__init__(**kwargs)
        self.resource_type = None
        self.capabilities = kwargs.get('capabilities', None)
        self.locations = None
        self.location_info = kwargs.get('location_info', None)
        self.name = kwargs.get('name', None)
        self.restrictions = kwargs.get('restrictions', None)


class ResourceSkuCapabilities(msrest.serialization.Model):
    """A resource SKU capability.

    :param name: Name of a capability, such as ops/sec.
    :type name: str
    :param value: Quantity, if the capability is measured by quantity.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkuCapabilities, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class ResourceSkuLocationInfo(msrest.serialization.Model):
    """Resource SKU location information.

    :param location: Location where this SKU is available.
    :type location: str
    :param zones: Zones if any.
    :type zones: list[str]
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkuLocationInfo, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.zones = kwargs.get('zones', None)


class ResourceSkusResult(msrest.serialization.Model):
    """The response from the List Cache SKUs operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param next_link: The URI to fetch the next page of Cache SKUs.
    :type next_link: str
    :ivar value: The list of SKUs available for the subscription.
    :vartype value: list[~storage_cache_management_client.models.ResourceSku]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ResourceSku]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkusResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = None


class Restriction(msrest.serialization.Model):
    """The restrictions preventing this SKU from being used.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of restrictions. In this version, the only possible value for this is
     location.
    :vartype type: str
    :ivar values: The value of restrictions. If the restriction type is set to location, then this
     would be the different locations where the SKU is restricted.
    :vartype values: list[str]
    :param reason_code: The reason for the restriction. As of now this can be "QuotaId" or
     "NotAvailableForSubscription". "QuotaId" is set when the SKU has requiredQuotas parameter as
     the subscription does not belong to that quota. "NotAvailableForSubscription" is related to
     capacity at the datacenter. Possible values include: "QuotaId", "NotAvailableForSubscription".
    :type reason_code: str or ~storage_cache_management_client.models.ReasonCode
    """

    _validation = {
        'type': {'readonly': True},
        'values': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
        'reason_code': {'key': 'reasonCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Restriction, self).__init__(**kwargs)
        self.type = None
        self.values = None
        self.reason_code = kwargs.get('reason_code', None)


class StorageTargetResource(msrest.serialization.Model):
    """Resource used by a Cache.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the Storage Target.
    :vartype name: str
    :ivar id: Resource ID of the Storage Target.
    :vartype id: str
    :ivar type: Type of the Storage Target; Microsoft.StorageCache/Cache/StorageTarget.
    :vartype type: str
    :ivar location: Region name string.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~storage_cache_management_client.models.SystemData
    """

    _validation = {
        'name': {'readonly': True, 'pattern': r'^[-0-9a-zA-Z_]{1,80}$'},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageTargetResource, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.location = None
        self.system_data = None


class StorageTarget(StorageTargetResource):
    """Type of the Storage Target.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the Storage Target.
    :vartype name: str
    :ivar id: Resource ID of the Storage Target.
    :vartype id: str
    :ivar type: Type of the Storage Target; Microsoft.StorageCache/Cache/StorageTarget.
    :vartype type: str
    :ivar location: Region name string.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~storage_cache_management_client.models.SystemData
    :param junctions: List of Cache namespace junctions to target for namespace associations.
    :type junctions: list[~storage_cache_management_client.models.NamespaceJunction]
    :param target_type: Type of the Storage Target. Possible values include: "nfs3", "clfs",
     "unknown", "blobNfs".
    :type target_type: str or ~storage_cache_management_client.models.StorageTargetType
    :ivar provisioning_state: ARM provisioning state, see
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property.
     Possible values include: "Succeeded", "Failed", "Cancelled", "Creating", "Deleting",
     "Updating".
    :vartype provisioning_state: str or
     ~storage_cache_management_client.models.ProvisioningStateType
    :param state: Storage target operational state. Possible values include: "Ready", "Busy",
     "Suspended", "Flushing".
    :type state: str or ~storage_cache_management_client.models.OperationalStateType
    :param nfs3: Properties when targetType is nfs3.
    :type nfs3: ~storage_cache_management_client.models.Nfs3Target
    :param clfs: Properties when targetType is clfs.
    :type clfs: ~storage_cache_management_client.models.ClfsTarget
    :param unknown: Properties when targetType is unknown.
    :type unknown: ~storage_cache_management_client.models.UnknownTarget
    :param blob_nfs: Properties when targetType is blobNfs.
    :type blob_nfs: ~storage_cache_management_client.models.BlobNfsTarget
    """

    _validation = {
        'name': {'readonly': True, 'pattern': r'^[-0-9a-zA-Z_]{1,80}$'},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'junctions': {'key': 'properties.junctions', 'type': '[NamespaceJunction]'},
        'target_type': {'key': 'properties.targetType', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'nfs3': {'key': 'properties.nfs3', 'type': 'Nfs3Target'},
        'clfs': {'key': 'properties.clfs', 'type': 'ClfsTarget'},
        'unknown': {'key': 'properties.unknown', 'type': 'UnknownTarget'},
        'blob_nfs': {'key': 'properties.blobNfs', 'type': 'BlobNfsTarget'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageTarget, self).__init__(**kwargs)
        self.junctions = kwargs.get('junctions', None)
        self.target_type = kwargs.get('target_type', None)
        self.provisioning_state = None
        self.state = kwargs.get('state', None)
        self.nfs3 = kwargs.get('nfs3', None)
        self.clfs = kwargs.get('clfs', None)
        self.unknown = kwargs.get('unknown', None)
        self.blob_nfs = kwargs.get('blob_nfs', None)


class StorageTargetsResult(msrest.serialization.Model):
    """A list of Storage Targets.

    :param next_link: The URI to fetch the next page of Storage Targets.
    :type next_link: str
    :param value: The list of Storage Targets defined for the Cache.
    :type value: list[~storage_cache_management_client.models.StorageTarget]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[StorageTarget]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageTargetsResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~storage_cache_management_client.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~storage_cache_management_client.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class UnknownTarget(msrest.serialization.Model):
    """Properties pertaining to the UnknownTarget.

    :param attributes: Dictionary of string->string pairs containing information about the Storage
     Target.
    :type attributes: dict[str, str]
    """

    _attribute_map = {
        'attributes': {'key': 'attributes', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UnknownTarget, self).__init__(**kwargs)
        self.attributes = kwargs.get('attributes', None)


class UsageModel(msrest.serialization.Model):
    """A usage model.

    :param display: Localized information describing this usage model.
    :type display: ~storage_cache_management_client.models.UsageModelDisplay
    :param model_name: Non-localized keyword name for this usage model.
    :type model_name: str
    :param target_type: The type of Storage Target to which this model is applicable (only nfs3 as
     of this version).
    :type target_type: str
    """

    _attribute_map = {
        'display': {'key': 'display', 'type': 'UsageModelDisplay'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'target_type': {'key': 'targetType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageModel, self).__init__(**kwargs)
        self.display = kwargs.get('display', None)
        self.model_name = kwargs.get('model_name', None)
        self.target_type = kwargs.get('target_type', None)


class UsageModelDisplay(msrest.serialization.Model):
    """Localized information describing this usage model.

    :param description: String to display for this usage model.
    :type description: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageModelDisplay, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)


class UsageModelsResult(msrest.serialization.Model):
    """A list of Cache usage models.

    :param next_link: The URI to fetch the next page of Cache usage models.
    :type next_link: str
    :param value: The list of usage models available for the subscription.
    :type value: list[~storage_cache_management_client.models.UsageModel]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[UsageModel]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageModelsResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class UserAssignedIdentitiesValue(msrest.serialization.Model):
    """UserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the user-assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the user-assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserAssignedIdentitiesValue, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
