# -*- coding: utf-8 -*-

#  Copyright © 2013-2015  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os


def po_isempty(pofilename, *, verbose=True):
    try:
        import polib
    except ImportError:
        if verbose:
            print('polib not found, assuming the file %s contains translations' % pofilename)
        return False
    for entry in polib.pofile(pofilename):
        if entry.translated() and entry.msgid != entry.msgstr:
            return False
    return True
    
def modify_file(filename, subs):
    import re
    print('modifying', filename)
    with open(filename, 'rt', encoding='utf-8') as f:
        text = f.read()
    for pattern, repl in subs:
        text = re.sub(pattern, repl, text, count=1, flags=re.MULTILINE)
    # filename may be a hardlink, do not modify the original file
    os.remove(filename)
    with open(filename, 'xt', encoding='utf-8') as f:
        f.write(text)
        

