#ifndef mPaper_DEFINED
#define mPaper_DEFINED

#include <MMotifOnly.hpp>
#include <Paper.h>

class MPaperWidget : public MDrawingArea
{
public:
	void    init(MWidget *parent, const char *name, ...);
	void setPages(PaperRectangle*);
	PaperRectangle* newPage(double,double,double,double);

	void size(int,int);

	void splitSelection(int,int,double=0.0,double=0.0);
	void joinSelection();
	void groupSelection();
	void ungroupSelection();

	Boolean canSplitSelection();
	Boolean canJoinSelection();
	Boolean canGroupSelection();
	Boolean canUngroupSelection();

	PaperRectangle* find(XEvent*);

	PaperRectangle* getPages();

	void update();


	void insetSelection(double,double,double,double);
			
	void setSize(double,double);
	void getSize(double&,double&);

	void alignTop();
	void alignLeft();
	void alignRight();
	void alignBottom();
	void alignHorizontally();
	void alignVertically();
	void distributeHorizontally();
	void distributeVertically();

};

#endif
