/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef IconInfo_H
#define IconInfo_H

#include "Request.h"

class IconInfo 
{
public:
	IconInfo(const Request&);
	IconInfo(const string&);
	IconInfo(const string&,int,int);
	~IconInfo();

	int x() const;
	int y() const;
	void position(int,int);
	void save(const Path&);
	bool fix(const string&);
	string type() {return type_;}
	
	static int undefX() {return undefX_;}
	static int undefY() {return undefY_;}
	static bool validPos(int x,int y);

private:
	// No copy allowed
	IconInfo(const IconInfo&);
	IconInfo& operator=(const IconInfo&);

	bool    modified_;
	Request info_;
	string type_;
	int x_;
	int y_;
	static int undefX_;
	static int undefY_;
	
};

inline void destroy(IconInfo**) {}


#endif
