/* SPDX-License-Identifier: GPL-2.0 */
/* Copyright (C) 2018 - 2020 Intel Corporation */

#ifndef IPU6_PLATFORM_RESOURCES_H
#define IPU6_PLATFORM_RESOURCES_H

#include <linux/kernel.h>
#include <linux/device.h>
#include "ipu-platform-resources.h"

#define	IPU6_FW_PSYS_N_PADDING_UINT8_IN_PROCESS_EXT_STRUCT		0

enum {
	IPU6_FW_PSYS_CMD_QUEUE_COMMAND_ID = 0,
	IPU6_FW_PSYS_CMD_QUEUE_DEVICE_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG0_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG1_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG2_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG3_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG4_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG5_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG6_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG7_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG8_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG9_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG10_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG11_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG12_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG13_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG14_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG15_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG16_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG17_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG18_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG19_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG20_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG21_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG22_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG23_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG24_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG25_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG26_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG27_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG28_COMMAND_ID,
	IPU6_FW_PSYS_CMD_QUEUE_PPG29_COMMAND_ID,
	IPU6_FW_PSYS_N_PSYS_CMD_QUEUE_ID
};

enum {
	IPU6_FW_PSYS_TRANSFER_VMEM0_TYPE_ID = 0,
	IPU6_FW_PSYS_TRANSFER_VMEM1_TYPE_ID,
	IPU6_FW_PSYS_LB_VMEM_TYPE_ID,
	IPU6_FW_PSYS_DMEM_TYPE_ID,
	IPU6_FW_PSYS_VMEM_TYPE_ID,
	IPU6_FW_PSYS_BAMEM_TYPE_ID,
	IPU6_FW_PSYS_PMEM_TYPE_ID,
	IPU6_FW_PSYS_N_MEM_TYPE_ID
};

enum ipu6_mem_id {
	IPU6_FW_PSYS_VMEM0_ID = 0,	/* ISP0 VMEM */
	IPU6_FW_PSYS_TRANSFER_VMEM0_ID,	/* TRANSFER VMEM 0 */
	IPU6_FW_PSYS_TRANSFER_VMEM1_ID,	/* TRANSFER VMEM 1 */
	IPU6_FW_PSYS_LB_VMEM_ID,	/* LB VMEM */
	IPU6_FW_PSYS_BAMEM0_ID,	/* ISP0 BAMEM */
	IPU6_FW_PSYS_DMEM0_ID,	/* SPC0 Dmem */
	IPU6_FW_PSYS_DMEM1_ID,	/* SPP0 Dmem */
	IPU6_FW_PSYS_DMEM2_ID,	/* SPP1 Dmem */
	IPU6_FW_PSYS_DMEM3_ID,	/* ISP0 Dmem */
	IPU6_FW_PSYS_PMEM0_ID,	/* ISP0 PMEM */
	IPU6_FW_PSYS_N_MEM_ID
};

enum {
	IPU6_FW_PSYS_DEV_CHN_DMA_EXT0_ID = 0,
	IPU6_FW_PSYS_DEV_CHN_DMA_EXT1_READ_ID,
	IPU6_FW_PSYS_DEV_CHN_DMA_EXT1_WRITE_ID,
	IPU6_FW_PSYS_DEV_CHN_DMA_INTERNAL_ID,
	IPU6_FW_PSYS_DEV_CHN_DMA_ISA_ID,
	IPU6_FW_PSYS_N_DEV_CHN_ID
};

enum {
	IPU6_FW_PSYS_SP_CTRL_TYPE_ID = 0,
	IPU6_FW_PSYS_SP_SERVER_TYPE_ID,
	IPU6_FW_PSYS_VP_TYPE_ID,
	IPU6_FW_PSYS_ACC_PSA_TYPE_ID,
	IPU6_FW_PSYS_ACC_ISA_TYPE_ID,
	IPU6_FW_PSYS_ACC_OSA_TYPE_ID,
	IPU6_FW_PSYS_GDC_TYPE_ID,
	IPU6_FW_PSYS_TNR_TYPE_ID,
	IPU6_FW_PSYS_N_CELL_TYPE_ID
};

enum {
	IPU6_FW_PSYS_SP0_ID = 0,
	IPU6_FW_PSYS_VP0_ID,
	IPU6_FW_PSYS_PSA_ACC_BNLM_ID,
	IPU6_FW_PSYS_PSA_ACC_DM_ID,
	IPU6_FW_PSYS_PSA_ACC_ACM_ID,
	IPU6_FW_PSYS_PSA_ACC_GTC_YUV1_ID,
	IPU6_FW_PSYS_BB_ACC_OFS_PIN_MAIN_ID,
	IPU6_FW_PSYS_BB_ACC_OFS_PIN_DISPLAY_ID,
	IPU6_FW_PSYS_BB_ACC_OFS_PIN_PP_ID,
	IPU6_FW_PSYS_PSA_ACC_GAMMASTAR_ID,
	IPU6_FW_PSYS_PSA_ACC_GLTM_ID,
	IPU6_FW_PSYS_PSA_ACC_XNR_ID,
	IPU6_FW_PSYS_PSA_VCSC_ID,	/* VCSC */
	IPU6_FW_PSYS_ISA_ICA_ID,
	IPU6_FW_PSYS_ISA_LSC_ID,
	IPU6_FW_PSYS_ISA_DPC_ID,
	IPU6_FW_PSYS_ISA_SIS_A_ID,
	IPU6_FW_PSYS_ISA_SIS_B_ID,
	IPU6_FW_PSYS_ISA_B2B_ID,
	IPU6_FW_PSYS_ISA_B2R_R2I_SIE_ID,
	IPU6_FW_PSYS_ISA_R2I_DS_A_ID,
	IPU6_FW_PSYS_ISA_R2I_DS_B_ID,
	IPU6_FW_PSYS_ISA_AWB_ID,
	IPU6_FW_PSYS_ISA_AE_ID,
	IPU6_FW_PSYS_ISA_AF_ID,
	IPU6_FW_PSYS_ISA_DOL_ID,
	IPU6_FW_PSYS_ISA_ICA_MEDIUM_ID,
	IPU6_FW_PSYS_ISA_X2B_MD_ID,
	IPU6_FW_PSYS_ISA_X2B_SVE_RGBIR_ID,
	IPU6_FW_PSYS_ISA_PAF_ID,
	IPU6_FW_PSYS_BB_ACC_GDC0_ID,
	IPU6_FW_PSYS_BB_ACC_TNR_ID,
	IPU6_FW_PSYS_N_CELL_ID
};

enum {
	IPU6_FW_PSYS_DEV_DFM_BB_FULL_PORT_ID = 0,
	IPU6_FW_PSYS_DEV_DFM_BB_EMPTY_PORT_ID,
	IPU6_FW_PSYS_DEV_DFM_ISL_FULL_PORT_ID,
	IPU6_FW_PSYS_DEV_DFM_ISL_EMPTY_PORT_ID,
	IPU6_FW_PSYS_DEV_DFM_LB_FULL_PORT_ID,
	IPU6_FW_PSYS_DEV_DFM_LB_EMPTY_PORT_ID,
};

/* Excluding PMEM */
#define IPU6_FW_PSYS_N_DATA_MEM_TYPE_ID	(IPU6_FW_PSYS_N_MEM_TYPE_ID - 1)
#define IPU6_FW_PSYS_N_DEV_DFM_ID	\
	(IPU6_FW_PSYS_DEV_DFM_LB_EMPTY_PORT_ID + 1)

#define IPU6_FW_PSYS_VMEM0_MAX_SIZE		0x0800
/* Transfer VMEM0 words, ref HAS Transfer*/
#define IPU6_FW_PSYS_TRANSFER_VMEM0_MAX_SIZE	0x0800
/* Transfer VMEM1 words, ref HAS Transfer*/
#define IPU6_FW_PSYS_TRANSFER_VMEM1_MAX_SIZE	0x0800
#define IPU6_FW_PSYS_LB_VMEM_MAX_SIZE		0x0400	/* LB VMEM words */
#define IPU6_FW_PSYS_BAMEM0_MAX_SIZE		0x0800
#define IPU6_FW_PSYS_DMEM0_MAX_SIZE		0x4000
#define IPU6_FW_PSYS_DMEM1_MAX_SIZE		0x1000
#define IPU6_FW_PSYS_DMEM2_MAX_SIZE		0x1000
#define IPU6_FW_PSYS_DMEM3_MAX_SIZE		0x1000
#define IPU6_FW_PSYS_PMEM0_MAX_SIZE		0x0500

#define IPU6_FW_PSYS_DEV_CHN_DMA_EXT0_MAX_SIZE		30
#define IPU6_FW_PSYS_DEV_CHN_GDC_MAX_SIZE		0
#define IPU6_FW_PSYS_DEV_CHN_DMA_EXT1_READ_MAX_SIZE	30
#define IPU6_FW_PSYS_DEV_CHN_DMA_EXT1_WRITE_MAX_SIZE	43
#define IPU6_FW_PSYS_DEV_CHN_DMA_INTERNAL_MAX_SIZE	8
#define IPU6_FW_PSYS_DEV_CHN_DMA_IPFD_MAX_SIZE		0
#define IPU6_FW_PSYS_DEV_CHN_DMA_ISA_MAX_SIZE		2

#define IPU6_FW_PSYS_DEV_DFM_BB_FULL_PORT_ID_MAX_SIZE		32
#define IPU6_FW_PSYS_DEV_DFM_ISL_FULL_PORT_ID_MAX_SIZE		32
#define IPU6_FW_PSYS_DEV_DFM_LB_FULL_PORT_ID_MAX_SIZE		32
#define IPU6_FW_PSYS_DEV_DFM_BB_EMPTY_PORT_ID_MAX_SIZE		32
#define IPU6_FW_PSYS_DEV_DFM_ISL_EMPTY_PORT_ID_MAX_SIZE		32
#define IPU6_FW_PSYS_DEV_DFM_LB_EMPTY_PORT_ID_MAX_SIZE		32

struct ipu6_fw_psys_program_manifest_ext {
	u32 dfm_port_bitmap[IPU6_FW_PSYS_N_DEV_DFM_ID];
	u32 dfm_active_port_bitmap[IPU6_FW_PSYS_N_DEV_DFM_ID];
	u16 ext_mem_size[IPU6_FW_PSYS_N_DATA_MEM_TYPE_ID];
	u16 ext_mem_offset[IPU6_FW_PSYS_N_DATA_MEM_TYPE_ID];
	u16 dev_chn_size[IPU6_FW_PSYS_N_DEV_CHN_ID];
	u16 dev_chn_offset[IPU6_FW_PSYS_N_DEV_CHN_ID];
	u8 is_dfm_relocatable[IPU6_FW_PSYS_N_DEV_DFM_ID];
	u8 dec_resources_input[IPU_FW_PSYS_MAX_INPUT_DEC_RESOURCES];
	u8 dec_resources_input_terminal[IPU_FW_PSYS_MAX_INPUT_DEC_RESOURCES];
	u8 dec_resources_output[IPU_FW_PSYS_MAX_OUTPUT_DEC_RESOURCES];
	u8 dec_resources_output_terminal[IPU_FW_PSYS_MAX_OUTPUT_DEC_RESOURCES];
	u8 padding[IPU_FW_PSYS_N_PADDING_UINT8_IN_PROGRAM_MANIFEST_EXT];
};

struct ipu6_fw_psys_process_ext {
	u32 dfm_port_bitmap[IPU6_FW_PSYS_N_DEV_DFM_ID];
	u32 dfm_active_port_bitmap[IPU6_FW_PSYS_N_DEV_DFM_ID];
	u16 ext_mem_offset[IPU6_FW_PSYS_N_DATA_MEM_TYPE_ID];
	u16 dev_chn_offset[IPU6_FW_PSYS_N_DEV_CHN_ID];
	u8 ext_mem_id[IPU6_FW_PSYS_N_DATA_MEM_TYPE_ID];
};

#endif /* IPU6_PLATFORM_RESOURCES_H */
