#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("displays the position of the review cursor")

    def run(self):
        # Prefer review cursor over text cursor
        cursor_pos = self.env["runtime"][
            "CursorManager"
        ].get_review_or_text_cursor()

        self.env["runtime"]["OutputManager"].present_text(
            _("line {0}, column {1}, Terminal {2}").format(
                cursor_pos["y"] + 1,
                cursor_pos["x"] + 1,
                self.env["screen"]["newTTY"],
            ),
            interrupt=True,
        )

    def set_callback(self, callback):
        pass
