---
id: Radio
section: components
subsection: forms
cssPrefix: pf-v6-c-radio
propComponents: ['Radio']
ouia: true
---

import { Fragment, useState } from 'react';

## Examples

### Controlled

```ts file="./RadioControlled.tsx"

```

### Uncontrolled

```ts file="./RadioUncontrolled.tsx"

```

### Reversed

```ts file="./RadioReversed.tsx"

```

### Label wraps

You can expand the clickable area of a radio so that it spans wider than the radio label by adding the `isLabelWrapped` property. This allows users to select a radio by clicking the radio itself, the label, or the area between the radio and the label.

```ts file="./RadioLabelWraps.tsx"

```

### Disabled

```ts file="./RadioDisabled.tsx"

```

### With description

```ts file="./RadioWithDescription.tsx"

```

### With body

```ts file="./RadioWithBody.tsx"

```

### With description and body

```ts file="./RadioWithDescriptionAndBody.tsx"

```

### Standalone input

```ts file="./RadioStandaloneInput.tsx"

```
