# D.10 How does capitalism affect technology?

Technology has an obvious effect on individual freedom, in some ways
increasing it, in others restricting it. However, since capitalism is a social
system based on inequalities of power, it is a truism that technology will
reflect those inequalities as it does not develop in a social vacuum. As
Bookchin puts it:

> _"Along side its positive aspects, technological advance has a distinctly
> negative, socially regressive side. If it is true that technological
> progress enlarges the historical potentiality for freedom, it is also true
> that the bourgeois control of technology reinforces the established
> organisation of society and everyday life. Technology and the resources of
> abundance furnish capitalism with the means for assimilating large sections
> of society to the established system of hierarchy and authority . . . By
> their centralistic and bureaucratic tendencies, the resource of abundance
> reinforce the monopolistic, centralistic and bureaucratic tendencies in the
> political apparatus . . . [Technology can be used] for perpetuating
> hierarchy, exploitation and unfreedom."_ [ **Post-Scarcity Anarchism** , p.
> 3]

No technology evolves and spreads unless there are people who benefit from it
and have sufficient means to disseminate it. In a capitalist society,
technologies useful to the rich and powerful are generally the ones that
spread. This can be seen from capitalist industry, where technology has been
implemented specifically to deskill the worker, so replacing the skilled,
valued craftsperson with the easily trained and replaced "mass worker." By
making trying to make any individual worker dispensable, the capitalist hopes
to deprive workers of a means of controlling the relation between their effort
on the job and the pay they receive. In Proudhon's words, the _"machine, or
the workshop, after having degraded the labourer by giving him a master,
completes his degeneracy by reducing him from the rank of artisan to that of
common workman."_ [ **System of Economical Contradictions** , p. 202]

So, unsurprisingly, technology within a hierarchical society will tend to re-
enforce hierarchy and domination. Managers/capitalists will select technology
that will protect and extend their power (and profits), not weaken it. Thus,
while it is often claimed that technology is "neutral" this is not (and can
never be) the case. Simply put, "progress" within a hierarchical system will
reflect the power structures of that system.

As sociologist George Reitzer notes, technological innovation under a
hierarchical system soon results in _"increased control and the replacement of
human with non-human technology. In fact, the replacement of human with non-
human technology is very often motivated by a desire for greater control,
which of course is motivated by the need for profit-maximisation. The great
sources of uncertainty and unpredictability in any rationalising system are
people . . . McDonaldisation involves the search for the means to exert
increasing control over both employees and customers."_ [ **The
McDonaldisation of Society** , p. 100] For Reitzer, capitalism is marked by
the _"irrationality of rationality,"_ in which this process of control results
in a system based on crushing the individuality and humanity of those who live
within it.

In this process of controlling employees for the purpose of maximising profit,
deskilling comes about because skilled labour is more expensive than unskilled
or semi-skilled and skilled workers have more power over their working
conditions and work due to the difficulty in replacing them. Unskilled labour
makes it easier to "rationalise" the production process with methods like
Taylorism, a system of strict production schedules and activities based on the
amount of time (as determined by management) that workers "need" to perform
various operations in the workplace, thus requiring simple, easily analysed
and timed movements. As companies are in competition, each has to copy the
most "efficient" (i.e. profit maximising) production techniques introduced by
the others in order to remain profitable, no matter how dehumanising this may
be for workers. Thus the evil effects of the division of labour and deskilling
becoming widespread. Instead of managing their own work, workers are turned
into human machines in a labour process they do not control, instead being
controlled by those who own the machines they use (see also Harry Braverman,
**Labour and Monopoly Capital: The Degradation of Work in the Twentieth
Century** ).

As Max Stirner noted (echoing Adam Smith), this process of deskilling and
controlling work means that _"[w]hen everyone is to cultivate himself into
man, condemning a man to **machine-like labour** amounts to the same thing as
slavery. . . . Every labour is to have the intent that the man be satisfied.
Therefore he must become a **master** in it too, be able to perform it as a
totality. He who in a pin-factory only puts on heads, only draws the wire,
works, as it were mechanically, like a machine; he remains half-trained, does
not become a master: his labour cannot **satisfy** him, it can only
**fatigue** him. His labour is nothing by itself, has no object **in itself,**
is nothing complete in itself; he labours only into another's hands, and is
**used** (exploited) by this other."_ [ **The Ego and Its Own** , p. 121]
Kropotkin makes a similar argument against the division of labour ( _"machine-
like labour"_ ) in **The Conquest of Bread** (see chapter XV -- _"The Division
of Labour"_ ) as did Proudhon (see chapters III and IV of **System of
Economical Contradictions** ).

Modern industry is set up to ensure that workers do not become "masters" of
their work but instead follow the orders of management. The evolution of
technology lies in the relations of power within a society. This is because
_"the viability of a design is not simply a technical or even economic
evaluation but rather a political one. A technology is deemed viable if it
conforms to the existing relations of power."_ [David Noble, **Progress
without People** , p. 63]

This process of controlling, restricting, and de-individualising labour is a
key feature of capitalism. Work that is skilled and controlled by workers is
empowering to them in two ways. Firstly it gives them pride in their work and
themselves. Secondly, it makes it harder to replace them or suck profits out
of them. Therefore, in order to remove the "subjective" factor (i.e.
individuality and worker control) from the work process, capital needs methods
of controlling the workforce to prevent workers from asserting their
individuality, thus preventing them from arranging their own lives and work
and resisting the authority of the bosses. This need to control workers can be
seen from the type of machinery introduced during the Industrial Revolution.
According to Andrew Ure (author of **Philosophy of Manufactures** ), a
consultant for the factory owners at the time:

> _"In the factories for spinning coarse yarn . . . the mule-spinners [skilled
> workers] have abused their powers beyond endurance, domineering in the most
> arrogant manner . . . over their masters. High wages, instead of leading to
> thankfulness of temper and improvement of mind, have, in too many cases,
> cherished pride and supplied funds for supporting refractory spirits in
> strikes . . . During a disastrous turmoil of [this] kind . . . several of
> the capitalists . . . had recourse to the celebrated machinists . . . of
> Manchester . . . [to construct] a self-acting mule . . . This invention
> confirms the great doctrine already propounded, that when capital enlists
> science in her service, the refractory hand of labour will always be taught
> docility."_ [quoted by Noble, **Op. Cit.** , p. 125]

Proudhon quotes an English Manufacturer who argues the same point:

> _"The insubordination of our workmen has given us the idea of dispensing
> with them. We have made and stimulated every imaginable effort to replace
> the service of men by tools more docile, and we have achieved our object.
> Machinery has delivered capital from the oppression of labour."_ [ **System
> of Economical Contradictions** , p. 189]

It is important to stress that technological innovation was not driven by
reasons of economic efficiency as such but rather to break the power of
workers at the point of production. Once that was done, initially uneconomic
investments could become economically viable. As David Noble summarises,
during the Industrial Revolution _"Capital invested in machines that would
reinforce the system of domination [in the workplace], and this decision to
invest, which might in the long run render the chosen technique economical,
was not itself an economical decision but a political one, with cultural
sanction."_ [ **Op. Cit.** , p. 6]

Needless to say, this use of technology within the class war continued. A
similar process was at work in the US, where the rise in trade unionism
resulted in _"industrial managers bec[oming] even more insistent that skill
and initiative not be left on the shop floor, and that, by the same token,
shop floor workers not have control over the reproduction of relevant skills
through craft-regulated apprenticeship training. Fearful that skilled shop-
floor workers would use their scare resources to reduce their effort and
increase their pay, management deemed that knowledge of the shop-floor process
must reside with the managerial structure."_ [William Lazonick, **Organisation
and Technology in Capitalist Development** , p. 273]

American managers happily embraced Taylorism (aka "scientific management"),
according to which the task of the manager was to gather into his possession
all available knowledge about the work he oversaw and reorganise it. Taylor
himself considered the task for workers was _"to do what they are told to do
promptly and without asking questions or making suggestions."_ [quoted by
David Noble, **American By Design** , p. 268] Taylor also relied exclusively
upon incentive-pay schemes which mechanically linked pay to productivity and
had no appreciation of the subtleties of psychology or sociology (which would
have told him that enjoyment of work and creativity is more important for
people than just higher pay). Unsurprisingly, workers responded to his schemes
by insubordination, sabotage and strikes and it was _"discovered . . . that
the 'time and motion' experts frequently knew very little about the proper
work activities under their supervision, that often they simply guessed at the
optimum rates for given operations . . . it meant that the arbitrary authority
of management has simply been reintroduced in a less apparent form."_ [David
Noble, **Op. Cit.** , p. 272] Although, now, the power of management could
hide begin the "objectivity" of "science."

Katherine Stone also argues that the _"transfer of skill [from the worker to
management] was not a response to the necessities of production, but was,
rather, a strategy to rob workers of their power"_ by _"tak[ing] knowledge and
authority from the skilled workers and creating a management cadre able to
direct production."_ Stone highlights that this deskilling process was
combined by a _"divide and rule"_ policy by management based on wage
incentives and new promotion policies. This created a reward system in which
workers who played by the rules would receive concrete gains in terms of
income and status. Over time, such a structure would become to be seen as
_"the natural way to organise work and one which offered them personal
advancement"_ even though, _"when the system was set up, it was neither
obvious nor rational. The job ladders were created just when the skill
requirements for jobs in the industry were diminishing as a result of the new
technology, and jobs were becoming more and more equal as to the learning time
and responsibility involved."_ The modern structure of the capitalist
workplace was created to break workers resistance to capitalist authority and
was deliberately _"aimed at altering workers' ways of thinking and feeling --
which they did by making workers' individual 'objective' self-interests
congruent with that of the employers and in conflict with workers' collective
self-interest."_ It was a means of _"labour discipline"_ and of _"motivating
workers to work for the employers' gain and preventing workers from uniting to
take back control of production."_ Stone notes that the _"development of the
new labour system in the steel industry was repeated throughout the economy in
different industries. As in the steel industry, the core of these new labour
systems were the creation of artificial job hierarchies and the transfer of
skills from workers to the managers."_ [ _"The Origins of Job Structure in the
Steel Industry,"_ pp. 123-157, Root & Branch (ed.), **Root and Branch: The
Rise of the Workers' Movements** , p. 155, p. 153, p. 152 and pp. 153-4]

This process of deskilling workers was complemented by other factors -- state
protected markets (in the form of tariffs and government orders -- the _"lead
in technological innovation came in armaments where assured government orders
justified high fixed-cost investments"_ ); the use of _"both political and
economic power [by American Capitalists] to eradicate and diffuse workers'
attempts to assert shop-floor control"_ ; and _"repression, instigated and
financed both privately and publicly, to eliminate radical elements [and often
not-so-radical elements as well, we must note] in the American labour
movement."_ [William Lazonick, **Competitive Advantage on the Shop Floor** ,
p. 218 and p. 303] Thus state action played a key role in destroying craft
control within industry, along with the large financial resources of
capitalists compared to workers. Bringing this sorry story up to date, we find
_"many, if not most, American managers are reluctant to develop skills [and
initiative] on the shop floor for the fear of losing control of the flow of
work."_ [William Lazonick, **Organisation and Technology in Capitalist
Development** , pp. 279-280] Nor should we forget that many technologies are
the product of state aid. For example, in the case of automation _"the state,
especially the military, has played a central role. Not only has it subsidised
extravagant developments that the market could not or refused to bear but it
absorbed excessive costs and thereby kept afloat those competitors who would
otherwise have sunk."_ [ **Op. Cit.** , p. 83]

Given that there is a division of knowledge in society (and, obviously, in the
workplace as well) this means that capitalism has selected to introduce a
management and technology mix which leads to inefficiency and waste of
valuable knowledge, experience and skills. Thus the capitalist workplace is
both produced by and is a weapon in the class struggle and reflects the
shifting power relations between workers and employers. The creation of
artificial job hierarchies, the transfer of skills away from workers to
managers and technological development are all products of class struggle.
Thus technological progress and workplace organisation within capitalism have
little to do with "efficiency" and far more to do with profits and power.
_"Capitalism does not utilise a socially nature technology for capitalist
ends,"_ Cornelius Castoriadis correctly argued. It has _"created a capitalist
technology, which is by no means neutral. The real intention of capitalist
technology is not to develop production for production's sake: It is to
subordinate and dominate the producers"_ and _"to eliminate the human element
in productive labour."_ This means that capitalist technologies will evolve,
that there is _"a process of 'natural selection,' affecting technical
inventions as they are applied to industry. Some are preferred to others"_ and
will be _"the ones that fit in with capitalism's basic need to deal with
labour power as a measurable, supervisable, and interchangeable commodity."_
Thus technology will be selected _"within the framework of its own class
rationality."_ [ **Social and Political Writings** , vol. 2, p. 104]

This means that while self-management has consistently proven to be more
efficient (and empowering) than hierarchical management structures, capitalism
actively selects **against** it. This is because capitalism is motivated
purely by increasing the power and profits for the bosses, and both are best
done by disempowering workers and empowering bosses (i.e. the maximisation of
power) -- even though this concentration of power harms efficiency by
distorting and restricting information flow and the gathering and use of
widely distributed knowledge within the firm (as in any command economy) as
well as having a serious impact on the wider economy and social efficiency.
Thus the last refuge of the capitalist or technophile (namely that the
productivity gains of technology outweigh the human costs or the means used to
achieve them) is doubly flawed. Firstly, disempowering technology may maximise
profits, but it need not increase efficient utilisation of resources or
workers' time, skills or potential. Secondly, _"when investment does in fact
generate innovation, does such innovation yield greater productivity? . . .
After conducting a poll of industry executives on trends in automation,
**Business Week** concluded in 1982 that 'there is a heavy backing for capital
investment in a variety of labour-saving technologies that are designed to
fatten profits without necessary adding to productive output.'"_ David Noble
concludes that _"whenever managers are able to use automation to 'fatten
profits' and enhance their authority (by eliminating jobs and extorting
concessions and obedience from the workers who remain) without at the same
time increasing social product, they appear more than ready to do."_ [David
Noble, **Progress Without People** , pp. 86-87 and p. 89] As we argue in
greater detail later, in [section J.5.12](secJ5.md#secj512), efficiency and
profit maximisation are two different things, with such deskilling and
management control actually **reducing** efficiency -- compared to workers'
control -- but as it allows managers to maximise profits the capitalist market
selects it.

Of course the claim is that higher wages follow increased investment and
technological innovation ("in the long run" -- although usually "the long run"
has to be helped to arrive by workers' struggle and protest!). Passing aside
the question of whether slightly increased consumption really makes up for
dehumanising and uncreative work, we must note that it is usually the
capitalist who **really** benefits from technological change in money terms.
For example, between 1920 and 1927 (a period when unemployment caused by
technology became commonplace) the automobile industry (which was at the
forefront of technological change) saw wages rise by 23.7%. Thus, claim
supporters of capitalism, technology is in all our interests. However, capital
surpluses rose by 192.9% during the same period -- 8 times faster! Little
wonder wages rose! Similarly, over the last 20 years the USA and many other
countries have seen companies "down-sizing" and "right-sizing" their workforce
and introducing new technologies. The result? Simply put, the 1970s saw the
start of _"no-wage growth expansions."_ Before the early 1970s, _"real wage
growth tracked the growth of productivity and production in the economy
overall. After . . ., they ceased to do so. . . Real wage growth fell sharply
below measured productivity growth."_ [James K. Galbraith, **Created Unequal**
, p. 79] So while real wages have stagnated, profits have been increasing as
productivity rises and the rich have been getting richer -- technology yet
again showing whose side it is on.

Overall, as David Noble notes (with regards to manufacturing in the early
1990s):

> _"U.S. Manufacturing industry over the last thirty years . . . [has seen]
> the value of capital stock (machinery) relative to labour double, reflecting
> the trend towards mechanisation and automation. As a consequence . . . the
> absolute output person hour increased 115%, more than double. But during
> this same period, real earnings for hourly workers . . . rose only 84%, less
> than double. Thus, after three decades of automation-based progress, workers
> are now earning less relative to their output than before. That is, they are
> producing more for less; working more for their boss and less for
> themselves."_ [ **Op. Cit.** , pp. 92-3]

Noble continues:

> _"For if the impact of automation on workers has not been ambiguous, neither
> has the impact on management and those it serves -- labour's loss has been
> their gain. During the same first thirty years of our age of automation,
> corporate after tax profits have increased 450%, more than five times the
> increase in real earnings for workers."_ [ **Op. Cit.** , p. 95]

But why? Because labour has the ability to produce a flexible amount of output
(use value) for a given wage. Unlike coal or steel, a worker can be made to
work more intensely during a given working period and so technology can be
utilised to maximise that effort as well as increasing the pool of potential
replacements for an employee by deskilling their work (so reducing workers'
power to get higher wages for their work). Thus technology is a key way of
increasing the power of the boss, which in turn can increase output per worker
while ensuring that the workers' receive relatively less of that output back
in terms of wages -- _"Machines,"_ argued Proudhon, _"promised us an increase
of wealth they have kept their word, but at the same time endowing us with an
increase of poverty. They promised us liberty . . . [but] have brought us
slavery."_ [ **Op. Cit.** , p. 199]

But do not get us wrong, technological progress does not imply that we are
victims. Far from it, much innovation is the direct result of our resistance
to hierarchy and its tools. For example, capitalists turned to Taylorism and
"scientific management" in response to the power of skilled craft workers to
control their work and working environment (the famous 1892 Homestead strike,
for example, was a direct product of the desire of the company to end the
skilled workers' control and power on the shop-floor). Such management schemes
never last in the long run nor totally work in the short run either -- which
explains why hierarchical management continues, as does technological
deskilling. Workers always find ways of using new technology to increase their
power within the workplace, undermining management decisions to their own
advantage). As left-wing economist William Lazonick puts it:

> _"Because it is the workers, not managers, who are actually doing the work,
> access to information on the effort-saving potential of a machine will be
> asymmetric, giving workers a distinct advantage in determining the pace of
> work. In addition, workers through their unions will attempt to exert
> industry-wide control over the relation between effort and pay on newly
> diffused technology. The resultant relation between effort and earnings will
> depend on the exercise of social power, not on abstract 'laws' of
> proportional change."_ [ **Competitive Advantage on the Shop Floor** , pp.
> 66-7]

This means that the _"economic effectiveness of the factory as a mode of work
organisation did not occur within a social vacuum but depend[s] on the
historical evolution of conditions that determined the relative power of
capitalists and workers to structure the relation between effort and pay."_ As
such, it is important not to overemphasise the _"independent influence of
technology as opposed to the relations of production in the determination of
work organisation. Because machinery does change the skill content of work, it
can potentially serve as an instrument of social power. How and to what extent
it does so, however, depends not only on the nature of the technology but also
on the nature of the social environment into which it is introduced."_ Thus
the introduction of machinery into the capitalist labour process _"is only a
necessary, not sufficient, condition for the displacement of worker control
over the relation between effort and pay."_ [Lazonick, **Op. Cit.** , p. 52
and p. 63] Needless to say, capitalists have always appealed to the state to
help create a suitable social environment.

This analysis applies to both the formal and informal organisation of workers
in workplace. Just as the informal structures and practices of working people
evolve over time in response to new technology and practices, so does union
organisation. In response to Taylorism, factory and other workers created a
whole new structure of working class power -- a new kind of unionism based on
the industrial level. For example, the IWW was formed specifically to create
industrial unions arguing that _"[l]abourers are no longer classified by
difference in trade skill, but the employer assigns them according to the
machine which they are attached. These divisions, far from representing
differences in skill or interests among the labourers, are imposed by the
employers that workers may be pitted against one another and spurred to
greater exertion in the shop, and that all resistance to capitalist tyranny
may be weakened by artificial distinctions."_ [quoted by Stone, **Op. Cit.** ,
p. 157]

For this reason, anarchists and syndicalists argued for, and built, industrial
unions -- one union per workplace and industry -- in order to combat these
divisions and effectively resist capitalist tyranny. This can be seen in many
different countries. In Spain, the C.N.T. (an anarcho-syndicalist union)
adopted the **sindicato unico** (one union) in 1918 which united all workers
of the same workplace in the same union (by uniting skilled and unskilled in a
single organisation, the union increased their fighting power). In the UK, the
shop stewards movement arose during the first world war based on workplace
organisation (a movement inspired by the pre-war syndicalist revolt and which
included many syndicalist activists). This movement was partly in response to
the reformist TUC unions working with the state during the war to suppress
class struggle. In Germany, the 1919 near revolution saw the creation of
revolutionary workplace unions and councils (and a large increase in the size
of the anarcho-syndicalist union FAU which was organised by industry).

This process was not limited to just libertarian unions. In the USA, the 1930s
saw a massive and militant union organising drive by the C.I.O. based on
industrial unionism and collective bargaining (inspired, in part, by the
example of the I.W.W. and its broad organisation of unskilled workers). More
recently, workers in the 1960s and 70s responded to the increasing reformism
and bureaucratic nature of such unions as the CIO and TUC by organising
themselves directly on the shop floor to control their work and working
conditions. This informal movement expressed itself in wildcat strikes against
both unions and management, sabotage and unofficial workers' control of
production (see John Zerzan's essay _"Organised Labour and the Revolt Against
Work"_ in **Elements of Refusal** ). In the UK, the shop stewards' movement
revived itself, organising much of the unofficial strikes and protests which
occurred in the 1960s and 70s. A similar tendency was seen in many countries
during this period.

So in response to a new developments in technology and workplace organisation,
workers' developed new forms of resistance which in turn provokes a response
by management. Thus technology and its (ab)uses are very much a product of the
class struggle, of the struggle for freedom in the workplace. With a given
technology, workers and radicals soon learn to resist it and, sometimes, use
it in ways never dreamed of to resist their bosses and the state (which
necessitates a transformation of within technology again to try and give the
bosses an upper hand!). The use of the Internet, for example, to organise,
spread and co-ordinate information, resistance and struggles is a classic
example of this process (see Jason Wehling, _"'Netwars' and Activists Power on
the Internet"_ , **Scottish Anarchist** no. 2 for details). There is always a
"guerrilla war" associated with technology, with workers and radicals
developing their own tactics to gain counter control for themselves. Thus much
technological change reflects **our** power and activity to change our own
lives and working conditions. We must never forget that.

While some may dismiss our analysis as "Luddite," to do so is make
"technology" an idol to be worshipped rather than something to be critically
analysed. Indeed, it would be temping to argue that worshippers of
technological progress are, in effect, urging us **not** to think and to
sacrifice ourselves to a new abstraction like the state or capital. Moreover,
such attacks misrepresent the ideas of the Luddites themselves -- they never
actually opposed **all** technology or machinery. Rather, they opposed _"all
Machinery hurtful to Commonality"_ (as a March 1812 letter to a hated
Manufacturer put it). Rather than worship technological progress (or view it
uncritically), the Luddites subjected technology to critical analysis and
evaluation. They opposed those forms of machinery that harmed themselves or
society. Unlike those who smear others as "Luddites," the labourers who broke
machines were not intimidated by the modern notion of progress. As John Clark
notes, they _"chose to smash the dehumanising machinery being imposed on them,
rather than submit to domination and degradation in the name of technical
progress."_ [ **The Anarchist Moment** , p. 102] Their sense of right and
wrong was not clouded by the notion that technology was somehow inevitable,
neutral or to be worshipped without question.

The Luddites did not think that **human** values (or their own interests) were
irrelevant in evaluating the benefits and drawbacks of a given technology and
its effects on workers and society as a whole. Nor did they consider their
skills and livelihood as less important than the profits and power of the
capitalists. In other words, they would have agreed with Proudhon's later
comment that machinery _"plays the leading role in industry, man is
secondary"_ **and** they acted to change this relationship. [ **Op. Cit.** ,
p. 204] The Luddites were an example of working people deciding what their
interests were and acting to defend them by their own direct action -- in this
case opposing technology which benefited the ruling class by giving them an
edge in the class struggle. Anarchists follow this critical approach to
technology, recognising that it is not neutral nor above criticism. That this
is simply sensible can be seen from the world around us, where capitalism has,
to quote Rocker, made work _"soulless and has lost for the individual the
quality of creative joy. By becoming a dreary end-in-itself it has degraded
man into an eternal galley slave and robbed him of that which is most
precious, the inner joy of accomplished work, the creative urge of the
personality. The individual feels himself to be only an insignificant element
of a gigantic mechanism in whose dull monotone every personal note dies out."_
He has _"became the slave of the tool he created."_ There has been a _"growth
of technology at the expense of human personality."_ [ **Nationalism and
Culture** , p. 253 and p. 254]

For capital, the source of problems in industry is people. Unlike machines,
people can think, feel, dream, hope and act. The "evolution" of technology
must, therefore, reflect the class struggle within society and the struggle
for liberty against the forces of authority. Technology, far from being
neutral, reflects the interests of those with power. Technology will only be
truly our friend once we control it ourselves and **modify** to reflect
**human** values (this may mean that some forms of technology will have to be
written off and replaces by new forms in a free society). Until that happens,
most technological processes -- regardless of the other advantages they may
have -- will be used to exploit and control people. Thus Proudhon's comments
that _"in the present condition of society, the workshop with its hierarchical
organisation, and machinery"_ could only serve _"exclusively the interests of
the least numerous, the least industrious, and the wealthiest class"_ rather
than _"be employed for the benefit of all."_ [ **Op. Cit.** , p. 205]

While resisting technological "progress" which is considered harmful to people
or the planet (by means up to and including machine breaking) is essential in
the here and now, the issue of technology can only be truly solved when those
who use a given technology control its development, introduction and use. (
_"The worker will only respect machinery **on the day** when it becomes his
friend, shortening his work, rather than as **today** , his enemy, taking away
jobs, killing workers,"_ in the words of French syndicalist Emile Pouget
[quoted by David Noble, **Op. Cit.** , p. 15]). Little wonder, therefore, that
anarchists consider workers' self-management as a key means of solving the
problems created by technology. Proudhon, for example, argued that the
solution to the problems created by the division of labour and technology
could only be solved by _"association"_ , and _"by a broad education, by the
obligation of apprenticeship, and by the co-operation of all who take part in
the collective work."_ This would ensure that _"the division of labour can no
longer be a cause of degradation for the workman [or workwoman]."_ [ **The
General Idea of the Revolution** , p. 223]

While as far as technology goes, it may not be enough to get rid of the boss
this is a necessary first step. Unless this is done, it will be impossible to
transform existing technologies or create new ones which enhance freedom
rather than controlling and shaping the worker (or user in general) and
enhancing the power and profits of the capitalist. This means that in an
anarchist society, technology would have to be transformed and/or developed
which empowered those who used it, so reducing any oppressive aspects of it.
In the words of Cornelius Castoriadis, the _"conscious transformation of
technology will therefore be a central task of a society of free workers."_ [
**Op. Cit.** , p. 104] As German anarchist Gustav Landauer stressed, most are
_"completely unaware of how fundamentally the technology of the socialists
differs from capitalist technology . . . Technology will, in a cultured
people, have to be directed to the psychology of free people who want to use
it."_ This will happen when _"the workers themselves determine under what
conditions they want to work,"_ step out of _"capitalism mentally and
physically"_ , and _"cease playing a role in it and begin to be men [and
women]."_ [ _"For Socialism,"_ pp. 184-6, **Anarchism** , Robert Graham (ed.),
p. 285 and p. 286]

Thus most anarchists would agree with Bookchin's comment that technology _"is
necessarily liberatory or consistently beneficial to man's development"_ but
we _"do not believe that man is destined to be enslaved by technology and
technological modes of thought."_ A free society _"will not want to negate
technology precisely because it is liberated and can strike a balance"_ and
create a _"technology for life,"_ a liberatory technology based on human and
ecological needs. [ **Op. Cit.** , p. 43 and p. 80] See [section
I.4.9](secI4.md#seci49) for more discussion on technology within an
anarchist society.

[‹ D.9 Why does political power become concentrated under
capitalism?](secD9.md "Go to previous page") [up](secDcon.md "Go to parent
page") [D.11 Can politics and economics be separated from each other?
›](secD11.md "Go to next page")

