//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `trace!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn trace() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::trace!(ident = 3); // DEBUG:trace,-,-,-,-,"ident","3"
    tracing::trace!(foo = true, ident = 3); // DEBUG:trace,-,-,p,-,"ident","3"
    tracing::trace!(ident = 3, qux = 3); // DEBUG:trace,-,-,f,-,"ident","3"
    tracing::trace!(foo = true, ident = 3, qux = 3); // DEBUG:trace,-,-,pf,-,"ident","3"
    tracing::trace!(ident = 3, "msg without args"); // DEBUG:trace,-,-,-,m,"ident","3"
    tracing::trace!(foo = true, ident = 3, "msg without args"); // DEBUG:trace,-,-,p,m,"ident","3"
    tracing::trace!(ident = 3, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"ident","3"
    tracing::trace!(foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"ident","3"
    tracing::trace!({ ident = 3 }, "msg without args"); // DEBUG:trace,-,{},-,m,"ident","3"
    tracing::trace!({ foo = true, ident = 3 }, "msg without args"); // DEBUG:trace,-,{},p,m,"ident","3"
    tracing::trace!({ ident = 3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"ident","3"
    tracing::trace!({ foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"ident","3"
    tracing::trace!(ident = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"ident","3"
    tracing::trace!(foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"ident","3"
    tracing::trace!(ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"ident","3"
    tracing::trace!(foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"ident","3"
    tracing::trace!({ ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"ident","3"
    tracing::trace!({ foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"ident","3"
    tracing::trace!({ ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"ident","3"
    tracing::trace!({ foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"ident","3"
    tracing::trace!(ident = false); // DEBUG:trace,-,-,-,-,"ident","false"
    tracing::trace!(foo = true, ident = false); // DEBUG:trace,-,-,p,-,"ident","false"
    tracing::trace!(ident = false, qux = 3); // DEBUG:trace,-,-,f,-,"ident","false"
    tracing::trace!(foo = true, ident = false, qux = 3); // DEBUG:trace,-,-,pf,-,"ident","false"
    tracing::trace!(ident = false, "msg without args"); // DEBUG:trace,-,-,-,m,"ident","false"
    tracing::trace!(foo = true, ident = false, "msg without args"); // DEBUG:trace,-,-,p,m,"ident","false"
    tracing::trace!(ident = false, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"ident","false"
    tracing::trace!(foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"ident","false"
    tracing::trace!({ ident = false }, "msg without args"); // DEBUG:trace,-,{},-,m,"ident","false"
    tracing::trace!({ foo = true, ident = false }, "msg without args"); // DEBUG:trace,-,{},p,m,"ident","false"
    tracing::trace!({ ident = false, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"ident","false"
    tracing::trace!({ foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"ident","false"
    tracing::trace!(ident = false, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"ident","false"
    tracing::trace!(foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"ident","false"
    tracing::trace!(ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"ident","false"
    tracing::trace!(foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"ident","false"
    tracing::trace!({ ident = false }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"ident","false"
    tracing::trace!({ foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"ident","false"
    tracing::trace!({ ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"ident","false"
    tracing::trace!({ foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"ident","false"
    tracing::trace!(ident = ?3); // DEBUG:trace,-,-,-,-,"ident","?3"
    tracing::trace!(foo = true, ident = ?3); // DEBUG:trace,-,-,p,-,"ident","?3"
    tracing::trace!(ident = ?3, qux = 3); // DEBUG:trace,-,-,f,-,"ident","?3"
    tracing::trace!(foo = true, ident = ?3, qux = 3); // DEBUG:trace,-,-,pf,-,"ident","?3"
    tracing::trace!(ident = ?3, "msg without args"); // DEBUG:trace,-,-,-,m,"ident","?3"
    tracing::trace!(foo = true, ident = ?3, "msg without args"); // DEBUG:trace,-,-,p,m,"ident","?3"
    tracing::trace!(ident = ?3, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"ident","?3"
    tracing::trace!(foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"ident","?3"
    tracing::trace!({ ident = ?3 }, "msg without args"); // DEBUG:trace,-,{},-,m,"ident","?3"
    tracing::trace!({ foo = true, ident = ?3 }, "msg without args"); // DEBUG:trace,-,{},p,m,"ident","?3"
    tracing::trace!({ ident = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"ident","?3"
    tracing::trace!({ foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"ident","?3"
    tracing::trace!(ident = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"ident","?3"
    tracing::trace!(foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"ident","?3"
    tracing::trace!(ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"ident","?3"
    tracing::trace!(foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"ident","?3"
    tracing::trace!({ ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"ident","?3"
    tracing::trace!({ foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"ident","?3"
    tracing::trace!({ ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"ident","?3"
    tracing::trace!({ foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"ident","?3"
    tracing::trace!(ident = %3); // DEBUG:trace,-,-,-,-,"ident","%3"
    tracing::trace!(foo = true, ident = %3); // DEBUG:trace,-,-,p,-,"ident","%3"
    tracing::trace!(ident = %3, qux = 3); // DEBUG:trace,-,-,f,-,"ident","%3"
    tracing::trace!(foo = true, ident = %3, qux = 3); // DEBUG:trace,-,-,pf,-,"ident","%3"
    tracing::trace!(ident = %3, "msg without args"); // DEBUG:trace,-,-,-,m,"ident","%3"
    tracing::trace!(foo = true, ident = %3, "msg without args"); // DEBUG:trace,-,-,p,m,"ident","%3"
    tracing::trace!(ident = %3, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"ident","%3"
    tracing::trace!(foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"ident","%3"
    tracing::trace!({ ident = %3 }, "msg without args"); // DEBUG:trace,-,{},-,m,"ident","%3"
    tracing::trace!({ foo = true, ident = %3 }, "msg without args"); // DEBUG:trace,-,{},p,m,"ident","%3"
    tracing::trace!({ ident = %3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"ident","%3"
    tracing::trace!({ foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"ident","%3"
    tracing::trace!(ident = %3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"ident","%3"
    tracing::trace!(foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"ident","%3"
    tracing::trace!(ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"ident","%3"
    tracing::trace!(foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"ident","%3"
    tracing::trace!({ ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"ident","%3"
    tracing::trace!({ foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"ident","%3"
    tracing::trace!({ ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"ident","%3"
    tracing::trace!({ foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"ident","%3"
    tracing::trace!(ident = ?deb); // DEBUG:trace,-,-,-,-,"ident","?deb"
    tracing::trace!(foo = true, ident = ?deb); // DEBUG:trace,-,-,p,-,"ident","?deb"
    tracing::trace!(ident = ?deb, qux = 3); // DEBUG:trace,-,-,f,-,"ident","?deb"
    tracing::trace!(foo = true, ident = ?deb, qux = 3); // DEBUG:trace,-,-,pf,-,"ident","?deb"
    tracing::trace!(ident = ?deb, "msg without args"); // DEBUG:trace,-,-,-,m,"ident","?deb"
    tracing::trace!(foo = true, ident = ?deb, "msg without args"); // DEBUG:trace,-,-,p,m,"ident","?deb"
    tracing::trace!(ident = ?deb, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"ident","?deb"
    tracing::trace!(foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"ident","?deb"
    tracing::trace!({ ident = ?deb }, "msg without args"); // DEBUG:trace,-,{},-,m,"ident","?deb"
    tracing::trace!({ foo = true, ident = ?deb }, "msg without args"); // DEBUG:trace,-,{},p,m,"ident","?deb"
    tracing::trace!({ ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"ident","?deb"
    tracing::trace!({ foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"ident","?deb"
    tracing::trace!(ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"ident","?deb"
    tracing::trace!(foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"ident","?deb"
    tracing::trace!(ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"ident","?deb"
    tracing::trace!(foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"ident","?deb"
    tracing::trace!({ ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"ident","?deb"
    tracing::trace!({ foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"ident","?deb"
    tracing::trace!({ ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"ident","?deb"
    tracing::trace!({ foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"ident","?deb"
    tracing::trace!(ident = %disp); // DEBUG:trace,-,-,-,-,"ident","%disp"
    tracing::trace!(foo = true, ident = %disp); // DEBUG:trace,-,-,p,-,"ident","%disp"
    tracing::trace!(ident = %disp, qux = 3); // DEBUG:trace,-,-,f,-,"ident","%disp"
    tracing::trace!(foo = true, ident = %disp, qux = 3); // DEBUG:trace,-,-,pf,-,"ident","%disp"
    tracing::trace!(ident = %disp, "msg without args"); // DEBUG:trace,-,-,-,m,"ident","%disp"
    tracing::trace!(foo = true, ident = %disp, "msg without args"); // DEBUG:trace,-,-,p,m,"ident","%disp"
    tracing::trace!(ident = %disp, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"ident","%disp"
    tracing::trace!(foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"ident","%disp"
    tracing::trace!({ ident = %disp }, "msg without args"); // DEBUG:trace,-,{},-,m,"ident","%disp"
    tracing::trace!({ foo = true, ident = %disp }, "msg without args"); // DEBUG:trace,-,{},p,m,"ident","%disp"
    tracing::trace!({ ident = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"ident","%disp"
    tracing::trace!({ foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"ident","%disp"
    tracing::trace!(ident = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"ident","%disp"
    tracing::trace!(foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"ident","%disp"
    tracing::trace!(ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"ident","%disp"
    tracing::trace!(foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"ident","%disp"
    tracing::trace!({ ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"ident","%disp"
    tracing::trace!({ foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"ident","%disp"
    tracing::trace!({ ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"ident","%disp"
    tracing::trace!({ foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"ident","%disp"
    tracing::trace!(ident = ?sub.field); // DEBUG:trace,-,-,-,-,"ident","?sub.field"
    tracing::trace!(foo = true, ident = ?sub.field); // DEBUG:trace,-,-,p,-,"ident","?sub.field"
    tracing::trace!(ident = ?sub.field, qux = 3); // DEBUG:trace,-,-,f,-,"ident","?sub.field"
    tracing::trace!(foo = true, ident = ?sub.field, qux = 3); // DEBUG:trace,-,-,pf,-,"ident","?sub.field"
    tracing::trace!(ident = ?sub.field, "msg without args"); // DEBUG:trace,-,-,-,m,"ident","?sub.field"
    tracing::trace!(foo = true, ident = ?sub.field, "msg without args"); // DEBUG:trace,-,-,p,m,"ident","?sub.field"
    tracing::trace!(ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"ident","?sub.field"
    tracing::trace!(foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"ident","?sub.field"
    tracing::trace!({ ident = ?sub.field }, "msg without args"); // DEBUG:trace,-,{},-,m,"ident","?sub.field"
    tracing::trace!({ foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:trace,-,{},p,m,"ident","?sub.field"
    tracing::trace!({ ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"ident","?sub.field"
    tracing::trace!({ foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"ident","?sub.field"
    tracing::trace!(ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"ident","?sub.field"
    tracing::trace!(foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"ident","?sub.field"
    tracing::trace!(ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"ident","?sub.field"
    tracing::trace!(foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"ident","?sub.field"
    tracing::trace!({ ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"ident","?sub.field"
    tracing::trace!({ foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"ident","?sub.field"
    tracing::trace!({ ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"ident","?sub.field"
    tracing::trace!({ foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"ident","?sub.field"
    tracing::trace!(ident = %sub.field); // DEBUG:trace,-,-,-,-,"ident","%sub.field"
    tracing::trace!(foo = true, ident = %sub.field); // DEBUG:trace,-,-,p,-,"ident","%sub.field"
    tracing::trace!(ident = %sub.field, qux = 3); // DEBUG:trace,-,-,f,-,"ident","%sub.field"
    tracing::trace!(foo = true, ident = %sub.field, qux = 3); // DEBUG:trace,-,-,pf,-,"ident","%sub.field"
    tracing::trace!(ident = %sub.field, "msg without args"); // DEBUG:trace,-,-,-,m,"ident","%sub.field"
    tracing::trace!(foo = true, ident = %sub.field, "msg without args"); // DEBUG:trace,-,-,p,m,"ident","%sub.field"
    tracing::trace!(ident = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"ident","%sub.field"
    tracing::trace!(foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"ident","%sub.field"
    tracing::trace!({ ident = %sub.field }, "msg without args"); // DEBUG:trace,-,{},-,m,"ident","%sub.field"
    tracing::trace!({ foo = true, ident = %sub.field }, "msg without args"); // DEBUG:trace,-,{},p,m,"ident","%sub.field"
    tracing::trace!({ ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"ident","%sub.field"
    tracing::trace!({ foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"ident","%sub.field"
    tracing::trace!(ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"ident","%sub.field"
    tracing::trace!(foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"ident","%sub.field"
    tracing::trace!(ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"ident","%sub.field"
    tracing::trace!(foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"ident","%sub.field"
    tracing::trace!({ ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"ident","%sub.field"
    tracing::trace!({ foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"ident","%sub.field"
    tracing::trace!({ ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"ident","%sub.field"
    tracing::trace!({ foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"ident","%sub.field"
    tracing::trace!(ident = debug(&deb)); // DEBUG:trace,-,-,-,-,"ident","debug(&deb)"
    tracing::trace!(foo = true, ident = debug(&deb)); // DEBUG:trace,-,-,p,-,"ident","debug(&deb)"
    tracing::trace!(ident = debug(&deb), qux = 3); // DEBUG:trace,-,-,f,-,"ident","debug(&deb)"
    tracing::trace!(foo = true, ident = debug(&deb), qux = 3); // DEBUG:trace,-,-,pf,-,"ident","debug(&deb)"
    tracing::trace!(ident = debug(&deb), "msg without args"); // DEBUG:trace,-,-,-,m,"ident","debug(&deb)"
    tracing::trace!(foo = true, ident = debug(&deb), "msg without args"); // DEBUG:trace,-,-,p,m,"ident","debug(&deb)"
    tracing::trace!(ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"ident","debug(&deb)"
    tracing::trace!(foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"ident","debug(&deb)"
    tracing::trace!({ ident = debug(&deb) }, "msg without args"); // DEBUG:trace,-,{},-,m,"ident","debug(&deb)"
    tracing::trace!({ foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:trace,-,{},p,m,"ident","debug(&deb)"
    tracing::trace!({ ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"ident","debug(&deb)"
    tracing::trace!({ foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"ident","debug(&deb)"
    tracing::trace!(ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"ident","debug(&deb)"
    tracing::trace!(foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"ident","debug(&deb)"
    tracing::trace!(ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"ident","debug(&deb)"
    tracing::trace!(foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"ident","debug(&deb)"
    tracing::trace!({ ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"ident","debug(&deb)"
    tracing::trace!({ foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"ident","debug(&deb)"
    tracing::trace!({ ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"ident","debug(&deb)"
    tracing::trace!({ foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"ident","debug(&deb)"
    tracing::trace!(ident = display(&disp)); // DEBUG:trace,-,-,-,-,"ident","display(&disp)"
    tracing::trace!(foo = true, ident = display(&disp)); // DEBUG:trace,-,-,p,-,"ident","display(&disp)"
    tracing::trace!(ident = display(&disp), qux = 3); // DEBUG:trace,-,-,f,-,"ident","display(&disp)"
    tracing::trace!(foo = true, ident = display(&disp), qux = 3); // DEBUG:trace,-,-,pf,-,"ident","display(&disp)"
    tracing::trace!(ident = display(&disp), "msg without args"); // DEBUG:trace,-,-,-,m,"ident","display(&disp)"
    tracing::trace!(foo = true, ident = display(&disp), "msg without args"); // DEBUG:trace,-,-,p,m,"ident","display(&disp)"
    tracing::trace!(ident = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"ident","display(&disp)"
    tracing::trace!(foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"ident","display(&disp)"
    tracing::trace!({ ident = display(&disp) }, "msg without args"); // DEBUG:trace,-,{},-,m,"ident","display(&disp)"
    tracing::trace!({ foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:trace,-,{},p,m,"ident","display(&disp)"
    tracing::trace!({ ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"ident","display(&disp)"
    tracing::trace!({ foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"ident","display(&disp)"
    tracing::trace!(ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"ident","display(&disp)"
    tracing::trace!(foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"ident","display(&disp)"
    tracing::trace!(ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"ident","display(&disp)"
    tracing::trace!(foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"ident","display(&disp)"
    tracing::trace!({ ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"ident","display(&disp)"
    tracing::trace!({ foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"ident","display(&disp)"
    tracing::trace!({ ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"ident","display(&disp)"
    tracing::trace!({ foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"ident","display(&disp)"
    tracing::trace!(ident = tracing::field::Empty); // DEBUG:trace,-,-,-,-,"ident","tracing::field::Empty"
    tracing::trace!(foo = true, ident = tracing::field::Empty); // DEBUG:trace,-,-,p,-,"ident","tracing::field::Empty"
    tracing::trace!(ident = tracing::field::Empty, qux = 3); // DEBUG:trace,-,-,f,-,"ident","tracing::field::Empty"
    tracing::trace!(foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:trace,-,-,pf,-,"ident","tracing::field::Empty"
    tracing::trace!(ident = tracing::field::Empty, "msg without args"); // DEBUG:trace,-,-,-,m,"ident","tracing::field::Empty"
    tracing::trace!(foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:trace,-,-,p,m,"ident","tracing::field::Empty"
    tracing::trace!(ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"ident","tracing::field::Empty"
    tracing::trace!(foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"ident","tracing::field::Empty"
    tracing::trace!({ ident = tracing::field::Empty }, "msg without args"); // DEBUG:trace,-,{},-,m,"ident","tracing::field::Empty"
    tracing::trace!({ foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:trace,-,{},p,m,"ident","tracing::field::Empty"
    tracing::trace!({ ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"ident","tracing::field::Empty"
    tracing::trace!({ foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"ident","tracing::field::Empty"
    tracing::trace!(ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"ident","tracing::field::Empty"
    tracing::trace!(foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"ident","tracing::field::Empty"
    tracing::trace!(ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"ident","tracing::field::Empty"
    tracing::trace!(foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"ident","tracing::field::Empty"
    tracing::trace!({ ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"ident","tracing::field::Empty"
    tracing::trace!({ foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"ident","tracing::field::Empty"
    tracing::trace!({ ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"ident","tracing::field::Empty"
    tracing::trace!({ foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"ident","tracing::field::Empty"
    tracing::trace!(dotted.ident = 3); // DEBUG:trace,-,-,-,-,"dotted.ident","3"
    tracing::trace!(foo = true, dotted.ident = 3); // DEBUG:trace,-,-,p,-,"dotted.ident","3"
    tracing::trace!(dotted.ident = 3, qux = 3); // DEBUG:trace,-,-,f,-,"dotted.ident","3"
    tracing::trace!(foo = true, dotted.ident = 3, qux = 3); // DEBUG:trace,-,-,pf,-,"dotted.ident","3"
    tracing::trace!(dotted.ident = 3, "msg without args"); // DEBUG:trace,-,-,-,m,"dotted.ident","3"
    tracing::trace!(foo = true, dotted.ident = 3, "msg without args"); // DEBUG:trace,-,-,p,m,"dotted.ident","3"
    tracing::trace!(dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"dotted.ident","3"
    tracing::trace!(foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"dotted.ident","3"
    tracing::trace!({ dotted.ident = 3 }, "msg without args"); // DEBUG:trace,-,{},-,m,"dotted.ident","3"
    tracing::trace!({ foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:trace,-,{},p,m,"dotted.ident","3"
    tracing::trace!({ dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"dotted.ident","3"
    tracing::trace!({ foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"dotted.ident","3"
    tracing::trace!(dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"dotted.ident","3"
    tracing::trace!(foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"dotted.ident","3"
    tracing::trace!(dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"dotted.ident","3"
    tracing::trace!(foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"dotted.ident","3"
    tracing::trace!({ dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"dotted.ident","3"
    tracing::trace!({ foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"dotted.ident","3"
    tracing::trace!({ dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"dotted.ident","3"
    tracing::trace!({ foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"dotted.ident","3"
    tracing::trace!(dotted.ident = false); // DEBUG:trace,-,-,-,-,"dotted.ident","false"
    tracing::trace!(foo = true, dotted.ident = false); // DEBUG:trace,-,-,p,-,"dotted.ident","false"
    tracing::trace!(dotted.ident = false, qux = 3); // DEBUG:trace,-,-,f,-,"dotted.ident","false"
    tracing::trace!(foo = true, dotted.ident = false, qux = 3); // DEBUG:trace,-,-,pf,-,"dotted.ident","false"
    tracing::trace!(dotted.ident = false, "msg without args"); // DEBUG:trace,-,-,-,m,"dotted.ident","false"
    tracing::trace!(foo = true, dotted.ident = false, "msg without args"); // DEBUG:trace,-,-,p,m,"dotted.ident","false"
    tracing::trace!(dotted.ident = false, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"dotted.ident","false"
    tracing::trace!(foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"dotted.ident","false"
    tracing::trace!({ dotted.ident = false }, "msg without args"); // DEBUG:trace,-,{},-,m,"dotted.ident","false"
    tracing::trace!({ foo = true, dotted.ident = false }, "msg without args"); // DEBUG:trace,-,{},p,m,"dotted.ident","false"
    tracing::trace!({ dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"dotted.ident","false"
    tracing::trace!({ foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"dotted.ident","false"
    tracing::trace!(dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"dotted.ident","false"
    tracing::trace!(foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"dotted.ident","false"
    tracing::trace!(dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"dotted.ident","false"
    tracing::trace!(foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"dotted.ident","false"
    tracing::trace!({ dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"dotted.ident","false"
    tracing::trace!({ foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"dotted.ident","false"
    tracing::trace!({ dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"dotted.ident","false"
    tracing::trace!({ foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"dotted.ident","false"
    tracing::trace!(dotted.ident = ?3); // DEBUG:trace,-,-,-,-,"dotted.ident","?3"
    tracing::trace!(foo = true, dotted.ident = ?3); // DEBUG:trace,-,-,p,-,"dotted.ident","?3"
    tracing::trace!(dotted.ident = ?3, qux = 3); // DEBUG:trace,-,-,f,-,"dotted.ident","?3"
    tracing::trace!(foo = true, dotted.ident = ?3, qux = 3); // DEBUG:trace,-,-,pf,-,"dotted.ident","?3"
    tracing::trace!(dotted.ident = ?3, "msg without args"); // DEBUG:trace,-,-,-,m,"dotted.ident","?3"
    tracing::trace!(foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:trace,-,-,p,m,"dotted.ident","?3"
    tracing::trace!(dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"dotted.ident","?3"
    tracing::trace!(foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"dotted.ident","?3"
    tracing::trace!({ dotted.ident = ?3 }, "msg without args"); // DEBUG:trace,-,{},-,m,"dotted.ident","?3"
    tracing::trace!({ foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:trace,-,{},p,m,"dotted.ident","?3"
    tracing::trace!({ dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"dotted.ident","?3"
    tracing::trace!({ foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"dotted.ident","?3"
    tracing::trace!(dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"dotted.ident","?3"
    tracing::trace!(foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"dotted.ident","?3"
    tracing::trace!(dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"dotted.ident","?3"
    tracing::trace!(foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"dotted.ident","?3"
    tracing::trace!({ dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"dotted.ident","?3"
    tracing::trace!({ foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"dotted.ident","?3"
    tracing::trace!({ dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"dotted.ident","?3"
    tracing::trace!({ foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"dotted.ident","?3"
    tracing::trace!(dotted.ident = %3); // DEBUG:trace,-,-,-,-,"dotted.ident","%3"
    tracing::trace!(foo = true, dotted.ident = %3); // DEBUG:trace,-,-,p,-,"dotted.ident","%3"
    tracing::trace!(dotted.ident = %3, qux = 3); // DEBUG:trace,-,-,f,-,"dotted.ident","%3"
    tracing::trace!(foo = true, dotted.ident = %3, qux = 3); // DEBUG:trace,-,-,pf,-,"dotted.ident","%3"
    tracing::trace!(dotted.ident = %3, "msg without args"); // DEBUG:trace,-,-,-,m,"dotted.ident","%3"
    tracing::trace!(foo = true, dotted.ident = %3, "msg without args"); // DEBUG:trace,-,-,p,m,"dotted.ident","%3"
    tracing::trace!(dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"dotted.ident","%3"
    tracing::trace!(foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"dotted.ident","%3"
    tracing::trace!({ dotted.ident = %3 }, "msg without args"); // DEBUG:trace,-,{},-,m,"dotted.ident","%3"
    tracing::trace!({ foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:trace,-,{},p,m,"dotted.ident","%3"
    tracing::trace!({ dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"dotted.ident","%3"
    tracing::trace!({ foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"dotted.ident","%3"
    tracing::trace!(dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"dotted.ident","%3"
    tracing::trace!(foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"dotted.ident","%3"
    tracing::trace!(dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"dotted.ident","%3"
    tracing::trace!(foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"dotted.ident","%3"
    tracing::trace!({ dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"dotted.ident","%3"
    tracing::trace!({ foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"dotted.ident","%3"
    tracing::trace!({ dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"dotted.ident","%3"
    tracing::trace!({ foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"dotted.ident","%3"
    tracing::trace!(dotted.ident = ?deb); // DEBUG:trace,-,-,-,-,"dotted.ident","?deb"
    tracing::trace!(foo = true, dotted.ident = ?deb); // DEBUG:trace,-,-,p,-,"dotted.ident","?deb"
    tracing::trace!(dotted.ident = ?deb, qux = 3); // DEBUG:trace,-,-,f,-,"dotted.ident","?deb"
    tracing::trace!(foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:trace,-,-,pf,-,"dotted.ident","?deb"
    tracing::trace!(dotted.ident = ?deb, "msg without args"); // DEBUG:trace,-,-,-,m,"dotted.ident","?deb"
    tracing::trace!(foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:trace,-,-,p,m,"dotted.ident","?deb"
    tracing::trace!(dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"dotted.ident","?deb"
    tracing::trace!(foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"dotted.ident","?deb"
    tracing::trace!({ dotted.ident = ?deb }, "msg without args"); // DEBUG:trace,-,{},-,m,"dotted.ident","?deb"
    tracing::trace!({ foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:trace,-,{},p,m,"dotted.ident","?deb"
    tracing::trace!({ dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"dotted.ident","?deb"
    tracing::trace!({ foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"dotted.ident","?deb"
    tracing::trace!(dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"dotted.ident","?deb"
    tracing::trace!(foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"dotted.ident","?deb"
    tracing::trace!(dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"dotted.ident","?deb"
    tracing::trace!(foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"dotted.ident","?deb"
    tracing::trace!({ dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"dotted.ident","?deb"
    tracing::trace!({ foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"dotted.ident","?deb"
    tracing::trace!({ dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"dotted.ident","?deb"
    tracing::trace!({ foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"dotted.ident","?deb"
    tracing::trace!(dotted.ident = %disp); // DEBUG:trace,-,-,-,-,"dotted.ident","%disp"
    tracing::trace!(foo = true, dotted.ident = %disp); // DEBUG:trace,-,-,p,-,"dotted.ident","%disp"
    tracing::trace!(dotted.ident = %disp, qux = 3); // DEBUG:trace,-,-,f,-,"dotted.ident","%disp"
    tracing::trace!(foo = true, dotted.ident = %disp, qux = 3); // DEBUG:trace,-,-,pf,-,"dotted.ident","%disp"
    tracing::trace!(dotted.ident = %disp, "msg without args"); // DEBUG:trace,-,-,-,m,"dotted.ident","%disp"
    tracing::trace!(foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:trace,-,-,p,m,"dotted.ident","%disp"
    tracing::trace!(dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"dotted.ident","%disp"
    tracing::trace!(foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"dotted.ident","%disp"
    tracing::trace!({ dotted.ident = %disp }, "msg without args"); // DEBUG:trace,-,{},-,m,"dotted.ident","%disp"
    tracing::trace!({ foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:trace,-,{},p,m,"dotted.ident","%disp"
    tracing::trace!({ dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"dotted.ident","%disp"
    tracing::trace!({ foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"dotted.ident","%disp"
    tracing::trace!(dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"dotted.ident","%disp"
    tracing::trace!(foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"dotted.ident","%disp"
    tracing::trace!(dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"dotted.ident","%disp"
    tracing::trace!(foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"dotted.ident","%disp"
    tracing::trace!({ dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"dotted.ident","%disp"
    tracing::trace!({ foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"dotted.ident","%disp"
    tracing::trace!({ dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"dotted.ident","%disp"
    tracing::trace!({ foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"dotted.ident","%disp"
    tracing::trace!(dotted.ident = ?sub.field); // DEBUG:trace,-,-,-,-,"dotted.ident","?sub.field"
    tracing::trace!(foo = true, dotted.ident = ?sub.field); // DEBUG:trace,-,-,p,-,"dotted.ident","?sub.field"
    tracing::trace!(dotted.ident = ?sub.field, qux = 3); // DEBUG:trace,-,-,f,-,"dotted.ident","?sub.field"
    tracing::trace!(foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:trace,-,-,pf,-,"dotted.ident","?sub.field"
    tracing::trace!(dotted.ident = ?sub.field, "msg without args"); // DEBUG:trace,-,-,-,m,"dotted.ident","?sub.field"
    tracing::trace!(foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:trace,-,-,p,m,"dotted.ident","?sub.field"
    tracing::trace!(dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"dotted.ident","?sub.field"
    tracing::trace!(foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"dotted.ident","?sub.field"
    tracing::trace!({ dotted.ident = ?sub.field }, "msg without args"); // DEBUG:trace,-,{},-,m,"dotted.ident","?sub.field"
    tracing::trace!({ foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:trace,-,{},p,m,"dotted.ident","?sub.field"
    tracing::trace!({ dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"dotted.ident","?sub.field"
    tracing::trace!({ foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"dotted.ident","?sub.field"
    tracing::trace!(dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"dotted.ident","?sub.field"
    tracing::trace!(foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"dotted.ident","?sub.field"
    tracing::trace!(dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"dotted.ident","?sub.field"
    tracing::trace!(foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"dotted.ident","?sub.field"
    tracing::trace!({ dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"dotted.ident","?sub.field"
    tracing::trace!({ foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"dotted.ident","?sub.field"
    tracing::trace!({ dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"dotted.ident","?sub.field"
    tracing::trace!({ foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"dotted.ident","?sub.field"
    tracing::trace!(dotted.ident = %sub.field); // DEBUG:trace,-,-,-,-,"dotted.ident","%sub.field"
    tracing::trace!(foo = true, dotted.ident = %sub.field); // DEBUG:trace,-,-,p,-,"dotted.ident","%sub.field"
    tracing::trace!(dotted.ident = %sub.field, qux = 3); // DEBUG:trace,-,-,f,-,"dotted.ident","%sub.field"
    tracing::trace!(foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:trace,-,-,pf,-,"dotted.ident","%sub.field"
    tracing::trace!(dotted.ident = %sub.field, "msg without args"); // DEBUG:trace,-,-,-,m,"dotted.ident","%sub.field"
    tracing::trace!(foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:trace,-,-,p,m,"dotted.ident","%sub.field"
    tracing::trace!(dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"dotted.ident","%sub.field"
    tracing::trace!(foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"dotted.ident","%sub.field"
    tracing::trace!({ dotted.ident = %sub.field }, "msg without args"); // DEBUG:trace,-,{},-,m,"dotted.ident","%sub.field"
    tracing::trace!({ foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:trace,-,{},p,m,"dotted.ident","%sub.field"
    tracing::trace!({ dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"dotted.ident","%sub.field"
    tracing::trace!({ foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"dotted.ident","%sub.field"
    tracing::trace!(dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"dotted.ident","%sub.field"
    tracing::trace!(foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"dotted.ident","%sub.field"
    tracing::trace!(dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"dotted.ident","%sub.field"
    tracing::trace!(foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"dotted.ident","%sub.field"
    tracing::trace!({ dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"dotted.ident","%sub.field"
    tracing::trace!({ foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"dotted.ident","%sub.field"
    tracing::trace!({ dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"dotted.ident","%sub.field"
    tracing::trace!({ foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"dotted.ident","%sub.field"
    tracing::trace!(dotted.ident = debug(&deb)); // DEBUG:trace,-,-,-,-,"dotted.ident","debug(&deb)"
    tracing::trace!(foo = true, dotted.ident = debug(&deb)); // DEBUG:trace,-,-,p,-,"dotted.ident","debug(&deb)"
    tracing::trace!(dotted.ident = debug(&deb), qux = 3); // DEBUG:trace,-,-,f,-,"dotted.ident","debug(&deb)"
    tracing::trace!(foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:trace,-,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::trace!(dotted.ident = debug(&deb), "msg without args"); // DEBUG:trace,-,-,-,m,"dotted.ident","debug(&deb)"
    tracing::trace!(foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:trace,-,-,p,m,"dotted.ident","debug(&deb)"
    tracing::trace!(dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"dotted.ident","debug(&deb)"
    tracing::trace!(foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::trace!({ dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:trace,-,{},-,m,"dotted.ident","debug(&deb)"
    tracing::trace!({ foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:trace,-,{},p,m,"dotted.ident","debug(&deb)"
    tracing::trace!({ dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"dotted.ident","debug(&deb)"
    tracing::trace!({ foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::trace!(dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::trace!(foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::trace!(dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::trace!(foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::trace!({ dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::trace!({ foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::trace!({ dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::trace!({ foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::trace!(dotted.ident = display(&disp)); // DEBUG:trace,-,-,-,-,"dotted.ident","display(&disp)"
    tracing::trace!(foo = true, dotted.ident = display(&disp)); // DEBUG:trace,-,-,p,-,"dotted.ident","display(&disp)"
    tracing::trace!(dotted.ident = display(&disp), qux = 3); // DEBUG:trace,-,-,f,-,"dotted.ident","display(&disp)"
    tracing::trace!(foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:trace,-,-,pf,-,"dotted.ident","display(&disp)"
    tracing::trace!(dotted.ident = display(&disp), "msg without args"); // DEBUG:trace,-,-,-,m,"dotted.ident","display(&disp)"
    tracing::trace!(foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:trace,-,-,p,m,"dotted.ident","display(&disp)"
    tracing::trace!(dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"dotted.ident","display(&disp)"
    tracing::trace!(foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"dotted.ident","display(&disp)"
    tracing::trace!({ dotted.ident = display(&disp) }, "msg without args"); // DEBUG:trace,-,{},-,m,"dotted.ident","display(&disp)"
    tracing::trace!({ foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:trace,-,{},p,m,"dotted.ident","display(&disp)"
    tracing::trace!({ dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"dotted.ident","display(&disp)"
    tracing::trace!({ foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"dotted.ident","display(&disp)"
    tracing::trace!(dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"dotted.ident","display(&disp)"
    tracing::trace!(foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"dotted.ident","display(&disp)"
    tracing::trace!(dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"dotted.ident","display(&disp)"
    tracing::trace!(foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::trace!({ dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"dotted.ident","display(&disp)"
    tracing::trace!({ foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"dotted.ident","display(&disp)"
    tracing::trace!({ dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"dotted.ident","display(&disp)"
    tracing::trace!({ foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::trace!(dotted.ident = tracing::field::Empty); // DEBUG:trace,-,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::trace!(foo = true, dotted.ident = tracing::field::Empty); // DEBUG:trace,-,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::trace!(dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:trace,-,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::trace!(foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:trace,-,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::trace!(dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:trace,-,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::trace!(foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:trace,-,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::trace!(dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::trace!(foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::trace!({ dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:trace,-,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::trace!({ foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:trace,-,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::trace!({ dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::trace!({ foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::trace!(dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::trace!(foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::trace!(dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::trace!(foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::trace!({ dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::trace!({ foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::trace!({ dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::trace!({ foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::trace!("literal" = 3); // DEBUG:trace,-,-,-,-,"\"literal\"","3"
    tracing::trace!(foo = true, "literal" = 3); // DEBUG:trace,-,-,p,-,"\"literal\"","3"
    tracing::trace!("literal" = 3, qux = 3); // DEBUG:trace,-,-,f,-,"\"literal\"","3"
    tracing::trace!(foo = true, "literal" = 3, qux = 3); // DEBUG:trace,-,-,pf,-,"\"literal\"","3"
    tracing::trace!("literal" = 3, "msg without args"); // DEBUG:trace,-,-,-,m,"\"literal\"","3"
    tracing::trace!(foo = true, "literal" = 3, "msg without args"); // DEBUG:trace,-,-,p,m,"\"literal\"","3"
    tracing::trace!("literal" = 3, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"\"literal\"","3"
    tracing::trace!(foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"\"literal\"","3"
    tracing::trace!({ "literal" = 3 }, "msg without args"); // DEBUG:trace,-,{},-,m,"\"literal\"","3"
    tracing::trace!({ foo = true, "literal" = 3 }, "msg without args"); // DEBUG:trace,-,{},p,m,"\"literal\"","3"
    tracing::trace!({ "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"\"literal\"","3"
    tracing::trace!({ foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"\"literal\"","3"
    tracing::trace!("literal" = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"\"literal\"","3"
    tracing::trace!(foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"\"literal\"","3"
    tracing::trace!("literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"\"literal\"","3"
    tracing::trace!(foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"\"literal\"","3"
    tracing::trace!({ "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"\"literal\"","3"
    tracing::trace!({ foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"\"literal\"","3"
    tracing::trace!({ "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"\"literal\"","3"
    tracing::trace!({ foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"\"literal\"","3"
    tracing::trace!("literal" = false); // DEBUG:trace,-,-,-,-,"\"literal\"","false"
    tracing::trace!(foo = true, "literal" = false); // DEBUG:trace,-,-,p,-,"\"literal\"","false"
    tracing::trace!("literal" = false, qux = 3); // DEBUG:trace,-,-,f,-,"\"literal\"","false"
    tracing::trace!(foo = true, "literal" = false, qux = 3); // DEBUG:trace,-,-,pf,-,"\"literal\"","false"
    tracing::trace!("literal" = false, "msg without args"); // DEBUG:trace,-,-,-,m,"\"literal\"","false"
    tracing::trace!(foo = true, "literal" = false, "msg without args"); // DEBUG:trace,-,-,p,m,"\"literal\"","false"
    tracing::trace!("literal" = false, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"\"literal\"","false"
    tracing::trace!(foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"\"literal\"","false"
    tracing::trace!({ "literal" = false }, "msg without args"); // DEBUG:trace,-,{},-,m,"\"literal\"","false"
    tracing::trace!({ foo = true, "literal" = false }, "msg without args"); // DEBUG:trace,-,{},p,m,"\"literal\"","false"
    tracing::trace!({ "literal" = false, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"\"literal\"","false"
    tracing::trace!({ foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"\"literal\"","false"
    tracing::trace!("literal" = false, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"\"literal\"","false"
    tracing::trace!(foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"\"literal\"","false"
    tracing::trace!("literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"\"literal\"","false"
    tracing::trace!(foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"\"literal\"","false"
    tracing::trace!({ "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"\"literal\"","false"
    tracing::trace!({ foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"\"literal\"","false"
    tracing::trace!({ "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"\"literal\"","false"
    tracing::trace!({ foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"\"literal\"","false"
    tracing::trace!("literal" = ?3); // DEBUG:trace,-,-,-,-,"\"literal\"","?3"
    tracing::trace!(foo = true, "literal" = ?3); // DEBUG:trace,-,-,p,-,"\"literal\"","?3"
    tracing::trace!("literal" = ?3, qux = 3); // DEBUG:trace,-,-,f,-,"\"literal\"","?3"
    tracing::trace!(foo = true, "literal" = ?3, qux = 3); // DEBUG:trace,-,-,pf,-,"\"literal\"","?3"
    tracing::trace!("literal" = ?3, "msg without args"); // DEBUG:trace,-,-,-,m,"\"literal\"","?3"
    tracing::trace!(foo = true, "literal" = ?3, "msg without args"); // DEBUG:trace,-,-,p,m,"\"literal\"","?3"
    tracing::trace!("literal" = ?3, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"\"literal\"","?3"
    tracing::trace!(foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"\"literal\"","?3"
    tracing::trace!({ "literal" = ?3 }, "msg without args"); // DEBUG:trace,-,{},-,m,"\"literal\"","?3"
    tracing::trace!({ foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:trace,-,{},p,m,"\"literal\"","?3"
    tracing::trace!({ "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"\"literal\"","?3"
    tracing::trace!({ foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"\"literal\"","?3"
    tracing::trace!("literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"\"literal\"","?3"
    tracing::trace!(foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"\"literal\"","?3"
    tracing::trace!("literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"\"literal\"","?3"
    tracing::trace!(foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"\"literal\"","?3"
    tracing::trace!({ "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"\"literal\"","?3"
    tracing::trace!({ foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"\"literal\"","?3"
    tracing::trace!({ "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"\"literal\"","?3"
    tracing::trace!({ foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"\"literal\"","?3"
    tracing::trace!("literal" = %3); // DEBUG:trace,-,-,-,-,"\"literal\"","%3"
    tracing::trace!(foo = true, "literal" = %3); // DEBUG:trace,-,-,p,-,"\"literal\"","%3"
    tracing::trace!("literal" = %3, qux = 3); // DEBUG:trace,-,-,f,-,"\"literal\"","%3"
    tracing::trace!(foo = true, "literal" = %3, qux = 3); // DEBUG:trace,-,-,pf,-,"\"literal\"","%3"
    tracing::trace!("literal" = %3, "msg without args"); // DEBUG:trace,-,-,-,m,"\"literal\"","%3"
    tracing::trace!(foo = true, "literal" = %3, "msg without args"); // DEBUG:trace,-,-,p,m,"\"literal\"","%3"
    tracing::trace!("literal" = %3, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"\"literal\"","%3"
    tracing::trace!(foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"\"literal\"","%3"
    tracing::trace!({ "literal" = %3 }, "msg without args"); // DEBUG:trace,-,{},-,m,"\"literal\"","%3"
    tracing::trace!({ foo = true, "literal" = %3 }, "msg without args"); // DEBUG:trace,-,{},p,m,"\"literal\"","%3"
    tracing::trace!({ "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"\"literal\"","%3"
    tracing::trace!({ foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"\"literal\"","%3"
    tracing::trace!("literal" = %3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"\"literal\"","%3"
    tracing::trace!(foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"\"literal\"","%3"
    tracing::trace!("literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"\"literal\"","%3"
    tracing::trace!(foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"\"literal\"","%3"
    tracing::trace!({ "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"\"literal\"","%3"
    tracing::trace!({ foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"\"literal\"","%3"
    tracing::trace!({ "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"\"literal\"","%3"
    tracing::trace!({ foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"\"literal\"","%3"
    tracing::trace!("literal" = ?deb); // DEBUG:trace,-,-,-,-,"\"literal\"","?deb"
    tracing::trace!(foo = true, "literal" = ?deb); // DEBUG:trace,-,-,p,-,"\"literal\"","?deb"
    tracing::trace!("literal" = ?deb, qux = 3); // DEBUG:trace,-,-,f,-,"\"literal\"","?deb"
    tracing::trace!(foo = true, "literal" = ?deb, qux = 3); // DEBUG:trace,-,-,pf,-,"\"literal\"","?deb"
    tracing::trace!("literal" = ?deb, "msg without args"); // DEBUG:trace,-,-,-,m,"\"literal\"","?deb"
    tracing::trace!(foo = true, "literal" = ?deb, "msg without args"); // DEBUG:trace,-,-,p,m,"\"literal\"","?deb"
    tracing::trace!("literal" = ?deb, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"\"literal\"","?deb"
    tracing::trace!(foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"\"literal\"","?deb"
    tracing::trace!({ "literal" = ?deb }, "msg without args"); // DEBUG:trace,-,{},-,m,"\"literal\"","?deb"
    tracing::trace!({ foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:trace,-,{},p,m,"\"literal\"","?deb"
    tracing::trace!({ "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"\"literal\"","?deb"
    tracing::trace!({ foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"\"literal\"","?deb"
    tracing::trace!("literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"\"literal\"","?deb"
    tracing::trace!(foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"\"literal\"","?deb"
    tracing::trace!("literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"\"literal\"","?deb"
    tracing::trace!(foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"\"literal\"","?deb"
    tracing::trace!({ "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"\"literal\"","?deb"
    tracing::trace!({ foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"\"literal\"","?deb"
    tracing::trace!({ "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"\"literal\"","?deb"
    tracing::trace!({ foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"\"literal\"","?deb"
    tracing::trace!("literal" = %disp); // DEBUG:trace,-,-,-,-,"\"literal\"","%disp"
    tracing::trace!(foo = true, "literal" = %disp); // DEBUG:trace,-,-,p,-,"\"literal\"","%disp"
    tracing::trace!("literal" = %disp, qux = 3); // DEBUG:trace,-,-,f,-,"\"literal\"","%disp"
    tracing::trace!(foo = true, "literal" = %disp, qux = 3); // DEBUG:trace,-,-,pf,-,"\"literal\"","%disp"
    tracing::trace!("literal" = %disp, "msg without args"); // DEBUG:trace,-,-,-,m,"\"literal\"","%disp"
    tracing::trace!(foo = true, "literal" = %disp, "msg without args"); // DEBUG:trace,-,-,p,m,"\"literal\"","%disp"
    tracing::trace!("literal" = %disp, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"\"literal\"","%disp"
    tracing::trace!(foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"\"literal\"","%disp"
    tracing::trace!({ "literal" = %disp }, "msg without args"); // DEBUG:trace,-,{},-,m,"\"literal\"","%disp"
    tracing::trace!({ foo = true, "literal" = %disp }, "msg without args"); // DEBUG:trace,-,{},p,m,"\"literal\"","%disp"
    tracing::trace!({ "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"\"literal\"","%disp"
    tracing::trace!({ foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"\"literal\"","%disp"
    tracing::trace!("literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"\"literal\"","%disp"
    tracing::trace!(foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"\"literal\"","%disp"
    tracing::trace!("literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"\"literal\"","%disp"
    tracing::trace!(foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"\"literal\"","%disp"
    tracing::trace!({ "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"\"literal\"","%disp"
    tracing::trace!({ foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"\"literal\"","%disp"
    tracing::trace!({ "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"\"literal\"","%disp"
    tracing::trace!({ foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"\"literal\"","%disp"
    tracing::trace!("literal" = ?sub.field); // DEBUG:trace,-,-,-,-,"\"literal\"","?sub.field"
    tracing::trace!(foo = true, "literal" = ?sub.field); // DEBUG:trace,-,-,p,-,"\"literal\"","?sub.field"
    tracing::trace!("literal" = ?sub.field, qux = 3); // DEBUG:trace,-,-,f,-,"\"literal\"","?sub.field"
    tracing::trace!(foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:trace,-,-,pf,-,"\"literal\"","?sub.field"
    tracing::trace!("literal" = ?sub.field, "msg without args"); // DEBUG:trace,-,-,-,m,"\"literal\"","?sub.field"
    tracing::trace!(foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:trace,-,-,p,m,"\"literal\"","?sub.field"
    tracing::trace!("literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"\"literal\"","?sub.field"
    tracing::trace!(foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"\"literal\"","?sub.field"
    tracing::trace!({ "literal" = ?sub.field }, "msg without args"); // DEBUG:trace,-,{},-,m,"\"literal\"","?sub.field"
    tracing::trace!({ foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:trace,-,{},p,m,"\"literal\"","?sub.field"
    tracing::trace!({ "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"\"literal\"","?sub.field"
    tracing::trace!({ foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"\"literal\"","?sub.field"
    tracing::trace!("literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"\"literal\"","?sub.field"
    tracing::trace!(foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"\"literal\"","?sub.field"
    tracing::trace!("literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"\"literal\"","?sub.field"
    tracing::trace!(foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"\"literal\"","?sub.field"
    tracing::trace!({ "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"\"literal\"","?sub.field"
    tracing::trace!({ foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"\"literal\"","?sub.field"
    tracing::trace!({ "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"\"literal\"","?sub.field"
    tracing::trace!({ foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"\"literal\"","?sub.field"
    tracing::trace!("literal" = %sub.field); // DEBUG:trace,-,-,-,-,"\"literal\"","%sub.field"
    tracing::trace!(foo = true, "literal" = %sub.field); // DEBUG:trace,-,-,p,-,"\"literal\"","%sub.field"
    tracing::trace!("literal" = %sub.field, qux = 3); // DEBUG:trace,-,-,f,-,"\"literal\"","%sub.field"
    tracing::trace!(foo = true, "literal" = %sub.field, qux = 3); // DEBUG:trace,-,-,pf,-,"\"literal\"","%sub.field"
    tracing::trace!("literal" = %sub.field, "msg without args"); // DEBUG:trace,-,-,-,m,"\"literal\"","%sub.field"
    tracing::trace!(foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:trace,-,-,p,m,"\"literal\"","%sub.field"
    tracing::trace!("literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"\"literal\"","%sub.field"
    tracing::trace!(foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"\"literal\"","%sub.field"
    tracing::trace!({ "literal" = %sub.field }, "msg without args"); // DEBUG:trace,-,{},-,m,"\"literal\"","%sub.field"
    tracing::trace!({ foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:trace,-,{},p,m,"\"literal\"","%sub.field"
    tracing::trace!({ "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"\"literal\"","%sub.field"
    tracing::trace!({ foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"\"literal\"","%sub.field"
    tracing::trace!("literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"\"literal\"","%sub.field"
    tracing::trace!(foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"\"literal\"","%sub.field"
    tracing::trace!("literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"\"literal\"","%sub.field"
    tracing::trace!(foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"\"literal\"","%sub.field"
    tracing::trace!({ "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"\"literal\"","%sub.field"
    tracing::trace!({ foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"\"literal\"","%sub.field"
    tracing::trace!({ "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"\"literal\"","%sub.field"
    tracing::trace!({ foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"\"literal\"","%sub.field"
    tracing::trace!("literal" = debug(&deb)); // DEBUG:trace,-,-,-,-,"\"literal\"","debug(&deb)"
    tracing::trace!(foo = true, "literal" = debug(&deb)); // DEBUG:trace,-,-,p,-,"\"literal\"","debug(&deb)"
    tracing::trace!("literal" = debug(&deb), qux = 3); // DEBUG:trace,-,-,f,-,"\"literal\"","debug(&deb)"
    tracing::trace!(foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:trace,-,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::trace!("literal" = debug(&deb), "msg without args"); // DEBUG:trace,-,-,-,m,"\"literal\"","debug(&deb)"
    tracing::trace!(foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:trace,-,-,p,m,"\"literal\"","debug(&deb)"
    tracing::trace!("literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"\"literal\"","debug(&deb)"
    tracing::trace!(foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::trace!({ "literal" = debug(&deb) }, "msg without args"); // DEBUG:trace,-,{},-,m,"\"literal\"","debug(&deb)"
    tracing::trace!({ foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:trace,-,{},p,m,"\"literal\"","debug(&deb)"
    tracing::trace!({ "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"\"literal\"","debug(&deb)"
    tracing::trace!({ foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::trace!("literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::trace!(foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::trace!("literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::trace!(foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::trace!({ "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::trace!({ foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::trace!({ "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::trace!({ foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::trace!("literal" = display(&disp)); // DEBUG:trace,-,-,-,-,"\"literal\"","display(&disp)"
    tracing::trace!(foo = true, "literal" = display(&disp)); // DEBUG:trace,-,-,p,-,"\"literal\"","display(&disp)"
    tracing::trace!("literal" = display(&disp), qux = 3); // DEBUG:trace,-,-,f,-,"\"literal\"","display(&disp)"
    tracing::trace!(foo = true, "literal" = display(&disp), qux = 3); // DEBUG:trace,-,-,pf,-,"\"literal\"","display(&disp)"
    tracing::trace!("literal" = display(&disp), "msg without args"); // DEBUG:trace,-,-,-,m,"\"literal\"","display(&disp)"
    tracing::trace!(foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:trace,-,-,p,m,"\"literal\"","display(&disp)"
    tracing::trace!("literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"\"literal\"","display(&disp)"
    tracing::trace!(foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"\"literal\"","display(&disp)"
    tracing::trace!({ "literal" = display(&disp) }, "msg without args"); // DEBUG:trace,-,{},-,m,"\"literal\"","display(&disp)"
    tracing::trace!({ foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:trace,-,{},p,m,"\"literal\"","display(&disp)"
    tracing::trace!({ "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"\"literal\"","display(&disp)"
    tracing::trace!({ foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"\"literal\"","display(&disp)"
    tracing::trace!("literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"\"literal\"","display(&disp)"
    tracing::trace!(foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"\"literal\"","display(&disp)"
    tracing::trace!("literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"\"literal\"","display(&disp)"
    tracing::trace!(foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::trace!({ "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"\"literal\"","display(&disp)"
    tracing::trace!({ foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"\"literal\"","display(&disp)"
    tracing::trace!({ "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"\"literal\"","display(&disp)"
    tracing::trace!({ foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::trace!("literal" = tracing::field::Empty); // DEBUG:trace,-,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::trace!(foo = true, "literal" = tracing::field::Empty); // DEBUG:trace,-,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::trace!("literal" = tracing::field::Empty, qux = 3); // DEBUG:trace,-,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::trace!(foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:trace,-,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::trace!("literal" = tracing::field::Empty, "msg without args"); // DEBUG:trace,-,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::trace!(foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:trace,-,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::trace!("literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::trace!(foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::trace!({ "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:trace,-,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::trace!({ foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:trace,-,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::trace!({ "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::trace!({ foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::trace!("literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::trace!(foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::trace!("literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::trace!(foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::trace!({ "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::trace!({ foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::trace!({ "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::trace!({ foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::trace!({ CONST_VAR } = 3); // DEBUG:trace,-,-,-,-,"{ CONST_VAR }","3"
    tracing::trace!(foo = true, { CONST_VAR } = 3); // DEBUG:trace,-,-,p,-,"{ CONST_VAR }","3"
    tracing::trace!({ CONST_VAR } = 3, qux = 3); // DEBUG:trace,-,-,f,-,"{ CONST_VAR }","3"
    tracing::trace!(foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:trace,-,-,pf,-,"{ CONST_VAR }","3"
    tracing::trace!({ CONST_VAR } = 3, "msg without args"); // DEBUG:trace,-,-,-,m,"{ CONST_VAR }","3"
    tracing::trace!(foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:trace,-,-,p,m,"{ CONST_VAR }","3"
    tracing::trace!({ CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"{ CONST_VAR }","3"
    tracing::trace!(foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"{ CONST_VAR }","3"
    tracing::trace!({ { CONST_VAR } = 3 }, "msg without args"); // DEBUG:trace,-,{},-,m,"{ CONST_VAR }","3"
    tracing::trace!({ foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:trace,-,{},p,m,"{ CONST_VAR }","3"
    tracing::trace!({ { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"{ CONST_VAR }","3"
    tracing::trace!({ foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"{ CONST_VAR }","3"
    tracing::trace!({ CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"{ CONST_VAR }","3"
    tracing::trace!(foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"{ CONST_VAR }","3"
    tracing::trace!({ CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"{ CONST_VAR }","3"
    tracing::trace!(foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"{ CONST_VAR }","3"
    tracing::trace!({ { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"{ CONST_VAR }","3"
    tracing::trace!({ foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"{ CONST_VAR }","3"
    tracing::trace!({ { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"{ CONST_VAR }","3"
    tracing::trace!({ foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"{ CONST_VAR }","3"
    tracing::trace!({ CONST_VAR } = false); // DEBUG:trace,-,-,-,-,"{ CONST_VAR }","false"
    tracing::trace!(foo = true, { CONST_VAR } = false); // DEBUG:trace,-,-,p,-,"{ CONST_VAR }","false"
    tracing::trace!({ CONST_VAR } = false, qux = 3); // DEBUG:trace,-,-,f,-,"{ CONST_VAR }","false"
    tracing::trace!(foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:trace,-,-,pf,-,"{ CONST_VAR }","false"
    tracing::trace!({ CONST_VAR } = false, "msg without args"); // DEBUG:trace,-,-,-,m,"{ CONST_VAR }","false"
    tracing::trace!(foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:trace,-,-,p,m,"{ CONST_VAR }","false"
    tracing::trace!({ CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"{ CONST_VAR }","false"
    tracing::trace!(foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"{ CONST_VAR }","false"
    tracing::trace!({ { CONST_VAR } = false }, "msg without args"); // DEBUG:trace,-,{},-,m,"{ CONST_VAR }","false"
    tracing::trace!({ foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:trace,-,{},p,m,"{ CONST_VAR }","false"
    tracing::trace!({ { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"{ CONST_VAR }","false"
    tracing::trace!({ foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"{ CONST_VAR }","false"
    tracing::trace!({ CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"{ CONST_VAR }","false"
    tracing::trace!(foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"{ CONST_VAR }","false"
    tracing::trace!({ CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"{ CONST_VAR }","false"
    tracing::trace!(foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"{ CONST_VAR }","false"
    tracing::trace!({ { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"{ CONST_VAR }","false"
    tracing::trace!({ foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"{ CONST_VAR }","false"
    tracing::trace!({ { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"{ CONST_VAR }","false"
    tracing::trace!({ foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"{ CONST_VAR }","false"
    tracing::trace!({ CONST_VAR } = ?3); // DEBUG:trace,-,-,-,-,"{ CONST_VAR }","?3"
    tracing::trace!(foo = true, { CONST_VAR } = ?3); // DEBUG:trace,-,-,p,-,"{ CONST_VAR }","?3"
    tracing::trace!({ CONST_VAR } = ?3, qux = 3); // DEBUG:trace,-,-,f,-,"{ CONST_VAR }","?3"
    tracing::trace!(foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:trace,-,-,pf,-,"{ CONST_VAR }","?3"
    tracing::trace!({ CONST_VAR } = ?3, "msg without args"); // DEBUG:trace,-,-,-,m,"{ CONST_VAR }","?3"
    tracing::trace!(foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:trace,-,-,p,m,"{ CONST_VAR }","?3"
    tracing::trace!({ CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"{ CONST_VAR }","?3"
    tracing::trace!(foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"{ CONST_VAR }","?3"
    tracing::trace!({ { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:trace,-,{},-,m,"{ CONST_VAR }","?3"
    tracing::trace!({ foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:trace,-,{},p,m,"{ CONST_VAR }","?3"
    tracing::trace!({ { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"{ CONST_VAR }","?3"
    tracing::trace!({ foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"{ CONST_VAR }","?3"
    tracing::trace!({ CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"{ CONST_VAR }","?3"
    tracing::trace!(foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"{ CONST_VAR }","?3"
    tracing::trace!({ CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"{ CONST_VAR }","?3"
    tracing::trace!(foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::trace!({ { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"{ CONST_VAR }","?3"
    tracing::trace!({ foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"{ CONST_VAR }","?3"
    tracing::trace!({ { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"{ CONST_VAR }","?3"
    tracing::trace!({ foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::trace!({ CONST_VAR } = %3); // DEBUG:trace,-,-,-,-,"{ CONST_VAR }","%3"
    tracing::trace!(foo = true, { CONST_VAR } = %3); // DEBUG:trace,-,-,p,-,"{ CONST_VAR }","%3"
    tracing::trace!({ CONST_VAR } = %3, qux = 3); // DEBUG:trace,-,-,f,-,"{ CONST_VAR }","%3"
    tracing::trace!(foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:trace,-,-,pf,-,"{ CONST_VAR }","%3"
    tracing::trace!({ CONST_VAR } = %3, "msg without args"); // DEBUG:trace,-,-,-,m,"{ CONST_VAR }","%3"
    tracing::trace!(foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:trace,-,-,p,m,"{ CONST_VAR }","%3"
    tracing::trace!({ CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"{ CONST_VAR }","%3"
    tracing::trace!(foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"{ CONST_VAR }","%3"
    tracing::trace!({ { CONST_VAR } = %3 }, "msg without args"); // DEBUG:trace,-,{},-,m,"{ CONST_VAR }","%3"
    tracing::trace!({ foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:trace,-,{},p,m,"{ CONST_VAR }","%3"
    tracing::trace!({ { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"{ CONST_VAR }","%3"
    tracing::trace!({ foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"{ CONST_VAR }","%3"
    tracing::trace!({ CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"{ CONST_VAR }","%3"
    tracing::trace!(foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"{ CONST_VAR }","%3"
    tracing::trace!({ CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"{ CONST_VAR }","%3"
    tracing::trace!(foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::trace!({ { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"{ CONST_VAR }","%3"
    tracing::trace!({ foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"{ CONST_VAR }","%3"
    tracing::trace!({ { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"{ CONST_VAR }","%3"
    tracing::trace!({ foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::trace!({ CONST_VAR } = ?deb); // DEBUG:trace,-,-,-,-,"{ CONST_VAR }","?deb"
    tracing::trace!(foo = true, { CONST_VAR } = ?deb); // DEBUG:trace,-,-,p,-,"{ CONST_VAR }","?deb"
    tracing::trace!({ CONST_VAR } = ?deb, qux = 3); // DEBUG:trace,-,-,f,-,"{ CONST_VAR }","?deb"
    tracing::trace!(foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:trace,-,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::trace!({ CONST_VAR } = ?deb, "msg without args"); // DEBUG:trace,-,-,-,m,"{ CONST_VAR }","?deb"
    tracing::trace!(foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:trace,-,-,p,m,"{ CONST_VAR }","?deb"
    tracing::trace!({ CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"{ CONST_VAR }","?deb"
    tracing::trace!(foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::trace!({ { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:trace,-,{},-,m,"{ CONST_VAR }","?deb"
    tracing::trace!({ foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:trace,-,{},p,m,"{ CONST_VAR }","?deb"
    tracing::trace!({ { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"{ CONST_VAR }","?deb"
    tracing::trace!({ foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::trace!({ CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::trace!(foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::trace!({ CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::trace!(foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::trace!({ { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::trace!({ foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::trace!({ { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::trace!({ foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::trace!({ CONST_VAR } = %disp); // DEBUG:trace,-,-,-,-,"{ CONST_VAR }","%disp"
    tracing::trace!(foo = true, { CONST_VAR } = %disp); // DEBUG:trace,-,-,p,-,"{ CONST_VAR }","%disp"
    tracing::trace!({ CONST_VAR } = %disp, qux = 3); // DEBUG:trace,-,-,f,-,"{ CONST_VAR }","%disp"
    tracing::trace!(foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:trace,-,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::trace!({ CONST_VAR } = %disp, "msg without args"); // DEBUG:trace,-,-,-,m,"{ CONST_VAR }","%disp"
    tracing::trace!(foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:trace,-,-,p,m,"{ CONST_VAR }","%disp"
    tracing::trace!({ CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"{ CONST_VAR }","%disp"
    tracing::trace!(foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::trace!({ { CONST_VAR } = %disp }, "msg without args"); // DEBUG:trace,-,{},-,m,"{ CONST_VAR }","%disp"
    tracing::trace!({ foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:trace,-,{},p,m,"{ CONST_VAR }","%disp"
    tracing::trace!({ { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"{ CONST_VAR }","%disp"
    tracing::trace!({ foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::trace!({ CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::trace!(foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::trace!({ CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::trace!(foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::trace!({ { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::trace!({ foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::trace!({ { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::trace!({ foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::trace!({ CONST_VAR } = ?sub.field); // DEBUG:trace,-,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::trace!(foo = true, { CONST_VAR } = ?sub.field); // DEBUG:trace,-,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::trace!({ CONST_VAR } = ?sub.field, qux = 3); // DEBUG:trace,-,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::trace!(foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:trace,-,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::trace!({ CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:trace,-,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::trace!(foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:trace,-,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::trace!({ CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::trace!(foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::trace!({ { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:trace,-,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::trace!({ foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:trace,-,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::trace!({ { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::trace!({ foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::trace!({ CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::trace!(foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::trace!({ CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::trace!(foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::trace!({ { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::trace!({ foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::trace!({ { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::trace!({ foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::trace!({ CONST_VAR } = %sub.field); // DEBUG:trace,-,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::trace!(foo = true, { CONST_VAR } = %sub.field); // DEBUG:trace,-,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::trace!({ CONST_VAR } = %sub.field, qux = 3); // DEBUG:trace,-,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::trace!(foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:trace,-,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::trace!({ CONST_VAR } = %sub.field, "msg without args"); // DEBUG:trace,-,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::trace!(foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:trace,-,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::trace!({ CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::trace!(foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::trace!({ { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:trace,-,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::trace!({ foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:trace,-,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::trace!({ { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::trace!({ foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::trace!({ CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::trace!(foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::trace!({ CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::trace!(foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::trace!({ { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::trace!({ foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::trace!({ { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::trace!({ foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::trace!({ CONST_VAR } = debug(&deb)); // DEBUG:trace,-,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:trace,-,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!({ CONST_VAR } = debug(&deb), qux = 3); // DEBUG:trace,-,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:trace,-,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!({ CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:trace,-,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:trace,-,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!({ CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!({ { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:trace,-,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!({ foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:trace,-,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!({ { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!({ foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!({ CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!({ CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!({ { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!({ foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!({ { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!({ foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!({ CONST_VAR } = display(&disp)); // DEBUG:trace,-,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(foo = true, { CONST_VAR } = display(&disp)); // DEBUG:trace,-,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::trace!({ CONST_VAR } = display(&disp), qux = 3); // DEBUG:trace,-,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:trace,-,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::trace!({ CONST_VAR } = display(&disp), "msg without args"); // DEBUG:trace,-,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:trace,-,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::trace!({ CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::trace!({ { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:trace,-,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::trace!({ foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:trace,-,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::trace!({ { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::trace!({ foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::trace!({ CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::trace!({ CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::trace!({ { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::trace!({ foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::trace!({ { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::trace!({ foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::trace!({ CONST_VAR } = tracing::field::Empty); // DEBUG:trace,-,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:trace,-,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!({ CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:trace,-,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:trace,-,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!({ CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:trace,-,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:trace,-,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!({ CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!({ { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:trace,-,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!({ foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:trace,-,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!({ { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!({ foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!({ CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!({ CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!({ { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!({ foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!({ { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!({ foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(r#type = 3); // DEBUG:trace,-,-,-,-,"r#type","3"
    tracing::trace!(foo = true, r#type = 3); // DEBUG:trace,-,-,p,-,"r#type","3"
    tracing::trace!(r#type = 3, qux = 3); // DEBUG:trace,-,-,f,-,"r#type","3"
    tracing::trace!(foo = true, r#type = 3, qux = 3); // DEBUG:trace,-,-,pf,-,"r#type","3"
    tracing::trace!(r#type = 3, "msg without args"); // DEBUG:trace,-,-,-,m,"r#type","3"
    tracing::trace!(foo = true, r#type = 3, "msg without args"); // DEBUG:trace,-,-,p,m,"r#type","3"
    tracing::trace!(r#type = 3, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"r#type","3"
    tracing::trace!(foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"r#type","3"
    tracing::trace!({ r#type = 3 }, "msg without args"); // DEBUG:trace,-,{},-,m,"r#type","3"
    tracing::trace!({ foo = true, r#type = 3 }, "msg without args"); // DEBUG:trace,-,{},p,m,"r#type","3"
    tracing::trace!({ r#type = 3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"r#type","3"
    tracing::trace!({ foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"r#type","3"
    tracing::trace!(r#type = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"r#type","3"
    tracing::trace!(foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"r#type","3"
    tracing::trace!(r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"r#type","3"
    tracing::trace!(foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"r#type","3"
    tracing::trace!({ r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"r#type","3"
    tracing::trace!({ foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"r#type","3"
    tracing::trace!({ r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"r#type","3"
    tracing::trace!({ foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"r#type","3"
    tracing::trace!(r#type = false); // DEBUG:trace,-,-,-,-,"r#type","false"
    tracing::trace!(foo = true, r#type = false); // DEBUG:trace,-,-,p,-,"r#type","false"
    tracing::trace!(r#type = false, qux = 3); // DEBUG:trace,-,-,f,-,"r#type","false"
    tracing::trace!(foo = true, r#type = false, qux = 3); // DEBUG:trace,-,-,pf,-,"r#type","false"
    tracing::trace!(r#type = false, "msg without args"); // DEBUG:trace,-,-,-,m,"r#type","false"
    tracing::trace!(foo = true, r#type = false, "msg without args"); // DEBUG:trace,-,-,p,m,"r#type","false"
    tracing::trace!(r#type = false, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"r#type","false"
    tracing::trace!(foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"r#type","false"
    tracing::trace!({ r#type = false }, "msg without args"); // DEBUG:trace,-,{},-,m,"r#type","false"
    tracing::trace!({ foo = true, r#type = false }, "msg without args"); // DEBUG:trace,-,{},p,m,"r#type","false"
    tracing::trace!({ r#type = false, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"r#type","false"
    tracing::trace!({ foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"r#type","false"
    tracing::trace!(r#type = false, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"r#type","false"
    tracing::trace!(foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"r#type","false"
    tracing::trace!(r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"r#type","false"
    tracing::trace!(foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"r#type","false"
    tracing::trace!({ r#type = false }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"r#type","false"
    tracing::trace!({ foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"r#type","false"
    tracing::trace!({ r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"r#type","false"
    tracing::trace!({ foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"r#type","false"
    tracing::trace!(r#type = ?3); // DEBUG:trace,-,-,-,-,"r#type","?3"
    tracing::trace!(foo = true, r#type = ?3); // DEBUG:trace,-,-,p,-,"r#type","?3"
    tracing::trace!(r#type = ?3, qux = 3); // DEBUG:trace,-,-,f,-,"r#type","?3"
    tracing::trace!(foo = true, r#type = ?3, qux = 3); // DEBUG:trace,-,-,pf,-,"r#type","?3"
    tracing::trace!(r#type = ?3, "msg without args"); // DEBUG:trace,-,-,-,m,"r#type","?3"
    tracing::trace!(foo = true, r#type = ?3, "msg without args"); // DEBUG:trace,-,-,p,m,"r#type","?3"
    tracing::trace!(r#type = ?3, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"r#type","?3"
    tracing::trace!(foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"r#type","?3"
    tracing::trace!({ r#type = ?3 }, "msg without args"); // DEBUG:trace,-,{},-,m,"r#type","?3"
    tracing::trace!({ foo = true, r#type = ?3 }, "msg without args"); // DEBUG:trace,-,{},p,m,"r#type","?3"
    tracing::trace!({ r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"r#type","?3"
    tracing::trace!({ foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"r#type","?3"
    tracing::trace!(r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"r#type","?3"
    tracing::trace!(foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"r#type","?3"
    tracing::trace!(r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"r#type","?3"
    tracing::trace!(foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"r#type","?3"
    tracing::trace!({ r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"r#type","?3"
    tracing::trace!({ foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"r#type","?3"
    tracing::trace!({ r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"r#type","?3"
    tracing::trace!({ foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"r#type","?3"
    tracing::trace!(r#type = %3); // DEBUG:trace,-,-,-,-,"r#type","%3"
    tracing::trace!(foo = true, r#type = %3); // DEBUG:trace,-,-,p,-,"r#type","%3"
    tracing::trace!(r#type = %3, qux = 3); // DEBUG:trace,-,-,f,-,"r#type","%3"
    tracing::trace!(foo = true, r#type = %3, qux = 3); // DEBUG:trace,-,-,pf,-,"r#type","%3"
    tracing::trace!(r#type = %3, "msg without args"); // DEBUG:trace,-,-,-,m,"r#type","%3"
    tracing::trace!(foo = true, r#type = %3, "msg without args"); // DEBUG:trace,-,-,p,m,"r#type","%3"
    tracing::trace!(r#type = %3, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"r#type","%3"
    tracing::trace!(foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"r#type","%3"
    tracing::trace!({ r#type = %3 }, "msg without args"); // DEBUG:trace,-,{},-,m,"r#type","%3"
    tracing::trace!({ foo = true, r#type = %3 }, "msg without args"); // DEBUG:trace,-,{},p,m,"r#type","%3"
    tracing::trace!({ r#type = %3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"r#type","%3"
    tracing::trace!({ foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"r#type","%3"
    tracing::trace!(r#type = %3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"r#type","%3"
    tracing::trace!(foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"r#type","%3"
    tracing::trace!(r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"r#type","%3"
    tracing::trace!(foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"r#type","%3"
    tracing::trace!({ r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"r#type","%3"
    tracing::trace!({ foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"r#type","%3"
    tracing::trace!({ r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"r#type","%3"
    tracing::trace!({ foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"r#type","%3"
    tracing::trace!(r#type = ?deb); // DEBUG:trace,-,-,-,-,"r#type","?deb"
    tracing::trace!(foo = true, r#type = ?deb); // DEBUG:trace,-,-,p,-,"r#type","?deb"
    tracing::trace!(r#type = ?deb, qux = 3); // DEBUG:trace,-,-,f,-,"r#type","?deb"
    tracing::trace!(foo = true, r#type = ?deb, qux = 3); // DEBUG:trace,-,-,pf,-,"r#type","?deb"
    tracing::trace!(r#type = ?deb, "msg without args"); // DEBUG:trace,-,-,-,m,"r#type","?deb"
    tracing::trace!(foo = true, r#type = ?deb, "msg without args"); // DEBUG:trace,-,-,p,m,"r#type","?deb"
    tracing::trace!(r#type = ?deb, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"r#type","?deb"
    tracing::trace!(foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"r#type","?deb"
    tracing::trace!({ r#type = ?deb }, "msg without args"); // DEBUG:trace,-,{},-,m,"r#type","?deb"
    tracing::trace!({ foo = true, r#type = ?deb }, "msg without args"); // DEBUG:trace,-,{},p,m,"r#type","?deb"
    tracing::trace!({ r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"r#type","?deb"
    tracing::trace!({ foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"r#type","?deb"
    tracing::trace!(r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"r#type","?deb"
    tracing::trace!(foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"r#type","?deb"
    tracing::trace!(r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"r#type","?deb"
    tracing::trace!(foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"r#type","?deb"
    tracing::trace!({ r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"r#type","?deb"
    tracing::trace!({ foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"r#type","?deb"
    tracing::trace!({ r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"r#type","?deb"
    tracing::trace!({ foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"r#type","?deb"
    tracing::trace!(r#type = %disp); // DEBUG:trace,-,-,-,-,"r#type","%disp"
    tracing::trace!(foo = true, r#type = %disp); // DEBUG:trace,-,-,p,-,"r#type","%disp"
    tracing::trace!(r#type = %disp, qux = 3); // DEBUG:trace,-,-,f,-,"r#type","%disp"
    tracing::trace!(foo = true, r#type = %disp, qux = 3); // DEBUG:trace,-,-,pf,-,"r#type","%disp"
    tracing::trace!(r#type = %disp, "msg without args"); // DEBUG:trace,-,-,-,m,"r#type","%disp"
    tracing::trace!(foo = true, r#type = %disp, "msg without args"); // DEBUG:trace,-,-,p,m,"r#type","%disp"
    tracing::trace!(r#type = %disp, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"r#type","%disp"
    tracing::trace!(foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"r#type","%disp"
    tracing::trace!({ r#type = %disp }, "msg without args"); // DEBUG:trace,-,{},-,m,"r#type","%disp"
    tracing::trace!({ foo = true, r#type = %disp }, "msg without args"); // DEBUG:trace,-,{},p,m,"r#type","%disp"
    tracing::trace!({ r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"r#type","%disp"
    tracing::trace!({ foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"r#type","%disp"
    tracing::trace!(r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"r#type","%disp"
    tracing::trace!(foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"r#type","%disp"
    tracing::trace!(r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"r#type","%disp"
    tracing::trace!(foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"r#type","%disp"
    tracing::trace!({ r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"r#type","%disp"
    tracing::trace!({ foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"r#type","%disp"
    tracing::trace!({ r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"r#type","%disp"
    tracing::trace!({ foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"r#type","%disp"
    tracing::trace!(r#type = ?sub.field); // DEBUG:trace,-,-,-,-,"r#type","?sub.field"
    tracing::trace!(foo = true, r#type = ?sub.field); // DEBUG:trace,-,-,p,-,"r#type","?sub.field"
    tracing::trace!(r#type = ?sub.field, qux = 3); // DEBUG:trace,-,-,f,-,"r#type","?sub.field"
    tracing::trace!(foo = true, r#type = ?sub.field, qux = 3); // DEBUG:trace,-,-,pf,-,"r#type","?sub.field"
    tracing::trace!(r#type = ?sub.field, "msg without args"); // DEBUG:trace,-,-,-,m,"r#type","?sub.field"
    tracing::trace!(foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:trace,-,-,p,m,"r#type","?sub.field"
    tracing::trace!(r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"r#type","?sub.field"
    tracing::trace!(foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"r#type","?sub.field"
    tracing::trace!({ r#type = ?sub.field }, "msg without args"); // DEBUG:trace,-,{},-,m,"r#type","?sub.field"
    tracing::trace!({ foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:trace,-,{},p,m,"r#type","?sub.field"
    tracing::trace!({ r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"r#type","?sub.field"
    tracing::trace!({ foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"r#type","?sub.field"
    tracing::trace!(r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"r#type","?sub.field"
    tracing::trace!(foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"r#type","?sub.field"
    tracing::trace!(r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"r#type","?sub.field"
    tracing::trace!(foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"r#type","?sub.field"
    tracing::trace!({ r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"r#type","?sub.field"
    tracing::trace!({ foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"r#type","?sub.field"
    tracing::trace!({ r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"r#type","?sub.field"
    tracing::trace!({ foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"r#type","?sub.field"
    tracing::trace!(r#type = %sub.field); // DEBUG:trace,-,-,-,-,"r#type","%sub.field"
    tracing::trace!(foo = true, r#type = %sub.field); // DEBUG:trace,-,-,p,-,"r#type","%sub.field"
    tracing::trace!(r#type = %sub.field, qux = 3); // DEBUG:trace,-,-,f,-,"r#type","%sub.field"
    tracing::trace!(foo = true, r#type = %sub.field, qux = 3); // DEBUG:trace,-,-,pf,-,"r#type","%sub.field"
    tracing::trace!(r#type = %sub.field, "msg without args"); // DEBUG:trace,-,-,-,m,"r#type","%sub.field"
    tracing::trace!(foo = true, r#type = %sub.field, "msg without args"); // DEBUG:trace,-,-,p,m,"r#type","%sub.field"
    tracing::trace!(r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"r#type","%sub.field"
    tracing::trace!(foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"r#type","%sub.field"
    tracing::trace!({ r#type = %sub.field }, "msg without args"); // DEBUG:trace,-,{},-,m,"r#type","%sub.field"
    tracing::trace!({ foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:trace,-,{},p,m,"r#type","%sub.field"
    tracing::trace!({ r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"r#type","%sub.field"
    tracing::trace!({ foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"r#type","%sub.field"
    tracing::trace!(r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"r#type","%sub.field"
    tracing::trace!(foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"r#type","%sub.field"
    tracing::trace!(r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"r#type","%sub.field"
    tracing::trace!(foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"r#type","%sub.field"
    tracing::trace!({ r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"r#type","%sub.field"
    tracing::trace!({ foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"r#type","%sub.field"
    tracing::trace!({ r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"r#type","%sub.field"
    tracing::trace!({ foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"r#type","%sub.field"
    tracing::trace!(r#type = debug(&deb)); // DEBUG:trace,-,-,-,-,"r#type","debug(&deb)"
    tracing::trace!(foo = true, r#type = debug(&deb)); // DEBUG:trace,-,-,p,-,"r#type","debug(&deb)"
    tracing::trace!(r#type = debug(&deb), qux = 3); // DEBUG:trace,-,-,f,-,"r#type","debug(&deb)"
    tracing::trace!(foo = true, r#type = debug(&deb), qux = 3); // DEBUG:trace,-,-,pf,-,"r#type","debug(&deb)"
    tracing::trace!(r#type = debug(&deb), "msg without args"); // DEBUG:trace,-,-,-,m,"r#type","debug(&deb)"
    tracing::trace!(foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:trace,-,-,p,m,"r#type","debug(&deb)"
    tracing::trace!(r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"r#type","debug(&deb)"
    tracing::trace!(foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"r#type","debug(&deb)"
    tracing::trace!({ r#type = debug(&deb) }, "msg without args"); // DEBUG:trace,-,{},-,m,"r#type","debug(&deb)"
    tracing::trace!({ foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:trace,-,{},p,m,"r#type","debug(&deb)"
    tracing::trace!({ r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"r#type","debug(&deb)"
    tracing::trace!({ foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"r#type","debug(&deb)"
    tracing::trace!(r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"r#type","debug(&deb)"
    tracing::trace!(foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"r#type","debug(&deb)"
    tracing::trace!(r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"r#type","debug(&deb)"
    tracing::trace!(foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"r#type","debug(&deb)"
    tracing::trace!({ r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"r#type","debug(&deb)"
    tracing::trace!({ foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"r#type","debug(&deb)"
    tracing::trace!({ r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"r#type","debug(&deb)"
    tracing::trace!({ foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"r#type","debug(&deb)"
    tracing::trace!(r#type = display(&disp)); // DEBUG:trace,-,-,-,-,"r#type","display(&disp)"
    tracing::trace!(foo = true, r#type = display(&disp)); // DEBUG:trace,-,-,p,-,"r#type","display(&disp)"
    tracing::trace!(r#type = display(&disp), qux = 3); // DEBUG:trace,-,-,f,-,"r#type","display(&disp)"
    tracing::trace!(foo = true, r#type = display(&disp), qux = 3); // DEBUG:trace,-,-,pf,-,"r#type","display(&disp)"
    tracing::trace!(r#type = display(&disp), "msg without args"); // DEBUG:trace,-,-,-,m,"r#type","display(&disp)"
    tracing::trace!(foo = true, r#type = display(&disp), "msg without args"); // DEBUG:trace,-,-,p,m,"r#type","display(&disp)"
    tracing::trace!(r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"r#type","display(&disp)"
    tracing::trace!(foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"r#type","display(&disp)"
    tracing::trace!({ r#type = display(&disp) }, "msg without args"); // DEBUG:trace,-,{},-,m,"r#type","display(&disp)"
    tracing::trace!({ foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:trace,-,{},p,m,"r#type","display(&disp)"
    tracing::trace!({ r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"r#type","display(&disp)"
    tracing::trace!({ foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"r#type","display(&disp)"
    tracing::trace!(r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"r#type","display(&disp)"
    tracing::trace!(foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"r#type","display(&disp)"
    tracing::trace!(r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"r#type","display(&disp)"
    tracing::trace!(foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"r#type","display(&disp)"
    tracing::trace!({ r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"r#type","display(&disp)"
    tracing::trace!({ foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"r#type","display(&disp)"
    tracing::trace!({ r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"r#type","display(&disp)"
    tracing::trace!({ foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"r#type","display(&disp)"
    tracing::trace!(r#type = tracing::field::Empty); // DEBUG:trace,-,-,-,-,"r#type","tracing::field::Empty"
    tracing::trace!(foo = true, r#type = tracing::field::Empty); // DEBUG:trace,-,-,p,-,"r#type","tracing::field::Empty"
    tracing::trace!(r#type = tracing::field::Empty, qux = 3); // DEBUG:trace,-,-,f,-,"r#type","tracing::field::Empty"
    tracing::trace!(foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:trace,-,-,pf,-,"r#type","tracing::field::Empty"
    tracing::trace!(r#type = tracing::field::Empty, "msg without args"); // DEBUG:trace,-,-,-,m,"r#type","tracing::field::Empty"
    tracing::trace!(foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:trace,-,-,p,m,"r#type","tracing::field::Empty"
    tracing::trace!(r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,"r#type","tracing::field::Empty"
    tracing::trace!(foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,"r#type","tracing::field::Empty"
    tracing::trace!({ r#type = tracing::field::Empty }, "msg without args"); // DEBUG:trace,-,{},-,m,"r#type","tracing::field::Empty"
    tracing::trace!({ foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:trace,-,{},p,m,"r#type","tracing::field::Empty"
    tracing::trace!({ r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,"r#type","tracing::field::Empty"
    tracing::trace!({ foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,"r#type","tracing::field::Empty"
    tracing::trace!(r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,"r#type","tracing::field::Empty"
    tracing::trace!(foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,"r#type","tracing::field::Empty"
    tracing::trace!(r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,"r#type","tracing::field::Empty"
    tracing::trace!(foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::trace!({ r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,"r#type","tracing::field::Empty"
    tracing::trace!({ foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,"r#type","tracing::field::Empty"
    tracing::trace!({ r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,"r#type","tracing::field::Empty"
    tracing::trace!({ foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::trace!(var); // DEBUG:trace,-,-,-,-,-,"var"
    tracing::trace!(foo = true, var); // DEBUG:trace,-,-,p,-,-,"var"
    tracing::trace!(var, qux = 3); // DEBUG:trace,-,-,f,-,-,"var"
    tracing::trace!(foo = true, var, qux = 3); // DEBUG:trace,-,-,pf,-,-,"var"
    tracing::trace!(var, "msg without args"); // DEBUG:trace,-,-,-,m,-,"var"
    tracing::trace!(foo = true, var, "msg without args"); // DEBUG:trace,-,-,p,m,-,"var"
    tracing::trace!(var, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,-,"var"
    tracing::trace!(foo = true, var, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,-,"var"
    tracing::trace!({ var }, "msg without args"); // DEBUG:trace,-,{},-,m,-,"var"
    tracing::trace!({ foo = true, var }, "msg without args"); // DEBUG:trace,-,{},p,m,-,"var"
    tracing::trace!({ var, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,-,"var"
    tracing::trace!({ foo = true, var, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,-,"var"
    tracing::trace!(var, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,-,"var"
    tracing::trace!(foo = true, var, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,-,"var"
    tracing::trace!(var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,-,"var"
    tracing::trace!(foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,-,"var"
    tracing::trace!({ var }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,-,"var"
    tracing::trace!({ foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,-,"var"
    tracing::trace!({ var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,-,"var"
    tracing::trace!({ foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,-,"var"
    tracing::trace!(sub.field); // DEBUG:trace,-,-,-,-,-,"sub.field"
    tracing::trace!(foo = true, sub.field); // DEBUG:trace,-,-,p,-,-,"sub.field"
    tracing::trace!(sub.field, qux = 3); // DEBUG:trace,-,-,f,-,-,"sub.field"
    tracing::trace!(foo = true, sub.field, qux = 3); // DEBUG:trace,-,-,pf,-,-,"sub.field"
    tracing::trace!(sub.field, "msg without args"); // DEBUG:trace,-,-,-,m,-,"sub.field"
    tracing::trace!(foo = true, sub.field, "msg without args"); // DEBUG:trace,-,-,p,m,-,"sub.field"
    tracing::trace!(sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,-,"sub.field"
    tracing::trace!(foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,-,"sub.field"
    tracing::trace!({ sub.field }, "msg without args"); // DEBUG:trace,-,{},-,m,-,"sub.field"
    tracing::trace!({ foo = true, sub.field }, "msg without args"); // DEBUG:trace,-,{},p,m,-,"sub.field"
    tracing::trace!({ sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,-,"sub.field"
    tracing::trace!({ foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,-,"sub.field"
    tracing::trace!(sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,-,"sub.field"
    tracing::trace!(foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,-,"sub.field"
    tracing::trace!(sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,-,"sub.field"
    tracing::trace!(foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,-,"sub.field"
    tracing::trace!({ sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,-,"sub.field"
    tracing::trace!({ foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,-,"sub.field"
    tracing::trace!({ sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,-,"sub.field"
    tracing::trace!({ foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,-,"sub.field"
    tracing::trace!(%disp); // DEBUG:trace,-,-,-,-,-,"%disp"
    tracing::trace!(foo = true, %disp); // DEBUG:trace,-,-,p,-,-,"%disp"
    tracing::trace!(%disp, qux = 3); // DEBUG:trace,-,-,f,-,-,"%disp"
    tracing::trace!(foo = true, %disp, qux = 3); // DEBUG:trace,-,-,pf,-,-,"%disp"
    tracing::trace!(%disp, "msg without args"); // DEBUG:trace,-,-,-,m,-,"%disp"
    tracing::trace!(foo = true, %disp, "msg without args"); // DEBUG:trace,-,-,p,m,-,"%disp"
    tracing::trace!(%disp, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,-,"%disp"
    tracing::trace!(foo = true, %disp, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,-,"%disp"
    tracing::trace!({ %disp }, "msg without args"); // DEBUG:trace,-,{},-,m,-,"%disp"
    tracing::trace!({ foo = true, %disp }, "msg without args"); // DEBUG:trace,-,{},p,m,-,"%disp"
    tracing::trace!({ %disp, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,-,"%disp"
    tracing::trace!({ foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,-,"%disp"
    tracing::trace!(%disp, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,-,"%disp"
    tracing::trace!(foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,-,"%disp"
    tracing::trace!(%disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,-,"%disp"
    tracing::trace!(foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,-,"%disp"
    tracing::trace!({ %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,-,"%disp"
    tracing::trace!({ foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,-,"%disp"
    tracing::trace!({ %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,-,"%disp"
    tracing::trace!({ foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,-,"%disp"
    tracing::trace!(?deb); // DEBUG:trace,-,-,-,-,-,"?deb"
    tracing::trace!(foo = true, ?deb); // DEBUG:trace,-,-,p,-,-,"?deb"
    tracing::trace!(?deb, qux = 3); // DEBUG:trace,-,-,f,-,-,"?deb"
    tracing::trace!(foo = true, ?deb, qux = 3); // DEBUG:trace,-,-,pf,-,-,"?deb"
    tracing::trace!(?deb, "msg without args"); // DEBUG:trace,-,-,-,m,-,"?deb"
    tracing::trace!(foo = true, ?deb, "msg without args"); // DEBUG:trace,-,-,p,m,-,"?deb"
    tracing::trace!(?deb, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,-,"?deb"
    tracing::trace!(foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,-,"?deb"
    tracing::trace!({ ?deb }, "msg without args"); // DEBUG:trace,-,{},-,m,-,"?deb"
    tracing::trace!({ foo = true, ?deb }, "msg without args"); // DEBUG:trace,-,{},p,m,-,"?deb"
    tracing::trace!({ ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,-,"?deb"
    tracing::trace!({ foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,-,"?deb"
    tracing::trace!(?deb, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,-,"?deb"
    tracing::trace!(foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,-,"?deb"
    tracing::trace!(?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,-,"?deb"
    tracing::trace!(foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,-,"?deb"
    tracing::trace!({ ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,-,"?deb"
    tracing::trace!({ foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,-,"?deb"
    tracing::trace!({ ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,-,"?deb"
    tracing::trace!({ foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,-,"?deb"
    tracing::trace!(%sub.field); // DEBUG:trace,-,-,-,-,-,"%sub.field"
    tracing::trace!(foo = true, %sub.field); // DEBUG:trace,-,-,p,-,-,"%sub.field"
    tracing::trace!(%sub.field, qux = 3); // DEBUG:trace,-,-,f,-,-,"%sub.field"
    tracing::trace!(foo = true, %sub.field, qux = 3); // DEBUG:trace,-,-,pf,-,-,"%sub.field"
    tracing::trace!(%sub.field, "msg without args"); // DEBUG:trace,-,-,-,m,-,"%sub.field"
    tracing::trace!(foo = true, %sub.field, "msg without args"); // DEBUG:trace,-,-,p,m,-,"%sub.field"
    tracing::trace!(%sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,-,"%sub.field"
    tracing::trace!(foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,-,"%sub.field"
    tracing::trace!({ %sub.field }, "msg without args"); // DEBUG:trace,-,{},-,m,-,"%sub.field"
    tracing::trace!({ foo = true, %sub.field }, "msg without args"); // DEBUG:trace,-,{},p,m,-,"%sub.field"
    tracing::trace!({ %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,-,"%sub.field"
    tracing::trace!({ foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,-,"%sub.field"
    tracing::trace!(%sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,-,"%sub.field"
    tracing::trace!(foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,-,"%sub.field"
    tracing::trace!(%sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,-,"%sub.field"
    tracing::trace!(foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,-,"%sub.field"
    tracing::trace!({ %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,-,"%sub.field"
    tracing::trace!({ foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,-,"%sub.field"
    tracing::trace!({ %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,-,"%sub.field"
    tracing::trace!({ foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,-,"%sub.field"
    tracing::trace!(?sub.field); // DEBUG:trace,-,-,-,-,-,"?sub.field"
    tracing::trace!(foo = true, ?sub.field); // DEBUG:trace,-,-,p,-,-,"?sub.field"
    tracing::trace!(?sub.field, qux = 3); // DEBUG:trace,-,-,f,-,-,"?sub.field"
    tracing::trace!(foo = true, ?sub.field, qux = 3); // DEBUG:trace,-,-,pf,-,-,"?sub.field"
    tracing::trace!(?sub.field, "msg without args"); // DEBUG:trace,-,-,-,m,-,"?sub.field"
    tracing::trace!(foo = true, ?sub.field, "msg without args"); // DEBUG:trace,-,-,p,m,-,"?sub.field"
    tracing::trace!(?sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,f,m,-,"?sub.field"
    tracing::trace!(foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,-,-,pf,m,-,"?sub.field"
    tracing::trace!({ ?sub.field }, "msg without args"); // DEBUG:trace,-,{},-,m,-,"?sub.field"
    tracing::trace!({ foo = true, ?sub.field }, "msg without args"); // DEBUG:trace,-,{},p,m,-,"?sub.field"
    tracing::trace!({ ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},f,m,-,"?sub.field"
    tracing::trace!({ foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,-,{},pf,m,-,"?sub.field"
    tracing::trace!(?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,-,ma,-,"?sub.field"
    tracing::trace!(foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,p,ma,-,"?sub.field"
    tracing::trace!(?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,f,ma,-,"?sub.field"
    tracing::trace!(foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,-,-,pf,ma,-,"?sub.field"
    tracing::trace!({ ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},-,ma,-,"?sub.field"
    tracing::trace!({ foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},p,ma,-,"?sub.field"
    tracing::trace!({ ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},f,ma,-,"?sub.field"
    tracing::trace!({ foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,-,{},pf,ma,-,"?sub.field"
}
