% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_names.R
\name{inspect.match_names}
\alias{inspect.match_names}
\alias{inspect}
\alias{update.match_names}
\title{Inspect and Update alternative matches for a name returned
    by tnrs_match_names}
\usage{
\method{inspect}{match_names}(response, row_number, taxon_name, ott_id, ...)

inspect(response, ...)

\method{update}{match_names}(object, row_number, taxon_name, ott_id,
  new_row_number, new_ott_id, ...)
}
\arguments{
\item{response}{an object generated by the
\code{\link{tnrs_match_names}} function}

\item{row_number}{the row number corresponding to the name to
inspect}

\item{taxon_name}{the taxon name corresponding to the name to
inspect}

\item{ott_id}{the ott id corresponding to the name to inspect}

\item{...}{currently ignored}

\item{object}{an object created by \code{\link{tnrs_match_names}}}

\item{new_row_number}{the row number in the output of
\code{\link{inspect}} to replace the taxa specified by
\code{row_number}, \code{taxon_name}, or \code{ott_id}.}

\item{new_ott_id}{the ott id of the taxon to replace the taxa
specified by \code{row_number}, \code{taxon_name}, or
\code{ott_id}.}
}
\value{
a data frame
}
\description{
Taxonomic names may have different meanings in different taxonomic
contexts, as the same genus name can be applied to animals and
plants for instance. Additionally, the meaning of a taxonomic name
may have change throughout its history, and may have referred to a
different taxon in the past. In such cases, a given names might
have multiple matches in the Open Tree Taxonomy. These functions
allow users to inspect (and update) alternative meaning of a given
name and its current taxonomic status according to the Open Tree
Taxonomy.
}
\details{
To inspect alternative taxonomic meanings of a given name, you
need to provide the object resulting from a call to the
tnrs_match_names function, as well as one of either the row number
corresponding to the name in this object, the name itself (as used
in the original query), or the ott_id listed for this name.

To update one of the name, you also need to provide the row number
in which the name to be replaced appear or its ott id.
}
\examples{
  \dontrun{
   matched_names <- tnrs_match_names(c("holothuria", "diadema", "boletus"))
   inspect(matched_names, taxon_name="diadema")
   new_matched_names <- update(matched_names, taxon_name="diadema",
                               new_ott_id = 631176)
   new_matched_names
   }
}
\seealso{
\code{\link{tnrs_match_names}}
}
