% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/denom_df.R
\name{dof_KR}
\alias{dof_KR}
\alias{dof_satt}
\title{compute denominator degrees-of-freedom approximations}
\usage{
dof_KR(model)

dof_satt(model, L = diag(length(fixef(model)$cond)))
}
\arguments{
\item{model}{a fitted \code{glmmTMB} object}

\item{L}{a  by default, equal to an identity matrix (i.e., ddfs are returned
for each fixed-effect parameter}
}
\value{
a named vector of ddf for each conditional fixed-effect parameter; \code{dof_KR} includes attributes 'vcov'
(Kenward-Roger adjusted covariance matrix) and 'se' (the corresponding standard errors)
}
\description{
\code{dof_KR} uses an adaptation of the machinery from the \code{pbkrtest} package
to compute the Kenward-Roger approximation of the 'denominator degrees of freedom' for
each fixed-effect coefficient in the conditional model; \code{dof_satt} does the same
for Satterthwaite approximations
}
\details{
Kenward-Roger adjustments \emph{should not be used} for models fitted with ML rather than REML;
the theory is only well understood, and the model is only tested, for LMMs (\code{family = "gaussian"}).
Use at your own risk for GLMMs!
}
