% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aw_verify.R
\name{aw_verify}
\alias{aw_verify}
\title{Verify Correct Extensive-Sum Interpolation}
\usage{
aw_verify(source, sourceValue, result, resultValue)
}
\arguments{
\item{source}{A \code{sf} object with data to be interpolated}

\item{sourceValue}{A column within \code{source} to be interpolated}

\item{result}{A \code{sf} object with interpolated data}

\item{resultValue}{A column within \code{result} with the interpolated values}
}
\value{
A logical scalar; if \code{TRUE}, these two values are equal.
}
\description{
Verify Correct Extensive-Sum Interpolation
}
\details{
\code{aw_verify} ensures that the sum of the resulting interpolated
    value is equal to the sum of the original source value. This functionality
    only works for interpolations that are extensive and use the \code{sum}
    approach to calculating areal weights.
}
\examples{
result <- aw_interpolate(ar_stl_wards, tid = WARD, source = ar_stl_race, sid = GEOID,
                         weight = "sum", output = "tibble", extensive = "TOTAL_E")

aw_verify(source = ar_stl_race, sourceValue = TOTAL_E, result = result, resultValue = TOTAL_E)

}
