# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.storageimportexport import StorageImportExport

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-storageimportexport
# USAGE
    python create_import_job.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = StorageImportExport(
        credential=DefaultAzureCredential(),
        subscription_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx",
    )

    response = client.jobs.create(
        job_name="myJob",
        resource_group_name="myResourceGroup",
        body={
            "location": "West US",
            "properties": {
                "backupDriveManifest": True,
                "diagnosticsPath": "waimportexport",
                "driveList": [
                    {
                        "bitLockerKey": "238810-662376-448998-450120-652806-203390-606320-483076",
                        "driveHeaderHash": "0:1048576:FB6B6ED500D49DA6E0D723C98D42C657F2881CC13357C28DCECA6A524F1292501571A321238540E621AB5BD9C9A32637615919A75593E6CB5C1515DAE341CABF;135266304:143360:C957A189AFC38C4E80731252301EB91427CE55E61448FA3C73C6FDDE70ABBC197947EC8D0249A2C639BB10B95957D5820A4BE8DFBBF76FFFA688AE5CE0D42EC3",
                        "driveId": "9CA995BB",
                        "manifestFile": "\\8a0c23f7-14b7-470a-9633-fcd46590a1bc.manifest",
                        "manifestHash": "4228EC5D8E048CB9B515338C789314BE8D0B2FDBC7C7A0308E1C826242CDE74E",
                    }
                ],
                "jobType": "Import",
                "logLevel": "Verbose",
                "returnAddress": {
                    "city": "Redmond",
                    "countryOrRegion": "USA",
                    "email": "Test@contoso.com",
                    "phone": "4250000000",
                    "postalCode": "98007",
                    "recipientName": "Test",
                    "stateOrProvince": "wa",
                    "streetAddress1": "Street1",
                    "streetAddress2": "street2",
                },
                "returnShipping": {"carrierAccountNumber": "989ffff", "carrierName": "FedEx"},
                "storageAccountId": "/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test",
            },
        },
    )
    print(response)


# x-ms-original-file: specification/storageimportexport/resource-manager/Microsoft.ImportExport/preview/2021-01-01/examples/CreateJob.json
if __name__ == "__main__":
    main()
