# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class DatasetConsumptionType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    RUN_INPUT = "RunInput"
    REFERENCE = "Reference"

class DatasetDeliveryMechanism(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    DIRECT = "Direct"
    MOUNT = "Mount"
    DOWNLOAD = "Download"
    HDFS = "Hdfs"

class DatasetOutputType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    RUN_OUTPUT = "RunOutput"
    REFERENCE = "Reference"

class ExperimentViewType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """ViewType filters experiments by their archived state. Default is ActiveOnly
    """

    DEFAULT = "Default"
    ALL = "All"
    ACTIVE_ONLY = "ActiveOnly"
    ARCHIVED_ONLY = "ArchivedOnly"

class MetricValueType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    INT = "Int"
    DOUBLE = "Double"
    STRING = "String"
    BOOL = "Bool"
    ARTIFACT = "Artifact"

class RunStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Gets span status.
    OpenTelemetry sets it to
    https://github.com/open-telemetry/opentelemetry-dotnet/blob/master/src/OpenTelemetry.Api/Trace/Status.cs
    That status enums are not very meaningful to us, so we customize this.
    """

    NOT_STARTED = "NotStarted"
    UNAPPROVED = "Unapproved"
    PAUSING = "Pausing"
    PAUSED = "Paused"
    STARTING = "Starting"
    PREPARING = "Preparing"
    QUEUED = "Queued"
    RUNNING = "Running"
    FINALIZING = "Finalizing"
    CANCEL_REQUESTED = "CancelRequested"
    COMPLETED = "Completed"
    FAILED = "Failed"
    CANCELED = "Canceled"

class SortOrderDirection(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    ASC = "Asc"
    DESC = "Desc"

class StoredProcedureParameterType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    STRING = "String"
    INT = "Int"
    DECIMAL = "Decimal"
    GUID = "Guid"
    BOOLEAN = "Boolean"
    DATE = "Date"
