"""
Convert the conda environment.yaml to a pip requirements.txt
"""
import yaml

exclude = {'python=3'}
rename = {'pytables': 'tables'}

with open("ci/environment-dev.yaml") as f:
    dev = yaml.load(f)

with open("ci/requirements-optional-conda.txt") as f:
    optional = [x.strip() for x in f.readlines()]

required = dev['dependencies']
required = [rename.get(dep, dep) for dep in required if dep not in exclude]
optional = [rename.get(dep, dep) for dep in optional if dep not in exclude]


with open("ci/requirements_dev.txt", 'wt') as f:
    f.write("# This file was autogenerated by scripts/convert_deps.py\n")
    f.write("# Do not modify directly\n")
    f.write('\n'.join(required))


with open("ci/requirements-optional-pip.txt", 'wt') as f:
    f.write("# This file was autogenerated by scripts/convert_deps.py\n")
    f.write("# Do not modify directly\n")
    f.write("\n".join(optional))
