/* SPDX-FileCopyrightText: 2020, 2024 - Sébastien Wilmet
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

/**
 * SECTION:buffer
 * @title: GtexBuffer
 * @short_description: Additional #TeplBuffer functions
 *
 * Additional #TeplBuffer functions.
 */

#include "gtex-buffer.h"
#include "gtex-settings.h"

/**
 * gtex_buffer_setup:
 * @buffer: a #TeplBuffer.
 *
 * Setups a #TeplBuffer for this application.
 */
void
gtex_buffer_setup (TeplBuffer *buffer)
{
	GtexSettings *settings;
	GSettings *editor_settings;

	g_return_if_fail (GTK_SOURCE_IS_BUFFER (buffer));

	settings = gtex_settings_get_singleton ();
	editor_settings = gtex_settings_peek_editor_settings (settings);

	g_settings_bind (editor_settings, "bracket-matching",
			 buffer, "highlight-matching-brackets",
			 G_SETTINGS_BIND_GET);

	tepl_buffer_connect_style_scheme_settings (buffer);
}
