use Test::More tests => 4;
use Test::Refcount;

use CipUX::Storage;

# 1
diag('new CipUX::Storage _build/cache');
my $object1 = CipUX::Storage->new( { cache_dir => '_build/cache' } );
is_oneref( $object1, '$object has a refcount of 1' );

# 2
diag('refcount CipUX::Storage');
my $otherref1 = $object1;
is_refcount( $object1, 2, '$object now has 2 references' );

use CipUX::Storage::Client;

# 3
diag('new CipUX::Storage::Client');
my $object2 = CipUX::Storage::Client->new(
    { name => 'cipux_storage_client', cache_dir => '_build/cache' } );
is_oneref( $object2, '$object has a refcount of 1' );

# 4
diag('refcount CipUX::Storage::Client');
my $otherref2 = $object2;
is_refcount( $object2, 2, '$object now has 2 references' );

