/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by Yoan Adida
    email                : yoan.adida@lip6.fr
 ***************************************************************************/
#include "ktoplevel.h"

QList<TopLevel> TopLevel::windowList;

KApplication *mykapp;

TopLevel::TopLevel(QWidget * , const char *name) : KTMainWindow(name)
  {
	windowList.setAutoDelete( FALSE );

	//Toolbar	
	ToolbarInit();
	//MainWidget	
	ShowInit();	
	//Menu
	MenuInit();
	setMenu(MainMenu);
	pref = new Preferences (mykapp,this,"Preferences");
	pref->hide();
	resize( 500,370 );
	//signals from file menu
	connect(this,SIGNAL(signal_ktoplevel_opencard()),	Showvcard,SLOT(slot_kshowvcard_openfile()));
	connect(this,SIGNAL(signal_ktoplevel_importcards()),	Showvcard,SLOT(slot_kshowvcard_importfiles()));	
	connect(this,SIGNAL(signal_ktoplevel_exportcards()),	Showvcard,SLOT(slot_kshowvcard_exportfiles()));
	connect(this, SIGNAL(signal_ktoplevel_printcards()),	Showvcard,SLOT(slot_kshowvcard_printcards()));
	connect(this,SIGNAL(signal_ktoplevel_savecards()),	Showvcard,SLOT(slot_kshowvcard_savefiles()));
	connect(this,SIGNAL(signal_ktoplevel_quitcard()),	Showvcard,SLOT(slot_kshowvcard_quitcard()));
	
	//signals from edit menu	
	connect(this,SIGNAL(signal_ktoplevel_add()),		Showvcard,SLOT(slot_kshowvcard_addcard()));
	connect(this,SIGNAL(signal_ktoplevel_del()),		Showvcard,SLOT(slot_kshowvcard_delcard()));
	connect(this,SIGNAL(signal_ktoplevel_selectall()),	Showvcard,SLOT(slot_kshowvcard_selectall()));
	connect(this,SIGNAL(signal_ktoplevel_unselectall()),	Showvcard,SLOT(slot_kshowvcard_unselectall()));
	connect(this,SIGNAL(signal_ktoplevel_invertselect()),	Showvcard,SLOT(slot_kshowvcard_invertselect()));	
	connect(this,SIGNAL(signal_ktoplevel_preferences()),	this, SLOT(slot_ktoplevel_show_preferences()));
//	setMinimumSize( 60, 330 );
}

TopLevel::~TopLevel()
  {
    delete FileMenu;
    delete EditMenu;
    delete MainMenu;
  };

void TopLevel::MenuInit()
  {
	KStdAccel stdAccel;

	FileMenu	= new QPopupMenu;
	EditMenu	= new QPopupMenu;
	HelpMenu	= new QPopupMenu;
	
	file_open_card = FileMenu->insertItem(i18n("&Open"), this,SIGNAL(signal_ktoplevel_opencard()), stdAccel.open() );
	FileMenu->insertSeparator();
	file_import_card = FileMenu->insertItem(i18n("&Import Vcards"), this,SIGNAL(signal_ktoplevel_importcards()) );
	file_export_card = FileMenu->insertItem(i18n("&Export Vcards"), this,SIGNAL(signal_ktoplevel_exportcards()) );
	FileMenu->insertSeparator();
	file_print_card = FileMenu->insertItem(i18n("&Print cards"), this,SIGNAL(signal_ktoplevel_printcards()) );
	FileMenu->insertSeparator();

	file_save_cards = FileMenu->insertItem(i18n("&Save"), this,SIGNAL(signal_ktoplevel_savecards()), stdAccel.save() );
	file_quit_card = FileMenu->insertItem(i18n("&Quit"), this,SIGNAL(signal_ktoplevel_quitcard()), stdAccel.quit());

	FileMenu->setItemEnabled(file_open_card,TRUE);
	FileMenu->setItemEnabled(file_import_card,TRUE);
	FileMenu->setItemEnabled(file_export_card,TRUE);
	FileMenu->setItemEnabled(file_save_cards,TRUE);
	FileMenu->setItemEnabled(file_quit_card,TRUE);

	editundo = EditMenu->insertItem(i18n("&Add"), this, SIGNAL(signal_ktoplevel_add()), stdAccel.openNew() );
	editcut  = EditMenu->insertItem(i18n("&Delete"), this, SIGNAL(signal_ktoplevel_del()), stdAccel.cut() );
	EditMenu->insertSeparator();
	editSelectAll = EditMenu->insertItem(i18n("&Select All"), this,SIGNAL(signal_ktoplevel_selectall()) );
	editUnselectAll = EditMenu->insertItem(i18n("Unse&lect All"), this,SIGNAL(signal_ktoplevel_unselectall()) );
	editInvertSelection = EditMenu->insertItem(i18n("&Invert Selection"),this,SIGNAL(signal_ktoplevel_invertselect()) );
	EditMenu->insertSeparator();
	editPreferences = EditMenu->insertItem(i18n("&Preferences"), this, SIGNAL(signal_ktoplevel_preferences()));

	EditMenu->setItemEnabled( editundo      , TRUE );
	EditMenu->setItemEnabled( editcut       , TRUE );
	EditMenu->setItemEnabled( editCopy  , TRUE );
	EditMenu->setItemEnabled( editSelectAll, TRUE );
	EditMenu->setItemEnabled( editUnselectAll, TRUE );
	EditMenu->setItemEnabled( editInvertSelection, TRUE );
	EditMenu->setItemEnabled( editPreferences, TRUE );
	
	QString about;
	
	about.sprintf(i18n("kvcard v%s\n\n"
                     "Copyright 2000\n"
                     "Adida Yoan : yoan.adida@lip6.fr"),VERSION);

	HelpMenu = mykapp->getHelpMenu(TRUE, about);
	
	MainMenu = new KMenuBar(this, "_mainMenu");
	MainMenu->show();
	MainMenu->insertItem( i18n("&File"), FileMenu);
	MainMenu->insertItem( i18n("&Edit"), EditMenu);
	MainMenu->insertItem( i18n("&Help"), HelpMenu);
}

void TopLevel::ToolbarInit()
{
	QWidget *w = new QWidget(this);
	QGridLayout *boxlayout = new QGridLayout(w,1,1,0);
	
	QPushButton* PushButton_ALL;
	PushButton_ALL = new QPushButton( w, "PushButton_ALL" );
	PushButton_ALL->setGeometry( 0, 0, 50, 20 );
	PushButton_ALL->setMinimumSize( 50, 20 );
	PushButton_ALL->setMaximumSize( 50, 20 );
	connect( PushButton_ALL, SIGNAL(clicked()), SLOT(slot_ktoplevel_show_all()) );
	PushButton_ALL->setFocusPolicy( QWidget::TabFocus );
	PushButton_ALL->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_ALL->setFontPropagation( QWidget::NoChildren );
	PushButton_ALL->setPalettePropagation( QWidget::NoChildren );
	PushButton_ALL->setText( i18n("ALL" ));
	PushButton_ALL->setAutoRepeat( FALSE );
	PushButton_ALL->setAutoResize( FALSE );
	PushButton_ALL->setToggleButton( FALSE );
	PushButton_ALL->setDefault( FALSE );
	PushButton_ALL->setAutoDefault( FALSE );
	PushButton_ALL->setIsMenuButton( FALSE );
	boxlayout->addWidget(PushButton_ALL,0,0);
	
	ToolBar = new KToolBar (this,"ToolBar");
	CHECK_PTR(ToolBar);
	addToolBar(ToolBar);
	w->recreate(ToolBar,0,QPoint(0,0));
	w->setFixedSize(50,20);
	ToolBar->enable(KToolBar::Show);
	ToolBar->setBarPos(KToolBar::Right);
	ToolBar->insertWidget(0,54,w);
	
	w=new QWidget(ToolBar);
	boxlayout = new QGridLayout(w,1,1,0);
	QPushButton* PushButton_A_B;
	PushButton_A_B = new QPushButton( w, "PushButton_A_B" );
	PushButton_A_B->setGeometry( 0, 0, 50, 20 );
	PushButton_A_B->setMinimumSize( 50, 20 );
	PushButton_A_B->setMaximumSize( 50, 20 );
	connect( PushButton_A_B, SIGNAL(clicked()), SLOT(slot_ktoplevel_show_a_b()) );
	PushButton_A_B->setFocusPolicy( QWidget::TabFocus );
	PushButton_A_B->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_A_B->setFontPropagation( QWidget::NoChildren );
	PushButton_A_B->setPalettePropagation( QWidget::NoChildren );
	PushButton_A_B->setText( "A-B" );
	PushButton_A_B->setAutoRepeat( FALSE );
	PushButton_A_B->setAutoResize( FALSE );
	PushButton_A_B->setToggleButton( FALSE );
	PushButton_A_B->setDefault( FALSE );
	PushButton_A_B->setAutoDefault( FALSE );
	PushButton_A_B->setIsMenuButton( FALSE );
	boxlayout->addWidget(PushButton_A_B,0,0);
	boxlayout->activate;
	w->setFixedSize(50,20);
	ToolBar->insertWidget(1,54,w);		
	
	w=new QWidget(ToolBar);
	boxlayout = new QGridLayout(w,1,1,0);
	QPushButton* PushButton_C_D;
	PushButton_C_D = new QPushButton( w, "PushButton_C_D" );
	PushButton_C_D->setGeometry( 0, 0, 50, 20 );
	PushButton_C_D->setMinimumSize( 50, 20 );
	PushButton_C_D->setMaximumSize( 50, 20 );
	connect( PushButton_C_D, SIGNAL(clicked()), SLOT(slot_ktoplevel_show_c_d()) );
	PushButton_C_D->setFocusPolicy( QWidget::TabFocus );
	PushButton_C_D->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_C_D->setFontPropagation( QWidget::NoChildren );
	PushButton_C_D->setPalettePropagation( QWidget::NoChildren );
	PushButton_C_D->setText( "C-D" );
	PushButton_C_D->setAutoRepeat( FALSE );
	PushButton_C_D->setAutoResize( FALSE );
	PushButton_C_D->setToggleButton( FALSE );
	PushButton_C_D->setDefault( FALSE );
	PushButton_C_D->setAutoDefault( FALSE );
	PushButton_C_D->setIsMenuButton( FALSE );
	boxlayout->addWidget(PushButton_C_D,0,0);
	boxlayout->activate;
	w->setFixedSize(50,20);
	ToolBar->insertWidget(2,54,w);		
	
	w=new QWidget(ToolBar);
	boxlayout = new QGridLayout(w,1,1,0);
	QPushButton* PushButton_E_F;
	PushButton_E_F = new QPushButton( w, "PushButton_E_F" );
	PushButton_E_F->setGeometry( 0, 0, 50, 20 );
	PushButton_E_F->setMinimumSize( 50, 20 );
	PushButton_E_F->setMaximumSize( 50, 20 );
	connect( PushButton_E_F, SIGNAL(clicked()), SLOT(slot_ktoplevel_show_e_f()) );
	PushButton_E_F->setFocusPolicy( QWidget::TabFocus );
	PushButton_E_F->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_E_F->setFontPropagation( QWidget::NoChildren );
	PushButton_E_F->setPalettePropagation( QWidget::NoChildren );
	PushButton_E_F->setText( "E-F" );
	PushButton_E_F->setAutoRepeat( FALSE );
	PushButton_E_F->setAutoResize( FALSE );
	PushButton_E_F->setToggleButton( FALSE );
	PushButton_E_F->setDefault( FALSE );
	PushButton_E_F->setAutoDefault( FALSE );
	PushButton_E_F->setIsMenuButton( FALSE );
	boxlayout->addWidget(PushButton_E_F,0,0);
	boxlayout->activate;
	w->setFixedSize(50,20);
	ToolBar->insertWidget(3,54,w);		
	
	w=new QWidget(ToolBar);
	boxlayout = new QGridLayout(w,1,1,0);
	QPushButton* PushButton_G_H;
	PushButton_G_H = new QPushButton( w, "PushButton_G_H" );
	PushButton_G_H->setGeometry( 0, 0, 50, 20 );
	PushButton_G_H->setMinimumSize( 50, 20 );
	PushButton_G_H->setMaximumSize( 50, 20 );
	connect( PushButton_G_H, SIGNAL(clicked()), SLOT(slot_ktoplevel_show_g_h()) );
	PushButton_G_H->setFocusPolicy( QWidget::TabFocus );
	PushButton_G_H->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_G_H->setFontPropagation( QWidget::NoChildren );
	PushButton_G_H->setPalettePropagation( QWidget::NoChildren );
	PushButton_G_H->setText( "G-H" );
	PushButton_G_H->setAutoRepeat( FALSE );
	PushButton_G_H->setAutoResize( FALSE );
	PushButton_G_H->setToggleButton( FALSE );
	PushButton_G_H->setDefault( FALSE );
	PushButton_G_H->setAutoDefault( FALSE );
	PushButton_G_H->setIsMenuButton( FALSE );
	boxlayout->addWidget(PushButton_G_H,0,0);
	boxlayout->activate;
	w->setFixedSize(50,20);
	ToolBar->insertWidget(4,54,w);		
	
	w=new QWidget(ToolBar);
	boxlayout = new QGridLayout(w,1,1,0);
	QPushButton* PushButton_I_J;
	PushButton_I_J = new QPushButton( w, "PushButton_I_J" );
	PushButton_I_J->setGeometry( 0, 0, 50, 20 );
	PushButton_I_J->setMinimumSize( 50, 20 );
	PushButton_I_J->setMaximumSize( 50, 20 );
	connect( PushButton_I_J, SIGNAL(clicked()), SLOT(slot_ktoplevel_show_i_j()) );
	PushButton_I_J->setFocusPolicy( QWidget::TabFocus );
	PushButton_I_J->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_I_J->setFontPropagation( QWidget::NoChildren );
	PushButton_I_J->setPalettePropagation( QWidget::NoChildren );
	PushButton_I_J->setText( "I-J" );
	PushButton_I_J->setAutoRepeat( FALSE );
	PushButton_I_J->setAutoResize( FALSE );
	PushButton_I_J->setToggleButton( FALSE );
	PushButton_I_J->setDefault( FALSE );
	PushButton_I_J->setAutoDefault( FALSE );
	PushButton_I_J->setIsMenuButton( FALSE );
	boxlayout->addWidget(PushButton_I_J,0,0);
	boxlayout->activate;
	w->setFixedSize(50,20);
	ToolBar->insertWidget(5,54,w);		
	
	w=new QWidget(ToolBar);
	boxlayout = new QGridLayout(w,1,1,0);
	QPushButton* PushButton_K_L;
	PushButton_K_L = new QPushButton( w, "PushButton_K_L" );
	PushButton_K_L->setGeometry( 0, 0, 50, 20 );
	PushButton_K_L->setMinimumSize( 50, 20 );
	PushButton_K_L->setMaximumSize( 50, 20 );
	connect( PushButton_K_L, SIGNAL(clicked()), SLOT(slot_ktoplevel_show_k_l()) );
	PushButton_K_L->setFocusPolicy( QWidget::TabFocus );
	PushButton_K_L->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_K_L->setFontPropagation( QWidget::NoChildren );
	PushButton_K_L->setPalettePropagation( QWidget::NoChildren );
	PushButton_K_L->setText( "K-L" );
	PushButton_K_L->setAutoRepeat( FALSE );
	PushButton_K_L->setAutoResize( FALSE );
	PushButton_K_L->setToggleButton( FALSE );
	PushButton_K_L->setDefault( FALSE );
	PushButton_K_L->setAutoDefault( FALSE );
	PushButton_K_L->setIsMenuButton( FALSE );
	boxlayout->addWidget(PushButton_K_L,0,0);
	boxlayout->activate;
	w->setFixedSize(50,20);
	ToolBar->insertWidget(6,54,w);		
	
	w=new QWidget(ToolBar);
	boxlayout = new QGridLayout(w,1,1,0);
	QPushButton* PushButton_M_N;
	PushButton_M_N = new QPushButton( w, "PushButton_M_N" );
	PushButton_M_N->setGeometry( 0, 0, 50, 20 );
	PushButton_M_N->setMinimumSize( 50, 20 );
	PushButton_M_N->setMaximumSize( 50, 20 );
	connect( PushButton_M_N, SIGNAL(clicked()), SLOT(slot_ktoplevel_show_m_n()) );
	PushButton_M_N->setFocusPolicy( QWidget::TabFocus );
	PushButton_M_N->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_M_N->setFontPropagation( QWidget::NoChildren );
	PushButton_M_N->setPalettePropagation( QWidget::NoChildren );
	PushButton_M_N->setText( "M-N" );
	PushButton_M_N->setAutoRepeat( FALSE );
	PushButton_M_N->setAutoResize( FALSE );
	PushButton_M_N->setToggleButton( FALSE );
	PushButton_M_N->setDefault( FALSE );
	PushButton_M_N->setAutoDefault( FALSE );
	PushButton_M_N->setIsMenuButton( FALSE );
	boxlayout->addWidget(PushButton_M_N,0,0);
	boxlayout->activate;
	w->setFixedSize(50,20);
	ToolBar->insertWidget(7,54,w);		
	
	w=new QWidget(ToolBar);
	boxlayout = new QGridLayout(w,1,1,0);
	QPushButton* PushButton_O_P;
	PushButton_O_P = new QPushButton( w, "PushButton_O_P" );
	PushButton_O_P->setGeometry( 0, 0, 50, 20 );
	PushButton_O_P->setMinimumSize( 50, 20 );
	PushButton_O_P->setMaximumSize( 50, 20 );
	connect( PushButton_O_P, SIGNAL(clicked()), SLOT(slot_ktoplevel_show_o_p()) );
	PushButton_O_P->setFocusPolicy( QWidget::TabFocus );
	PushButton_O_P->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_O_P->setFontPropagation( QWidget::NoChildren );
	PushButton_O_P->setPalettePropagation( QWidget::NoChildren );
	PushButton_O_P->setText( "O-P" );
	PushButton_O_P->setAutoRepeat( FALSE );
	PushButton_O_P->setAutoResize( FALSE );
	PushButton_O_P->setToggleButton( FALSE );
	PushButton_O_P->setDefault( FALSE );
	PushButton_O_P->setAutoDefault( FALSE );
	PushButton_O_P->setIsMenuButton( FALSE );
	boxlayout->addWidget(PushButton_O_P,0,0);
	boxlayout->activate;
	w->setFixedSize(50,20);
	ToolBar->insertWidget(8,54,w);		
	
	w=new QWidget(ToolBar);
	boxlayout = new QGridLayout(w,1,1,0);
	QPushButton* PushButton_Q_R;
	PushButton_Q_R = new QPushButton( w, "PushButton_Q_R" );
	PushButton_Q_R->setGeometry( 0, 0, 50, 20 );
	PushButton_Q_R->setMinimumSize( 50, 20 );
	PushButton_Q_R->setMaximumSize( 50, 20 );
	connect( PushButton_Q_R, SIGNAL(clicked()), SLOT(slot_ktoplevel_show_q_r()) );
	PushButton_Q_R->setFocusPolicy( QWidget::TabFocus );
	PushButton_Q_R->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_Q_R->setFontPropagation( QWidget::NoChildren );
	PushButton_Q_R->setPalettePropagation( QWidget::NoChildren );
	PushButton_Q_R->setText( "Q-R" );
	PushButton_Q_R->setAutoRepeat( FALSE );
	PushButton_Q_R->setAutoResize( FALSE );
	PushButton_Q_R->setToggleButton( FALSE );
	PushButton_Q_R->setDefault( FALSE );
	PushButton_Q_R->setAutoDefault( FALSE );
	PushButton_Q_R->setIsMenuButton( FALSE );
	boxlayout->addWidget(PushButton_Q_R,0,0);
	boxlayout->activate;
	w->setFixedSize(50,20);
	ToolBar->insertWidget(9,54,w);		
	
	w=new QWidget(ToolBar);
	boxlayout = new QGridLayout(w,1,1,0);
	QPushButton* PushButton_S_T;
	PushButton_S_T = new QPushButton( w, "PushButton_S_T" );
	PushButton_S_T->setGeometry( 0, 0, 50, 20 );
	PushButton_S_T->setMinimumSize( 50, 20 );
	PushButton_S_T->setMaximumSize( 50, 20 );
	connect( PushButton_S_T, SIGNAL(clicked()), SLOT(slot_ktoplevel_show_s_t()) );
	PushButton_S_T->setFocusPolicy( QWidget::TabFocus );
	PushButton_S_T->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_S_T->setFontPropagation( QWidget::NoChildren );
	PushButton_S_T->setPalettePropagation( QWidget::NoChildren );
	PushButton_S_T->setText( "S-T" );
	PushButton_S_T->setAutoRepeat( FALSE );
	PushButton_S_T->setAutoResize( FALSE );
	PushButton_S_T->setToggleButton( FALSE );
	PushButton_S_T->setDefault( FALSE );
	PushButton_S_T->setAutoDefault( FALSE );
	PushButton_S_T->setIsMenuButton( FALSE );
	boxlayout->addWidget(PushButton_S_T,0,0);
	boxlayout->activate;
	w->setFixedSize(50,20);
	ToolBar->insertWidget(10,54,w);		
	
	w=new QWidget(ToolBar);
	boxlayout = new QGridLayout(w,1,1,0);
	QPushButton* PushButton_U_V;
	PushButton_U_V = new QPushButton( w, "PushButton_U_V" );
	PushButton_U_V->setGeometry( 0, 0, 50, 20 );
	PushButton_U_V->setMinimumSize( 50, 20 );
	PushButton_U_V->setMaximumSize( 50, 20 );
	connect( PushButton_U_V, SIGNAL(clicked()), SLOT(slot_ktoplevel_show_u_v()) );
	PushButton_U_V->setFocusPolicy( QWidget::TabFocus );
	PushButton_U_V->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_U_V->setFontPropagation( QWidget::NoChildren );
	PushButton_U_V->setPalettePropagation( QWidget::NoChildren );
	PushButton_U_V->setText( "U-V" );
	PushButton_U_V->setAutoRepeat( FALSE );
	PushButton_U_V->setAutoResize( FALSE );
	PushButton_U_V->setToggleButton( FALSE );
	PushButton_U_V->setDefault( FALSE );
	PushButton_U_V->setAutoDefault( FALSE );
	PushButton_U_V->setIsMenuButton( FALSE );
	boxlayout->addWidget(PushButton_U_V,0,0);
	boxlayout->activate;
	w->setFixedSize(50,20);
	ToolBar->insertWidget(11,54,w);		
	
	w=new QWidget(ToolBar);
	boxlayout = new QGridLayout(w,1,1,0);
	QPushButton* PushButton_W_X;
	PushButton_W_X = new QPushButton( w, "PushButton_W_X" );
	PushButton_W_X->setGeometry( 0, 0, 50, 20 );
	PushButton_W_X->setMinimumSize( 50, 20 );
	PushButton_W_X->setMaximumSize( 50, 20 );
	connect( PushButton_W_X, SIGNAL(clicked()), SLOT(slot_ktoplevel_show_w_x()) );
	PushButton_W_X->setFocusPolicy( QWidget::TabFocus );
	PushButton_W_X->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_W_X->setFontPropagation( QWidget::NoChildren );
	PushButton_W_X->setPalettePropagation( QWidget::NoChildren );
	PushButton_W_X->setText( "W-X" );
	PushButton_W_X->setAutoRepeat( FALSE );
	PushButton_W_X->setAutoResize( FALSE );
	PushButton_W_X->setToggleButton( FALSE );
	PushButton_W_X->setDefault( FALSE );
	PushButton_W_X->setAutoDefault( FALSE );
	PushButton_W_X->setIsMenuButton( FALSE );
	boxlayout->addWidget(PushButton_W_X,0,0);
	boxlayout->activate;
	w->setFixedSize(50,20);
	ToolBar->insertWidget(12,54,w);		
	
	w=new QWidget(ToolBar);
	boxlayout = new QGridLayout(w,1,1,0);
	QPushButton* PushButton_Y_Z;
	PushButton_Y_Z = new QPushButton( w, "PushButton_Y_Z" );
	PushButton_Y_Z->setGeometry( 0, 0, 50, 20 );
	PushButton_Y_Z->setMinimumSize( 50, 20 );
	PushButton_Y_Z->setMaximumSize( 50, 20 );
	connect( PushButton_Y_Z, SIGNAL(clicked()), SLOT(slot_ktoplevel_show_y_z()) );
	PushButton_Y_Z->setFocusPolicy( QWidget::TabFocus );
	PushButton_Y_Z->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_Y_Z->setFontPropagation( QWidget::NoChildren );
	PushButton_Y_Z->setPalettePropagation( QWidget::NoChildren );
	PushButton_Y_Z->setText( "Y-Z" );
	PushButton_Y_Z->setAutoRepeat( FALSE );
	PushButton_Y_Z->setAutoResize( FALSE );
	PushButton_Y_Z->setToggleButton( FALSE );
	PushButton_Y_Z->setDefault( FALSE );
	PushButton_Y_Z->setAutoDefault( FALSE );
	PushButton_Y_Z->setIsMenuButton( FALSE );
	boxlayout->addWidget(PushButton_Y_Z,0,0);
	boxlayout->activate;
	w->setFixedSize(50,20);
	ToolBar->insertWidget(13,54,w);	

QToolTip::add(PushButton_ALL,i18n("Display all the cards"));
QToolTip::add(PushButton_A_B,i18n("Display the cards for\nwhich the Name starts\n    with A or B"));
QToolTip::add(PushButton_C_D,i18n("Display the cards for\nwhich the Name starts\n    with C or D"));
QToolTip::add(PushButton_E_F,i18n("Display the cards for\nwhich the Name starts\n    with E or F"));
QToolTip::add(PushButton_G_H,i18n("Display the cards for\nwhich the Name starts\n    with G or H"));
QToolTip::add(PushButton_I_J,i18n("Display the cards for\nwhich the Name starts\n    with I or J"));
QToolTip::add(PushButton_K_L,i18n("Display the cards for\nwhich the Name starts\n    with K or L"));
QToolTip::add(PushButton_M_N,i18n("Display the cards for\nwhich the Name starts\n    with M or N"));
QToolTip::add(PushButton_O_P,i18n("Display the cards for\nwhich the Name starts\n    with O or P"));
QToolTip::add(PushButton_Q_R,i18n("Display the cards for\nwhich the Name starts\n    with Q or R"));
QToolTip::add(PushButton_S_T,i18n("Display the cards for\nwhich the Name starts\n    with S or T"));
QToolTip::add(PushButton_U_V,i18n("Display the cards for\nwhich the Name starts\n    with U or V"));
QToolTip::add(PushButton_W_X,i18n("Display the cards for\nwhich the Name starts\n    with W or X"));
QToolTip::add(PushButton_Y_Z,i18n("Display the cards for\nwhich the Name starts\n    with Y or Z"));
}

void TopLevel::ShowInit()
{
	Showvcard = new KShowvcard(mykapp, this, "Showvcard");
	setView(Showvcard, False);
	Showvcard->setFocus();
}


void TopLevel::slot_ktoplevel_show_all(){emit signal_ktoplevel_show(0);}
void TopLevel::slot_ktoplevel_show_a_b(){emit signal_ktoplevel_show(1);}
void TopLevel::slot_ktoplevel_show_c_d(){emit signal_ktoplevel_show(2);}
void TopLevel::slot_ktoplevel_show_e_f(){emit signal_ktoplevel_show(3);}
void TopLevel::slot_ktoplevel_show_g_h(){emit signal_ktoplevel_show(4);}
void TopLevel::slot_ktoplevel_show_i_j(){emit signal_ktoplevel_show(5);}
void TopLevel::slot_ktoplevel_show_k_l(){emit signal_ktoplevel_show(6);}
void TopLevel::slot_ktoplevel_show_m_n(){emit signal_ktoplevel_show(7);}
void TopLevel::slot_ktoplevel_show_o_p(){emit signal_ktoplevel_show(8);}
void TopLevel::slot_ktoplevel_show_q_r(){emit signal_ktoplevel_show(9);}
void TopLevel::slot_ktoplevel_show_s_t(){emit signal_ktoplevel_show(10);}
void TopLevel::slot_ktoplevel_show_u_v(){emit signal_ktoplevel_show(11);}
void TopLevel::slot_ktoplevel_show_w_x(){emit signal_ktoplevel_show(12);}
void TopLevel::slot_ktoplevel_show_y_z(){emit signal_ktoplevel_show(13);}

void TopLevel::slot_ktoplevel_show_preferences()
{
	pref->show();
}

int main (int argc, char **argv)
{
	bool have_top_window = false;
	mykapp = new KApplication (argc, argv, "kvcard");

	if ( mykapp->isRestored() )
		{
		int n = 1;
		while (KTMainWindow::canBeRestored(n))
			{
			TopLevel *tl = new TopLevel();
			tl->restore(n);
			TopLevel::windowList.append( tl );
			n++;
			have_top_window = true;
			}
		}
	else
  		{
		have_top_window = false;
		if(!have_top_window)
			{
			TopLevel *t = new TopLevel ();
			t->show ();
			TopLevel::windowList.append( t );
    		}
	}
	return mykapp->exec ();
}
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
