/***************************************************************************
                          kpreferences.h  -  description
			This Class handles the preferences
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by Yoan Adida
    email                : yoan.adida@lip6.fr
 ***************************************************************************/
#include <stdlib.h>
#include <kapp.h>
#include <kconfig.h>
#include <kfiledialog.h>
#include <kwizard.h>
#include <qcombo.h>
#include <qlabel.h>
#include <qdialog.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qstring.h>
#include <kmsgbox.h>
#include <qtooltip.h>

class Preferences : public KDialog
{
    Q_OBJECT

public:

    Preferences
        (
        KApplication *a=NULL,
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~Preferences();

public slots:
//	void slot_kpreferences_show();

protected slots:

	virtual void slot_kpreferences_autoloadaddressbook(bool);
	virtual void slot_kpreferences_autoexportkmail(bool);
	virtual void slot_kpreferences_autoexportkab(bool);
	virtual void slot_kpreferences_autosaveonquit(bool);
	virtual void slot_kpreferences_vcarddirectory();
	virtual void slot_kpreferences_vcardextensions(bool);
	virtual void slot_kpreferences_vcardextensionsdirectory();
	virtual void slot_kpreferences_small(bool);
	virtual void slot_kpreferences_medium(bool);
	virtual void slot_kpreferences_complete(bool);
	virtual void slot_kpreferences_overcomplete(bool);
	virtual void slot_kpreferences_date_activatedint(int);
	virtual void slot_kpreferences_ok();	
	virtual void slot_kpreferences_cancel();

protected:
	virtual void closeEvent(QCloseEvent*);
	void read_preferences();
	void write_preferences();
	bool convert_read(QString);
	void setToolTips();	
private:
	QButtonGroup* ButtonGroup_Preferences;
	QCheckBox* CheckBox_AutoLoadAddressBook;	
	QCheckBox* CheckBox_AutoExportKmail;	
	QCheckBox* CheckBox_AutoExportKab;	
	QCheckBox* CheckBox_AutoSaveonQuit;	
	QPushButton* PushButton_VcardDirectory;
	QCheckBox* CheckBox_VcardExtensions;	
	QPushButton* PushButton_VcardExtensionsDirectory;
	QRadioButton* RadioButton_SmallVcards;	
	QRadioButton* RadioButton_MediumVcards;	
	QRadioButton* RadioButton_CompleteVcards;	
	QRadioButton* RadioButton_OverCompleteVcards;
	QLabel*	Label_Date;
	QComboBox*	ComboBox_Date;
	QPushButton* PushButton_Print;
	QPushButton* PushButton_Ok;
	QPushButton* PushButton_Cancel;

	bool autoloadaddressbook;
	bool autoexportkmail;
	bool autoexportkab;
	bool autosaveonquit;
	bool vcardextensions;
	bool small;
	bool medium;
	bool complete;
	bool overcomplete;
	int date;
	
	bool default_autoloadaddressbook;
	bool default_autoexportkmail;
	bool default_autoexportkab;
	bool default_autosaveonquit;
	bool default_vcardextensions;
	bool default_small;
	bool default_medium;
	bool default_complete;
	bool default_overcomplete;
	int default_date;
	
	KApplication *mykapp;
	KConfig	*config;
	QString vcarddirectory;
	QString vcardextensionsdirectory;
};
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
