/***************************************************************************
                          TabData.h  -  description
	This Class handles the Tab dialog and the tabs data
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by Yoan Adida
    email                : yoan.adida@lip6.fr
 ***************************************************************************/
#include <kapp.h>
#include <qwidget.h>
#include <qdialog.h>
#include <qtabdlg.h>
#include <qtabdialog.h>
#include "GeneralData.h"
#include "DetailsData.h"
#include "ExtensionsData.h"

class TabData : public QTabDialog
{
    Q_OBJECT

public:

    TabData
    (
        KApplication *a =NULL,
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~TabData();

signals:
	void signal_tabdata_apply();
	void signal_tabdata_cancel();
	void signal_tabdata_updategeneral(QString);
	void signal_tabdata_updatedetails(QString);
	void signal_tabdata_updateextensions(QString);
	void signal_tabdata_receivegeneral(QString);	
	void signal_tabdata_receivedetails(QString);
	void signal_tabdata_receiveextensions(QString);	

public slots:
	void slot_tabdata_updategeneral(QString);
   	void slot_tabdata_updatedetails(QString);
	void slot_tabdata_updateextensions(QString);	
	void slot_tabdata_receivegeneral(QString);
	void slot_tabdata_receivedetails(QString);
	void slot_tabdata_receiveextensions(QString);
		
protected slots:
	void slot_tabdata_apply();
	void slot_tabdata_cancel();
	
protected:
	KApplication *mykapp;	
	GeneralData *General;
	DetailsData *Details;
	ExtensionsData *Extensions;
	QString StringTab1,StringTab2,StringTab3;
};

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
