/* -*- C++ -*- */

#ifndef __NPT_H__
#define __NPT_H__

#include <qlist.h>
#include "matrix.h"
#include "action.h"


class NPT  {
public:
   NPT(int);
   ~NPT();
   /* proc maintanance */
   int AddProc(Action *a); 
   int DelProc(int);
   int DelProc(int, int);
   
   void Clear();
  
   Action *GetProc(int i) /*const*/;
   Action *GetProc(int, int);
   
   const int Count() {return dur.count();}
  
   void setDur(int  i, long l) {Action *a=GetProc(i); if (a) a->setDur(l);}
   void setPred(int i,  long l)  {Action *a=GetProc(i); if (a) a->setPred(l);}
   void setSucc(int i, long l)  {Action *a=GetProc(i); if (a) a->setSucc(l);}
   void setText(int i, const char *sz)  {Action *a=GetProc(i); if (a) a->setText(sz);}
    
   long getDur(int i)  {Action *a=GetProc(i);   return (a!=0) ?  a->getDur() :  -1L;}
   long getPred(int i) {Action *a=GetProc(i); return (a!=0) ?  a->getPred() :  -1L;}
   long getSucc(int i) {Action *a=GetProc(i);  return (a!=0) ?   a->getSucc() :  -1L;}
   const char *getText(int i) {Action *a=GetProc(i); return (a!=0) ?   a->getText() :  0;}

   QMatrix *getList() {return &dur;}  
   void getFmtStr(int i, char *sz, char sep) ;
   
   void PrintProcs();
   /* is node already occupied? */
   int IsOcc(int x, int y)  {return GetProc(x,y)!=0 ? 1 : 0;}

   /* operations */
   long TotalDur() const {return pd;}
   int CalcTimes();
   /* disk IO */
   int loadFile(const char*);
   int saveFile(const char*);
protected:
   /* tripel algorithm */
   int PerformTripel(int, int);
   /* calculate buffer times */
   int FeedForward(int, int);
   int FeedBackward(int, int); 
private:
   /* process input string */
   int evalString(char *);
   int Str2Index(char *, int *, int *);
   
   int maxx,maxy;
   long pd;
   QMatrix dur;
   char *filename;
};


#endif

