// -*- C++ -*-
/* This file is part of
* ======================================================
*
*           LyX, the High Level Word Processor
*
*           Copyright (C) 1995 1996 Matthias Ettrich
*           and the LyX Team.
*
*======================================================*/

#include <config.h>

#include "klyx.h"
#include "CharacterStyleDialog.h"
#include "ParagraphDialog.h"
#include "DocumentLayoutDialog.h"
#include "MathSpacingDialog.h"
#include "MathMatrixDialog.h"
#include "MathDelimiterDialog.h"
#include "SendFaxDialog.h"
#include "ExportCustomDialog.h"
#include "SpellCheckDialog.h"
#include "TableOfContentsDialog.h"
#include "FindReplaceDialog.h"
#include "AskForTextDialog.h"
#include <kapp.h>
#include <klocale.h>
#include <ktopwidget.h>
#include <qmsgbox.h>

#include <errno.h>
#include "lyx_gui_misc.h"
#include "BufferView.h"
#include "buffer.h"
#include "lyx_cb.h"
#include "lyx_main.h"
#include "minibuffer.h"
#include "LyXView.h"

extern BufferView *current_view;
// 	$Id: lyx_gui_misc.C,v 1.27 1999/01/05 11:17:18 kulow Exp $	

#if !defined(lint) && !defined(WITH_WARNINGS)
static char vcid[] = "$Id: lyx_gui_misc.C,v 1.27 1999/01/05 11:17:18 kulow Exp $";
#endif /* lint */


// Prevents LyX from crashing when no buffers available
// This is also one of the functions that we _really_ dont want
// we should try to finds way to help us with that.
// The signal/slot mechanism can probably help.
void CloseAllBufferRelatedPopups()
{
  // don't forget to check that dynamically created forms
  // have been created otherwise hiding one could cause a crash
  // need the visible check otherwise XForms prints a warning
  // if hiding an invisible form
  if( klyxdialogs->paragraph && klyxdialogs->paragraph->isVisible() )
	klyxdialogs->paragraph->hide();

  if( klyxdialogs->character && klyxdialogs->character->isVisible() )
    klyxdialogs->character->hide();

  if( klyxdialogs->document && klyxdialogs->document->isVisible() )
    klyxdialogs->document->hide();

  if( klyxdialogs->mathspacing && klyxdialogs->mathspacing->isVisible() )
	klyxdialogs->mathspacing->hide();

  if( klyxdialogs->mathmatrix && klyxdialogs->mathmatrix->isVisible() )
	klyxdialogs->mathmatrix->hide();

  if( klyxdialogs->mathdelimiter && klyxdialogs->mathdelimiter->isVisible() )
	klyxdialogs->mathdelimiter->hide();

  if( klyxdialogs->sendfax && klyxdialogs->sendfax->isVisible() )
	klyxdialogs->sendfax->hide();

  if( klyxdialogs->logfile && klyxdialogs->logfile->isVisible() )
	klyxdialogs->logfile->hide();

  if( klyxdialogs->phonebook && klyxdialogs->phonebook->isVisible() )
	klyxdialogs->phonebook->hide();

  if( klyxdialogs->exportcustom && klyxdialogs->exportcustom->isVisible() )
	klyxdialogs->exportcustom->hide();

  if( klyxdialogs->spellchecker && klyxdialogs->spellchecker->isVisible() )
	klyxdialogs->spellchecker->hide();

  if( klyxdialogs->toc && klyxdialogs->toc->isVisible() )
  	klyxdialogs->toc->hide();

  if( klyxdialogs->findreplace && klyxdialogs->findreplace->isVisible() )
	klyxdialogs->findreplace->hide();

  return; //TODO Matthias. Save our souls. Some dialogs from
  // the list below are no longer valid but uninitialized
}


// Extract shortcut from <ident>|<shortcut> string
const char* flyx_shortcut_extract(const char*sc)
{
	// Find '|' in the sc and return the string after that.
	register const char *sd = sc;
	while(sd[0]!=0 && sd[0] != '|') sd++;

	if (sd[0]=='|') {
		sd++;
		//fprintf(stderr, "%s\n", sd);
		return sd;
	}
	return "";
}

// Extract identifier from <ident>|<shortcut> string
const char* flyx_ident_extract(const char *sc)
{
	register const char *se = sc;
	while(se[0]!=0 && se[0] != '|') se++;

	if (se[0]==0) return sc;
	
	char * sb = new char[se-sc + 1];
	int index = 0;
	register const char *sd = sc;
	while (sd != se) {
		sb[index] = sd[0];
		index++; sd++;
	}
	sb[index]=0;
	return sb;
}

//
void WriteAlert(LString const & s1, LString const & s2, LString const & s3)
{
  if (current_view && current_view->getMiniBuffer())
	{
	  current_view->getMiniBuffer()->Set(s1, s2, s3);
	}

  LString text = s1 + '\n' + s2 + '\n' + s3;
  (void)QMessageBox::critical( current_view ? k_tlw : 0,
			       i18n("Alert"),
			       text.c_str(),
			       0, 0, 0 );
}


// Alarms user of something related to files
void WriteFSAlert(LString const & s1, LString const & s2)
{
	WriteAlert (s1, s2, strerror(errno));
}


// returns true for yes
bool AskQuestion(LString const & s1, LString const & s2, LString const & s3)
{
  LString text = s1 + '\n' + s2 + '\n' + s3;
  int nret = QMessageBox::information( current_view ? k_tlw : 0,
				       i18n( "Question" ),
				       text.c_str(),
				       i18n( "Yes" ),
				       i18n( "No" ),
				       (const char*)0, // no third button
				       0, // Yes is default
				       1 ); // escape is no
  return (nret == 0);
}

// Returns 1 for yes, 2 for no, 3 for cancel.
int AskConfirmation(LString const & s1, LString const & s2, LString const & s3)
{
  LString text = s1 + '\n' + s2 + '\n' + s3;
  int nret = QMessageBox::information( current_view ? k_tlw : 0,
				       i18n( "Information" ),
				       text.c_str(),
				       i18n( "Yes" ),
				       i18n( "No" ),
				       i18n( "Cancel" ),
				       0, 2 );

  return nret + 1; // QMessageBox uses 0,1,2; XForms uses 1,2,3
}


// Asks for a text
LString askForText(LString const & msg, LString const & dflt)
{
  AskForTextDialog dlg( current_view->getOwner() );
  dlg.setMessage( msg.c_str() );
  dlg.setDefault( dflt.c_str() );
  dlg.setEditFocus();
  int ret = dlg.exec();
  if( ret == QDialog::Accepted )
	return LString( dlg.text() );
  else
	return "";
}

// Inform the user that the buffer is read-only, and that changes in the
// dialog box that is to appear will be ignored.
void WarnReadonly()
{
	WriteAlert(i18n("Any changes will be ignored"),
		   i18n("The document is read-only:"),
		   current_view->currentBuffer()->getFileName());
}

