/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
* 	 
*	    Copyright (C) 1995 1996 Matthias Ettrich
*           and the LyX Team
*======================================================*/

/*
 *	International support for LyX
 */

/*
 * This file screams to be written as a class.
 * I will do that as soon as we start the 0.11.x series. [Lgb]
 */

#include <config.h>

#include <kapp.h>
#include <klocale.h>

#include "intl.h"
#include "tex-strings.h"
#include "error.h"
#include "lyxrc.h"
#include "trans_mgr.h"
#include "KeyboardOptionsDialog.h"
#include "BufferView.h"

// 	$Id: intl.C,v 1.11 1999/01/05 11:17:15 kulow Exp $	

#if !defined(lint) && !defined(WITH_WARNINGS)
static char vcid[] = "$Id: intl.C,v 1.11 1999/01/05 11:17:15 kulow Exp $";
#endif /* lint */

// lyx rc 
extern LyXRC* lyxrc;
extern BufferView* current_view;


Intl::Intl()
  : prim_lang(lyxrc->primary_kbmap), 
	sec_lang(lyxrc->secondary_kbmap),
	trans(new TransManager)
{
  keymapon = lyxrc->use_kbmap;
  chsetcode = NULL;
  primarykeymap = false;
  curkeymap = 0;
  otherkeymap = 0;

  keydialog = 0;
}


Intl::~Intl()
{
  delete keydialog;
}


int Intl::SetPrimary(LString const & lang)
{
  if (lyxerr.debugging(Error::KBMAP))
	lyxerr.print("Primary: `" + lang + "'");
  return trans->SetPrimary(lang);
}


int Intl::SetSecondary(LString const & lang)
{
  if (lyxerr.debugging(Error::KBMAP))
	lyxerr.print("Secondary: `" + lang + "'");
  return trans->SetSecondary(lang);
}


void Intl::update()
{
  bool off,prim,sec;
  
  off=prim=sec=false;
  
  if (!keymapon) {
	off=true;
  } else {
	if (primarykeymap) {
	  prim=true;
	} else {
	  sec=true;
	}
  }

  keydialog->setKeymapButtons( off, prim, sec );
}


void Intl::KeyMapOn(bool on)
	/* turn on/off key mappings, status in keymapon */
{
  keymapon = on;

  if (!keydialog) return;
	
  keydialog->setKeymapButtons( false, false, false );

  if (on) {
	if (primarykeymap) {
	  KeyMapPrim();
	} else {
	  KeyMapSec();
	}
  } else {
	keydialog->setNoKeymapButton();
	keydialog->hideError();
	trans->DisableKeymap();
  }
}


void Intl::ToggleKeyMap()
{
  if (keymapon && primarykeymap) {
	KeyMapSec();
  } else if (keymapon) {
	KeyMapOn(false);
  } else	
	KeyMapPrim();
}


void Intl::KeyMapPrim()
{
  int i;
  LString p;
  
  keydialog->setKeymapButtons( false, true, false );

  /* read text from choice */
  i = keydialog->getPrimaryCode();
  
  if (lyxerr.debugging(Error::KBMAP))
	lyxerr.print(LString("Table: ") + tex_babel[i-1].name);
  
  if (i == otherkeymap)
	p = keydialog->getPrimaryOther();
  else
	p = keydialog->getPrimaryLanguage();
  
  curkeymap = i;
  
  if (p.empty() || trans->SetPrimary(p)) {
	// error selecting keymap
	keydialog->showError();
	update();
  } else {
	// no error
	trans->EnablePrimary();
	keymapon = true;
	primarykeymap = true;
	keydialog->hideError();
  }
}


void Intl::KeyMapSec()
{
  int i;
  LString p;
  
  keydialog->setKeymapButtons( false, false, true );

  /* read text from choice */
  i = keydialog->getSecondaryCode();
	
  if (lyxerr.debugging(Error::KBMAP))
	lyxerr.print(LString("Table: ") + tex_babel[i-1].name);

  if (i == otherkeymap)
	p = keydialog->getSecondaryOther();
  else
	p = keydialog->getSecondaryLanguage();

  curkeymap = i;

  if (p.empty() || trans->SetSecondary(p)) {
	// error selecting keymap
	keydialog->showError();
	update();
  } else {
	// no error
	trans->EnableSecondary();
	keymapon = true;
	primarykeymap = false;
	keydialog->hideError();
  }
}


void Intl::InitKeyMapper(bool on)
  /* initialize key mapper */
{
  KConfig* config = kapp->getConfig();
  KConfigGroupSaver saver( config, "ScreenOptions" );

  lyxerr.debug("Initializing key mappings...", Error::KBMAP);
  
  keymapon = on;
  
  keydialog = new KeyboardOptionsDialog( current_view->getOwner() );
  keydialog->setIntl( this );

  keydialog->setCharset( config->readEntry( "FontNorm", DEFCHSET ) );

  int n=0, deflang=0;
  
  while (true)
	if (!strlen(tex_babel[n].name))
	  break;
	else {
	  if (DEFLANG_VAR == tex_babel[n].code) deflang = n;
	  keydialog->insertPrimaryLanguage( tex_babel[n].name );
	  keydialog->insertSecondaryLanguage( tex_babel[n].name );
	  n++;
	}
	
  keydialog->insertPrimaryLanguage( i18n( "Other..." ) );
  keydialog->insertSecondaryLanguage( i18n( "Other..." ) );
  otherkeymap = n+1;

  keydialog->setCurrentPrimary(deflang);
  keydialog->setCurrentSecondary(0);

  if( !keydialog->isInPrimary( prim_lang.c_str() ) ) {
	if (prim_lang != "") {
		keydialog->setCurrentPrimary( n );
		keydialog->setPrimaryOther( prim_lang.c_str() );
	}
  }
  else 
	trans->SetPrimary(prim_lang);

  if( !keydialog->isInSecondary( sec_lang.c_str() ) ) {
	if (sec_lang != "") {
		keydialog->setCurrentSecondary( n );
		keydialog->setSecondaryOther( sec_lang.c_str() );
	}
  }
  else 
	trans->SetSecondary( sec_lang );

  KeyMapOn(keymapon);
  if (keymapon)
	keydialog->primaryKeymapToggled( true );

  trans->setCharset( config->readEntry( "FontNorm", DEFCHSET ) );
}


void Intl::MenuKeymap()
{
  if( !keydialog )
	keydialog = new KeyboardOptionsDialog( current_view->getOwner() );

  (void)keydialog->exec();
}
