/*
 * $Id: SpellcheckerOptionsDialog.h,v 1.3 1998/03/04 21:49:54 kalle Exp $
 */

#ifndef _SPELLCHECKEROPTIONSDIALOG_H
#define _SPELLCHECKEROPTIONSDIALOG_H

#include <qdialog.h>
#include <qstring.h>

#include "lyxdummies.h"

class QCheckBox;
class QLineEdit;
class QRadioButton;

struct SpellcheckerOptionsDialogData
{
  enum Dictionary { Document, Alternate };
  Dictionary dictionary;
  QString alternate_language;

  bool runtogether_words_legal;
  bool input_encoding_ispell;
  bool use_alternate_personal_dictionary;
  QString alternate_personal_dictionary;
  bool allow_extra_special_chars;
  QString extra_special_chars_allowed;
};


class SpellcheckerOptionsDialog : public QDialog
{
  Q_OBJECT

public:
  SpellcheckerOptionsDialog ( QWidget * parent=0, const char * name=0, 
							  WFlags f=0 ) ;

  void setData( SpellcheckerOptionsDialogData* data );
  SpellcheckerOptionsDialogData* data() const;
  void setFocusAlternateLanguage();

private:
  QRadioButton* usedocumentlanguageRB;
  QRadioButton* usealternatelanguageRB;
  QLineEdit* alternatelanguageED;

  QCheckBox* runtogetherlegalCB;
  QCheckBox* inputencodingswitchCB;
  QCheckBox* alternatedictCB;
  QLineEdit* alternatedictED;
  QCheckBox* extraspecialcharsCB;
  QLineEdit* extraspecialcharsED;
};


#endif

/*
 * $Log: SpellcheckerOptionsDialog.h,v $
 * Revision 1.3  1998/03/04 21:49:54  kalle
 * More Qt-ified
 *
 * Revision 1.2  1997/12/26 22:40:00  kalle
 * Kalle:
 * - Changed ScreenOptions dialog to KDE/Qt version
 * - Changed SpellcheckerOptions dialog to KDE/Qt version
 * - Removed old toolbar
 *
 * Revision 1.1.1.1  1997/12/14 21:19:45  kalle
 * Imported current version. Does not compile...
 *
 * Revision 1.1  1997/11/26 16:11:16  kalle
 * Kalle: First dialogs for LyX
 *
 * Revision 1.1.1.1  1997/11/15 18:53:14  kalle
 * SpellcheckerOptionsDialog and testbed
 *
 */
