/*
 * $Id: SendFaxDialog.h,v 1.2 1998/03/15 07:11:19 kalle Exp $
 */

#ifndef _SENDFAXDIALOG_H
#define _SENDFAXDIALOG_H

#include <qdialog.h>
#include <qlined.h>

class QListBox;
class QMultiLineEdit;
class QPushButton;

class LyXView;
class Phonebook;

class SendFaxDialog : public QDialog
{
  Q_OBJECT

public:
  SendFaxDialog ( LyXView* view, QWidget * parent=0, const char * name=0, 
					 WFlags f=0 );

  setFilename( QString _filename ) { filename = _filename; }
  setSendCmd( QString _sendcmd ) { sendcmd = _sendcmd; }
  setPhone( QString _phone ) { faxnoED->setText( _phone ); }
  setName( QString _name ) { destnameED->setText( _name ); }
  setCompany( QString _name ) { companyED->setText( _name ); }

private slots:
  void okClicked();
  void selectfromClicked();
  void addtoClicked();
  void deletefromClicked();
  void saveClicked();

private:
  LyXView* _view;

  QLineEdit* faxnoED;
  QLineEdit* destnameED;
  QLineEdit* companyED;

  QPushButton* savePB;

  QMultiLineEdit* commentML;

  QString filename;
  QString sendcmd;
};


class Phonebook: public QDialog
{
friend class SendFaxDialog;

  Q_OBJECT

public:
  Phonebook ( LyXView* view, QWidget * parent=0, const char * name=0, 
					 WFlags f=0 );

  void loadFile( const char* filename );
  QString getFilename() const { return filename; }

private slots:
  void selected( int );
  void selectClicked();

private:
  LyXView* _view;
  QString filename;
  
  QListBox* listboxLB;
};
  

class Logfile: public QDialog
{
  Q_OBJECT

public:
  Logfile ( LyXView* view, QWidget * parent=0, const char * name=0, 
			WFlags f=0 );

  void loadFile( const char* filename );

private:
  LyXView* _view;
  
  QListBox* listboxLB;
};
  

#endif

/*
 * $Log: SendFaxDialog.h,v $
 * Revision 1.2  1998/03/15 07:11:19  kalle
 * More Qt-ified
 *
 * Revision 1.1  1998/01/13 22:10:32  kalle
 * Fax sending, phonebook and logfile
 * (not really functional yet)
 *
 */
