/*
 * $Id: MathBrowsers.C,v 1.10 1999/04/20 09:35:08 rocher Exp $
 */

#include "MathBrowsers.h"

#include "kiconloader.h"
#include "kapp.h"

#include <qpainter.h>

MathDecoBrowser::MathDecoBrowser() :
  QKBrowseBox( 3, 3, 0, "MathDecoBrowser" )
{
  KIconLoader* loader = kapp->getIconLoader();
  
  insertItem( loader->loadIcon( "decohat.xbm" ), 0, 0 );
  insertItem( loader->loadIcon( "decotilde.xbm" ), 1, 0 );
  insertItem( loader->loadIcon( "decooverbrace.xbm" ), 2, 0 );
  insertItem( loader->loadIcon( "decoleftarrow.xbm" ), 0, 1 );
  insertItem( loader->loadIcon( "decorightarrow.xbm" ), 1, 1 );
  insertItem( loader->loadIcon( "decooverline.xbm" ), 2, 1 );
  insertItem( loader->loadIcon( "decounderbrace.xbm" ), 0, 2 );
  insertItem( loader->loadIcon( "decounderline.xbm" ), 1, 2 );
  
  resize( 137, 80 );	// Rocher 981125, originally  resize( 132, 75 );
}


MathGreekBrowser::MathGreekBrowser() :
  QKBrowseBox( 6, 7, 0, "MathGreekBrowser" )
{
  KIconLoader* loader = kapp->getIconLoader();
  
  insertItem( loader->loadIcon( "greekGamma.xbm" ), 0, 0 );
  insertItem( loader->loadIcon( "greekDelta.xbm" ), 1, 0 );
  insertItem( loader->loadIcon( "greekTheta.xbm" ), 2, 0 );
  insertItem( loader->loadIcon( "greekLambda.xbm" ), 3, 0 );
  insertItem( loader->loadIcon( "greekXi.xbm" ), 4, 0 );
  insertItem( loader->loadIcon( "greekPi.xbm" ), 5, 0 );
  insertItem( loader->loadIcon( "greekSigma.xbm" ), 0, 1 );
  insertItem( loader->loadIcon( "greekUpsilon.xbm" ), 1, 1 );
  insertItem( loader->loadIcon( "greekPhi.xbm" ), 2, 1 );
  insertItem( loader->loadIcon( "greekPsi.xbm" ), 3, 1 );
  insertItem( loader->loadIcon( "greekOmega.xbm" ), 4, 1 );
  insertItem( QPixmap(), 5, 1 );
  insertItem( loader->loadIcon( "greekalpha.xbm" ), 0, 2 );
  insertItem( loader->loadIcon( "greekbeta.xbm" ), 1, 2 );
  insertItem( loader->loadIcon( "greekgamma.xbm" ), 2, 2 );
  insertItem( loader->loadIcon( "greekdelta.xbm" ), 3, 2 );
  insertItem( loader->loadIcon( "greekepsilon.xbm" ), 4, 2 );
  insertItem( loader->loadIcon( "greekvarepsilon.xbm" ), 5, 2 );
  insertItem( loader->loadIcon( "greekzeta.xbm" ), 0, 3 );
  insertItem( loader->loadIcon( "greeketa.xbm" ), 1, 3 );
  insertItem( loader->loadIcon( "greektheta.xbm" ), 2, 3 );
  insertItem( loader->loadIcon( "greekvartheta.xbm" ), 3, 3 );
  insertItem( loader->loadIcon( "greekiota.xbm" ), 4, 3 );
  insertItem( loader->loadIcon( "greekkappa.xbm" ), 5, 3 );
  insertItem( loader->loadIcon( "greeklambda.xbm" ), 0, 4 );
  insertItem( loader->loadIcon( "greekmu.xbm" ), 1, 4 );
  insertItem( loader->loadIcon( "greeknu.xbm" ), 2, 4 );
  insertItem( loader->loadIcon( "greekxi.xbm" ), 3, 4 );
  insertItem( loader->loadIcon( "greekpi.xbm" ), 4, 4 );
  insertItem( loader->loadIcon( "greekvarpi.xbm" ), 5, 4 );
  insertItem( loader->loadIcon( "greekrho.xbm" ), 0, 5 );
  insertItem( loader->loadIcon( "greeksigma.xbm" ), 1, 5 );
  insertItem( loader->loadIcon( "greekvarsigma.xbm" ), 2, 5 );
  insertItem( loader->loadIcon( "greektau.xbm" ), 3, 5 );
  insertItem( loader->loadIcon( "greekupsilon.xbm" ), 4, 5 );
  insertItem( loader->loadIcon( "greekphi.xbm" ), 5, 5 );
  insertItem( loader->loadIcon( "greekvarphi.xbm" ), 0, 6 );
  insertItem( loader->loadIcon( "greekchi.xbm" ), 1, 6 );
  insertItem( loader->loadIcon( "greekpsi.xbm" ), 2, 6 );
  insertItem( loader->loadIcon( "greekomega.xbm" ), 3, 6 );
  insertItem( QPixmap(), 4, 6 );
  insertItem( QPixmap(), 5, 6 );
			  
  resize( 153, 178 );	// Rocher 981125, originally  resize( 150, 175 );
}


MathBinRelBrowser::MathBinRelBrowser() :
  QKBrowseBox( 7, 5, 0, "MathBinRelBrowser" )
{
  KIconLoader* loader = kapp->getIconLoader();

  insertItem( loader->loadIcon( "brelleq.xbm" ), 0, 0 );
  insertItem( loader->loadIcon( "brelgeq.xbm" ), 1, 0 );
  insertItem( loader->loadIcon( "brelequiv.xbm" ), 2, 0 );
  insertItem( loader->loadIcon( "brelmodels.xbm" ), 3, 0 );
  insertItem( loader->loadIcon( "brelprec.xbm" ), 4, 0 );
  insertItem( loader->loadIcon( "brelsucc.xbm" ), 5, 0 );
  insertItem( loader->loadIcon( "brelsim.xbm" ), 6, 0 );
  insertItem( loader->loadIcon( "brelperp.xbm" ), 0, 1 );
  insertItem( loader->loadIcon( "brelpreceq.xbm" ), 1, 1 );
  insertItem( loader->loadIcon( "brelsucceq.xbm" ), 2, 1 );
  insertItem( loader->loadIcon( "brelsimeq.xbm" ), 3, 1 );
  insertItem( loader->loadIcon( "brelmid.xbm" ), 4, 1 );
  insertItem( loader->loadIcon( "brelll.xbm" ), 5, 1 );
  insertItem( loader->loadIcon( "brelgg.xbm" ), 6, 1 );
  insertItem( loader->loadIcon( "brelasymp.xbm" ), 0, 2 );
  insertItem( loader->loadIcon( "brelparallel.xbm" ), 1, 2 );
  insertItem( loader->loadIcon( "brelsubset.xbm" ), 2, 2 );
  insertItem( loader->loadIcon( "brelsupset.xbm" ), 3, 2 );
  insertItem( loader->loadIcon( "brelapprox.xbm" ), 4, 2 );
  insertItem( loader->loadIcon( "brelsmile.xbm" ), 5, 2 );
  insertItem( loader->loadIcon( "brelsubseteq.xbm" ), 6, 2 );
  insertItem( loader->loadIcon( "brelsupseteq.xbm" ), 0, 3 );
  insertItem( loader->loadIcon( "brelcong.xbm" ), 1, 3 );
  insertItem( loader->loadIcon( "brelrown.xbm" ), 2, 3 );
  insertItem( loader->loadIcon( "brelsqsubseteq.xbm" ), 3, 3 );
  insertItem( loader->loadIcon( "brelsqsupseteq.xbm" ), 4, 3 );
  insertItem( loader->loadIcon( "breldoteq.xbm" ), 5, 3 );
  insertItem( loader->loadIcon( "brelneq.xbm" ), 6, 3 );
  insertItem( loader->loadIcon( "brelin.xbm" ), 0, 4 );
  insertItem( loader->loadIcon( "brelni.xbm" ), 1, 4 );
  insertItem( loader->loadIcon( "brelpropto.xbm" ), 2, 4 );
  insertItem( loader->loadIcon( "brelnotin.xbm" ), 3, 4 );
  insertItem( loader->loadIcon( "brelvdash.xbm" ), 4, 4 );
  insertItem( loader->loadIcon( "breldashv.xbm" ), 5, 4 );
  insertItem( loader->loadIcon( "brelbowtie.xbm" ), 6, 4 );
    
  resize( 178, 128 );	// Rocher 981125, originally  resize( 175, 125 );
}


MathBinOpBrowser::MathBinOpBrowser() :
  QKBrowseBox( 7, 5, 0, "MathBinOpBrowser" )
{
  KIconLoader* loader = kapp->getIconLoader();
  
  insertItem( loader->loadIcon( "boppm.xbm" ), 0, 0 );
  insertItem( loader->loadIcon( "bopmp.xbm" ), 1, 0 );
  insertItem( loader->loadIcon( "bopsetminus.xbm" ), 2, 0 );
  insertItem( loader->loadIcon( "bopcdot.xbm" ), 3, 0 );
  insertItem( loader->loadIcon( "boptimes.xbm" ), 4, 0 );
  insertItem( loader->loadIcon( "bopstar.xbm" ), 5, 0 );
  insertItem( loader->loadIcon( "bopdiamond.xbm" ), 6, 0 );
  insertItem( loader->loadIcon( "bopcirc.xbm" ), 0, 1 );
  insertItem( loader->loadIcon( "bopbullet.xbm" ), 1, 1 );
  insertItem( loader->loadIcon( "bopdiv.xbm" ), 2, 1 );
  insertItem( loader->loadIcon( "bopcap.xbm" ), 3, 1 );
  insertItem( loader->loadIcon( "bopcup.xbm" ), 4, 1 );
  insertItem( loader->loadIcon( "bopuplus.xbm" ), 5, 1 );
  insertItem( loader->loadIcon( "bopsqcap.xbm" ), 6, 1 );
  insertItem( loader->loadIcon( "bopsqcup.xbm" ), 0, 2 );
  insertItem( loader->loadIcon( "boptriangleleft.xbm" ), 1, 2 );
  insertItem( loader->loadIcon( "boptriangleright.xbm" ), 2, 2 );
  insertItem( loader->loadIcon( "bopwr.xbm" ), 3, 2 );
  insertItem( loader->loadIcon( "bopbigcirc.xbm" ), 4, 2 );
  insertItem( loader->loadIcon( "bopbigtriangleup.xbm" ), 5, 2 );
  insertItem( loader->loadIcon( "bopbigtriangledown.xbm" ), 6, 2 );
  insertItem( loader->loadIcon( "bopvee.xbm" ), 0, 3 );
  insertItem( loader->loadIcon( "bopwedge.xbm" ), 1, 3 );
  insertItem( loader->loadIcon( "bopoplus.xbm" ), 2, 3 );
  insertItem( loader->loadIcon( "bopominus.xbm" ), 3, 3 );
  insertItem( loader->loadIcon( "bopotimes.xbm" ), 4, 3 );
  insertItem( loader->loadIcon( "boposlash.xbm" ), 5, 3 );
  insertItem( loader->loadIcon( "bopodot.xbm" ), 6, 3 );
  insertItem( loader->loadIcon( "bopdagger.xbm" ), 0, 4 );
  insertItem( loader->loadIcon( "bopddagger.xbm" ), 1, 4 );
  insertItem( loader->loadIcon( "bopamalg.xbm" ), 2, 4 );
  insertItem( QPixmap(), 3, 4 );
  insertItem( QPixmap(), 4, 4 );
  insertItem( QPixmap(), 5, 4 );
  insertItem( QPixmap(), 6, 4 );
  
  resize( 178, 128 );	// Rocher 981125, originally  resize( 175, 125 );
}


MathArrowBrowser::MathArrowBrowser() :
  QKBrowseBox( 4, 5, 0, "MathArrowBrowser" )
{
  KIconLoader* loader = kapp->getIconLoader();
  
  insertItem( loader->loadIcon( "arrowsleftarrow.xbm" ), 0, 0 );
  insertItem( loader->loadIcon( "arrowsrightarrow.xbm" ), 1, 0 );
  insertItem( loader->loadIcon( "arrowsuparrow.xbm" ), 2, 0 );
  insertItem( loader->loadIcon( "arrowsdownarrow.xbm" ), 3, 0 );
  insertItem( loader->loadIcon( "arrowsLeftarrow.xbm" ), 0, 1 );
  insertItem( loader->loadIcon( "arrowsRightarrow.xbm" ), 1, 1 );
  insertItem( loader->loadIcon( "arrowsUparrow.xbm" ), 2, 1 );
  insertItem( loader->loadIcon( "arrowsDownarrow.xbm" ), 3, 1 );
  insertItem( loader->loadIcon( "arrowsupdownarrow.xbm" ), 0, 2 );
  insertItem( loader->loadIcon( "arrowsleftrightarrow.xbm" ), 1, 2 );
  insertItem( loader->loadIcon( "arrowsUpdownarrow.xbm" ), 2, 2 );
  insertItem( loader->loadIcon( "arrowsLeftrightarrow.xbm" ), 3, 2 );
  insertItem( loader->loadIcon( "arrowsleftharpoonup.xbm" ), 0, 3 );
  insertItem( loader->loadIcon( "arrowsrightharpoonup.xbm" ), 1, 3 );
  insertItem( loader->loadIcon( "arrowsleftharpoondown.xbm" ), 2, 3 );
  insertItem( loader->loadIcon( "arrowsrightharpoondown.xbm" ), 3, 3 );
  insertItem( loader->loadIcon( "arrowshookleftarrow.xbm" ), 0, 4 );
  insertItem( loader->loadIcon( "arrowshookrightarrow.xbm" ), 1, 4 );
  insertItem( loader->loadIcon( "arrowsrightleftharpoons.xbm" ), 2, 4 );
  insertItem( loader->loadIcon( "arrowsmapsto.xbm" ), 3, 4 );
  
  resize( 103, 132 );	// Rocher 981125, originally  resize( 100, 125 );
}


MathVarSizeBrowser::MathVarSizeBrowser() :
  QKBrowseBox( 5, 3, 0, "MathVarSizeBrowser" )
{
  KIconLoader* loader = kapp->getIconLoader();
  
  insertItem( loader->loadIcon( "varszsum.xbm" ), 0, 0 );
  insertItem( loader->loadIcon( "varszprod.xbm" ), 1, 0 );
  insertItem( loader->loadIcon( "varszcoprod.xbm" ), 2, 0 );
  insertItem( loader->loadIcon( "varszint.xbm" ), 3, 0 );
  insertItem( loader->loadIcon( "varszoint.xbm" ), 4, 0 );
  insertItem( loader->loadIcon( "varszbigcap.xbm" ), 0, 1 );
  insertItem( loader->loadIcon( "varszbigcup.xbm" ), 1, 1 );
  insertItem( loader->loadIcon( "varszbigwedge.xbm" ), 2, 1 );
  insertItem( loader->loadIcon( "varszbigvee.xbm" ), 3, 1 );
  insertItem( loader->loadIcon( "varszbigsqcup.xbm" ), 4, 1 );
  insertItem( loader->loadIcon( "varszbigotimes.xbm" ), 0, 2 );
  insertItem( loader->loadIcon( "varszbigodot.xbm" ), 1, 2 );
  insertItem( loader->loadIcon( "varszbigoplus.xbm" ), 2, 2 );
  insertItem( loader->loadIcon( "varszbiguplus.xbm" ), 3, 2 );
  insertItem( QPixmap(), 4, 2 );
  
  resize( 128, 80 );	// Rocher 981125, originally  resize( 125, 75 );
}


MathMiscBrowser::MathMiscBrowser() :
  QKBrowseBox( 6, 5, 0, "MathMiscBrowser" )
{
  KIconLoader* loader = kapp->getIconLoader();
  
  insertItem( loader->loadIcon( "miscnabla.xbm" ), 0, 0 );
  insertItem( loader->loadIcon( "miscpartial.xbm" ), 1, 0 );
  insertItem( loader->loadIcon( "miscinfty.xbm" ), 2, 0 );
  insertItem( loader->loadIcon( "miscprime.xbm" ), 3, 0 );
  insertItem( loader->loadIcon( "miscell.xbm" ), 4, 0 );
  insertItem( loader->loadIcon( "miscemptyset.xbm" ), 5, 0 );
  insertItem( loader->loadIcon( "miscexists.xbm" ), 0, 1 );
  insertItem( loader->loadIcon( "miscforall.xbm" ), 1, 1 );
  insertItem( loader->loadIcon( "miscimath.xbm" ), 2, 1 );
  insertItem( loader->loadIcon( "miscjmath.xbm" ), 3, 1 );
  insertItem( loader->loadIcon( "miscRe.xbm" ), 4, 1 );
  insertItem( loader->loadIcon( "miscIm.xbm" ), 5, 1 );
  insertItem( loader->loadIcon( "miscaleph.xbm" ), 0, 2 );
  insertItem( loader->loadIcon( "miscwp.xbm" ), 1, 2 );
  insertItem( loader->loadIcon( "mischbar.xbm" ), 2, 2 );
  insertItem( loader->loadIcon( "miscangle.xbm" ), 3, 2 );
  insertItem( loader->loadIcon( "misctop.xbm" ), 4, 2 );
  insertItem( loader->loadIcon( "miscbot.xbm" ), 5, 2 );
  insertItem( loader->loadIcon( "miscverbar.xbm" ), 0, 3 );
  insertItem( loader->loadIcon( "miscneg.xbm" ), 1, 3 );
  insertItem( loader->loadIcon( "miscflat.xbm" ), 2, 3 );
  insertItem( loader->loadIcon( "miscnatural.xbm" ), 3, 3 );
  insertItem( loader->loadIcon( "miscsharp.xbm" ), 4, 3 );
  insertItem( loader->loadIcon( "miscsurd.xbm" ), 5, 3 );
  insertItem( loader->loadIcon( "misctriangle.xbm" ), 0, 4 );
  insertItem( loader->loadIcon( "miscclubsuit.xbm" ), 1, 4 );
  insertItem( loader->loadIcon( "miscspadesuit.xbm" ), 2, 4 );
  insertItem( loader->loadIcon( "mischeartsuit.xbm" ), 3, 4 );
  insertItem( loader->loadIcon( "miscdiamondsuit.xbm" ), 4, 4 );
  insertItem( QPixmap(), 5, 4 );
  
  resize( 153, 128 );	// Rocher 981125, originally  resize( 150, 125 );
}



MathFunctionBrowser::MathFunctionBrowser() :
    QKBrowseBox( 4, 8, 0, "MathFunctionBrowser" )
{
    // if we want to provide table-sorting by cols we need to change all of them
    // and adopt QKBrowseBox correspondingly ( 990118, Jochen) !
    insertItem( " arccos", 0, 0 );
    insertItem( " arcsin", 1, 0 );
    insertItem( " arctan", 2, 0 );
    insertItem( " arg", 3, 0 );
    insertItem( " bmod", 0, 1 );
    insertItem( " cos", 1, 1 );
    insertItem( " cosh", 2, 1 );
    insertItem( " cot", 3, 1 );
    insertItem( " coth", 0, 2 );
    insertItem( " csc", 1, 2 );
    insertItem( " deg", 2, 2 );
    insertItem( " det", 3, 2 );
    insertItem( " dim", 0, 3 );
    insertItem( " exp", 1, 3 );
    insertItem( " gcd", 2, 3 );
    insertItem( " hom", 3, 3 );
    insertItem( " inf", 0, 4 );
    insertItem( " ker", 1, 4 );
    insertItem( " lg", 2, 4 );
    insertItem( " lim", 3, 4 );
    insertItem( " liminf", 0, 5 );
    insertItem( " limsup", 1, 5 );
    insertItem( " ln", 2, 5 );
    insertItem( " log", 3, 5 );
    insertItem( " max", 0, 6 );
    insertItem( " min", 1, 6 );
    insertItem( " sec", 2, 6 );
    insertItem( " sin", 3, 6 );
    insertItem( " sinh", 0, 7 );
    insertItem( " sup", 1, 7 );
    insertItem( " tan", 2, 7 );
    insertItem( " tanh", 3, 7 );
  
    resize( 230, 138 );
}
