/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
*        
*           Copyright (C) 1995 1996 Matthias Ettrich
*           and the LyX Team.
*
*======================================================*/

#ifndef _LyXView_H_
#define _LyXView_H_

#include "buffer.h"
#include "lyxfr1.h"

#include <kapp.h>
#include <knewpanner.h>
#include <ktmainwindow.h>

#include <qlined.h>

class LyXFunc;
class KToolBar;
class MiniBuffer;
class Intl;

class BufferView;
class KTopLevelWidget;
class KLyXMenuReceiver;
class KLyXToolBarReceiver;  // Rocher 981201
class QLineEdit;
class K_Frame;
class KNewPanner;
class FontLoader;
class ParagraphDialog;
class ParagraphDialogReceiver;
class InsertFigureDialog;
class InsertTableDialog;
class DocumentLayoutDialog;
class DocumentLayoutDialogReceiver;
class CharacterStyleDialog;
class ScreenOptionsTabDialog;
class ScreenFontsDialog;
class SpellCheckDialog;
class SpellcheckerOptionsDialog;
class MathDecoBrowser;
class MathFunctionBrowser;
class MathGreekBrowser;
class MathBinRelBrowser;
class MathBinOpBrowser;
class MathArrowBrowser;
class MathVarSizeBrowser;
class MathMiscBrowser;
class MathSpacingDialog;
class MathMatrixDialog;
class MathDelimiterDialog;
class SendFaxDialog;
class Phonebook;
class Logfile;
class ExportCustomDialog;
class TableOfContentsDialog;
class TableOfContentsDialogReceiver;
class FindReplaceDialog;
class ViewLogfileDialog;
class BulletShapeDialog;
class InsertLabelDialog;
class InsertCitationReferenceDialog;
class InsertCrossReferenceDialog;
class InsertIndexEntryDialog;
class LaTeXOptionsDialog;
class LaTeXPreambleDialog;
class QuotesDialog;
class PaperFormatDialog;
class EditFigureDialog;
class InsertBibitemDialog;
class InsertIncludeDialog;
class CreditsDialog;
class InsertInfoDialog;
class InsertErrorDialog;
class VCLogDialog;
class QPrinter;

struct KLyXDialogs
{
  KLyXDialogs()
	{
	  paragraph = 0;
	  paragraphreceiver = 0;
	  insertfigure = 0;
	  inserttable = 0;
	  document = 0;
	  documentreceiver = 0;
	  character = 0;
	  screenoptions = 0;
	  spellchecker = 0;
	  spelloptions = 0;
	  sendfax = 0;
	  phonebook = 0;
	  logfile = 0;
	  exportcustom = 0;
	  toc = 0;
	  findreplace = 0;
	  viewlogfile = 0;
	  bulletshape = 0;
	  insertlabel = 0;
	  insertxref = 0;
	  insertcitationref = 0;
	  insertindex = 0;
	  latexoptions = 0;
	  latexpreamble = 0;
	  quotes = 0;
	  paper = 0;
	  editfigure = 0;
	  bibitem = 0;
	  insertinclude = 0;
	  credits = 0;
	  insertinfo = 0;
	  inserterror = 0;
	  vclog = 0;

	  mathdecobrowser = 0;
	  mathfuncbrowser = 0;
	  mathgreekbrowser = 0;
	  mathbinrelbrowser = 0;
	  mathbinopbrowser = 0;
	  matharrowbrowser = 0;
	  mathvarsizebrowser = 0;
	  mathmiscbrowser = 0;
	  mathspacing = 0;
	  mathmatrix = 0;
	  mathdelimiter = 0;
	}

  ParagraphDialog* paragraph;
  ParagraphDialogReceiver* paragraphreceiver;
  InsertFigureDialog* insertfigure;
  InsertTableDialog* inserttable;
  DocumentLayoutDialog* document;
  DocumentLayoutDialogReceiver* documentreceiver;
  CharacterStyleDialog* character;
  ScreenOptionsTabDialog* screenoptions;
  SpellCheckDialog* spellchecker;
  SpellcheckerOptionsDialog* spelloptions;
  SendFaxDialog* sendfax;
  Phonebook* phonebook;
  Logfile* logfile;
  ExportCustomDialog* exportcustom;
  TableOfContentsDialog* toc;
  FindReplaceDialog* findreplace;
  ViewLogfileDialog* viewlogfile;
  BulletShapeDialog* bulletshape;
  InsertLabelDialog* insertlabel;
  InsertCrossReferenceDialog* insertxref;
  InsertCitationReferenceDialog* insertcitationref;
  InsertIndexEntryDialog* insertindex;
  LaTeXOptionsDialog* latexoptions;
  LaTeXPreambleDialog* latexpreamble;
  QuotesDialog* quotes;
  PaperFormatDialog* paper;
  EditFigureDialog* editfigure;
  InsertBibitemDialog* bibitem;
  InsertIncludeDialog* insertinclude;
  CreditsDialog* credits;
  InsertInfoDialog* insertinfo;
  InsertErrorDialog* inserterror;
  VCLogDialog* vclog;

  MathDecoBrowser* mathdecobrowser;
  MathFunctionBrowser* mathfuncbrowser;
  MathGreekBrowser* mathgreekbrowser;
  MathBinRelBrowser* mathbinrelbrowser;
  MathBinOpBrowser* mathbinopbrowser;
  MathArrowBrowser* matharrowbrowser;
  MathVarSizeBrowser* mathvarsizebrowser;
  MathMiscBrowser* mathmiscbrowser;
  MathSpacingDialog* mathspacing;
  MathMatrixDialog* mathmatrix;
  MathDelimiterDialog* mathdelimiter;
};


/**
  This class is the form containing the view of the buffer. The actual buffer
  view is supposed (at least IMHO) to be another class, that shows its output
  in one or more LyXView's.
 */
class LyXView : public QObject {
  Q_OBJECT 
public:
	/// constructor
	LyXView(int w, int h);

	/// destructor
	~LyXView();

	/// Where to place the form.
	void setPosition(int, int);

	/// Show the main form.
	void show(int, int, char const* t= "KLyX");

	/// init (should probably be removed later) (Lgb)
	void init();

	/// Redraw the main form.
	void redraw();

	/// returns the buffer currently shown in the main form.
	Buffer *currentBuffer(){ return bufferview->currentBuffer();}

	///
	BufferView *currentView();

	void setCurrentView( BufferView* _view ) { 
	    if( bufferview != _view ) {
		bufferview = _view; 
		updateWindowTitle();
	    }
	}

	/// return a pointer to the toolbar
	KToolBar *getToolbar() { return toolbar; }
        KToolBar *getMathToolbar() { return mathtoolbar; }
        KToolBar *getTableToolbar() { return tabletoolbar; }
        KToolBar *getCharToolbar() { return chartoolbar; }
  

	/// return a pointer to the lyxfunc
	LyXFunc *getLyXFunc() { return lyxfunc; }

	/// return a pointer to the minibuffer
	MiniBuffer *getMiniBuffer() { return minibuffer; }

	///
	Intl *getIntl() { return intl; }

	///
	void updateToolbars();

	/// Updates the title of the window
	void updateWindowTitle();

	/// Reset autosave timer
// 	void resetAutosaveTimer();


  /// KLyX
  KTMainWindow* _k_tlw;
  QLineEdit* k_mini;
  K_Frame* k_frame; // private
  KNewPanner *k_panner; // private
  BufferView* bufferview_one; // private
  BufferView* bufferview_two; // private
  LyXCursor bufferview_one_cursor;	// Rocher 981123
  LyXCursor bufferview_two_cursor;	// Rocher 981123
  FontLoader* getFontloader(){return fontloader;}
  LyXFindReplace1 _FR;
  void splitView(KNewPanner::Orientation style=KNewPanner::Horizontal); // Rocher 981130
  void unsplitView();
  void unsplitViewOther();	// Rocher 981123
  void changeView();		// Rocher 981123
  bool isSplitted();

  QWidget* toplevelWidget() { return _k_tlw; }
  QPrinter * klyxPrinter();
  KLyXDialogs* dialogs() { return &_klyxdialogs; }
  KCombo* layoutCombo() { return _layoutcombo; }
  KLyXMenuReceiver* getMenuReceiver() { return _menureceiver; }
  KLyXToolBarReceiver* getToolBarReceiver() { return _toolbarreceiver; } // Rocher 981201
  LyXFindReplace1* getFR() { return &_FR; }

private slots:
 void dropActionSlot( KDNDDropZone* );

private:
  KLyXDialogs _klyxdialogs;
  QPrinter *_klyxprinter;
  KCombo* _layoutcombo;
  KLyXMenuReceiver* _menureceiver;
  KLyXToolBarReceiver* _toolbarreceiver; // Rocher 981201
  KDNDDropZone* dropzone;

	/// 
        FontLoader* fontloader;
	/// 
	LyXFunc *lyxfunc;
	/// 
	KToolBar *toolbar;
        KToolBar *mathtoolbar;
        KToolBar *tabletoolbar;
        KToolBar *chartoolbar;

	/// 
	MiniBuffer *minibuffer;

	///
	Intl *intl;

	/** This is supposed to be a pointer or a list of pointers to the
	   BufferViews currently being shown in the LyXView. So far
	   this is not used, but that should change pretty soon. (Lgb) */
  /* in klyx this is supposed to contain the CURRENT bufferview. Matthias. */ 
	BufferView *bufferview;
	///
	void invalidateLayoutChoice();
	///
	void UpdateDocumentClassChoice();
 	///
	/** The last textclass layout list in the layout choice selector
	  This should probably be moved to the toolbar, but for now it's
	here. (Asger) */
	int last_textclass;
};


#endif


// Local Variables:
// mode: C++
// c-file-style: "Stroustrup"
// End:
