/*
 * $Id: LaTeXPreambleDialog.C,v 1.6 1999/01/05 11:16:39 kulow Exp $
 */

#include "LaTeXPreambleDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qmlined.h>
#include <qpushbt.h>
#include <qlayout.h>

#include "minibuffer.h"
#include "LyXView.h"
#include "BufferView.h"


LaTeXPreambleDialog::LaTeXPreambleDialog( LyXView* view, QWidget * parent=0, 
										  const char * name=0, 
										  WFlags f=0 ) :
  QDialog( parent, name, true, f ),
  _view( view )
{
  editML = new QMultiLineEdit( this );

  okPB = new QPushButton( i18n( "OK" ), this );
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( okClicked() ) );

  QPushButton* cancelPB = new QPushButton( i18n( "Cancel" ), 
										   this );
  connect( cancelPB, SIGNAL( clicked() ), SLOT( cancelClicked() ) );

  setCaption( i18n( "LaTeX Preamble" ) );

  okPB->setMinimumSize(okPB->sizeHint());
  cancelPB->setMinimumSize(cancelPB->sizeHint());
  if (okPB->minimumSize().width() <75)
      okPB->setFixedWidth(75);
  if (cancelPB->minimumSize().width() <75)
      cancelPB->setFixedWidth(75);
  
  QVBoxLayout *v=new QVBoxLayout(this,5,5);
  QHBoxLayout *h=new QHBoxLayout();
  v->addWidget(editML,1);
  v->addLayout(h,0);
  h->addWidget(okPB,0);
  h->addStretch(10);
  h->addWidget(cancelPB,0);
  v->activate();

  resize(400,400);
  
}


void LaTeXPreambleDialog::okClicked()
{
  if (!_view->currentView()->available())
	return;
	
  _view->currentBuffer()->params.preamble = editML->text();
  _view->currentBuffer()->markDirty();
  _view->getMiniBuffer()->Set(i18n("LaTeX preamble set"));
  accept();
}


void LaTeXPreambleDialog::cancelClicked()
{
  reject();
}


void LaTeXPreambleDialog::setPreamble( const char* preamble )
{
  editML->setText( preamble );
}


void LaTeXPreambleDialog::activate()
{
  editML->setEnabled( true );
  okPB->setEnabled( true );
}


void LaTeXPreambleDialog::deactivate()
{
  editML->setEnabled( false );
  okPB->setEnabled( false );
}


/*
 * $Log: LaTeXPreambleDialog.C,v $
 * Revision 1.6  1999/01/05 11:16:39  kulow
 * s/klocale->translate/i18n
 * updated po files with the newly i18ned file dialogs
 *
 * Revision 1.5  1998/03/17 15:56:29  ettrich
 * Matthias: fixed half a million of bugs
 *
 * Revision 1.4  1998/03/05 21:25:55  ralsina
 * [Roberto] Removed a pointless comment, and GMified LatexPreambleDialog
 *
 * Revision 1.3  1998/03/04 21:49:29  kalle
 * More Qt-ified
 *
 * Revision 1.2  1998/02/09 07:33:54  kalle
 * Somehow this did not get committed
 *
 * Revision 1.1  1998/02/08 21:30:49  kalle
 * - added LaTeXOptionsDialog and LaTeXPreambleDialog
 * Hooray! We are below 1000 XForms references! (995 left)
 *
 */
