/*
 * $Id: KLyXToolBar.h,v 1.10 1998/11/26 20:07:20 rocher Exp $
 */
#ifndef _KLYXTOOLBAR_H
#define _KLYXTOOLBAR_H

#include <qobject.h>

class LyXView;

#define STANDARDTOOLBAR          0
#define TOOLBAR_FILENEW          0	// Rocher 981124
#define TOOLBAR_FILENEWTMPLT     1	// Rocher 981124
#define TOOLBAR_OPEN             2
#define TOOLBAR_WRITE            3
#define TOOLBAR_PREVIEWCUSTOM    4	// Rocher 981124
#define TOOLBAR_PREVIEWUPDATE    5	// Rocher 981124
#define TOOLBAR_PRINT            6
#define TOOLBAR_CUT              7
#define TOOLBAR_COPY             8
#define TOOLBAR_PASTE            9
#define TOOLBAR_EMPH             10
#define TOOLBAR_NOUN             11
#define TOOLBAR_FREE             12
#define TOOLBAR_FOOTMELT         13
#define TOOLBAR_MARGINMELT       14
#define TOOLBAR_DEPTH            15
#define TOOLBAR_TEX              16
#define TOOLBAR_MATHMODE         17
#define TOOLBAR_FIGURE           18
#define TOOLBAR_TABLE            19
#define TOOLBAR_LAYOUT_COMBO     20

#define MATHTOOLBAR 1
#define MATHTOOLBAR_SQUAREROOT 100
#define MATHTOOLBAR_FRACTION 101
#define MATHTOOLBAR_DELIMITER 102
#define MATHTOOLBAR_DECORATION 103
#define MATHTOOLBAR_SPACING 104
#define MATHTOOLBAR_MATRIX 105
#define MATHTOOLBAR_EQUATION 106
#define MATHTOOLBAR_GREEK 107
#define MATHTOOLBAR_BOPERATOR 108
#define MATHTOOLBAR_BRELATION 109
#define MATHTOOLBAR_ARROW 110
#define MATHTOOLBAR_VARSIZE 111
#define MATHTOOLBAR_MISC 112
#define MATHTOOLBAR_SUM 113
#define MATHTOOLBAR_INTEGRAL 114
#define MATHTOOLBAR_EXPONENT 115
#define MATHTOOLBAR_INDEX 116
#define MATHTOOLBAR_FUNCTION 117

#define TABLETOOLBAR 2
#define TABLETOOLBAR_STYLE_COMBO 99
#define TABLE_STYLE_NORMAL 0
#define TABLE_STYLE_ROTATE 1
#define TABLE_STYLE_LONG 2
#define TABLETOOLBAR_BORDER_LEFT 100
#define TABLETOOLBAR_BORDER_RIGHT 102
#define TABLETOOLBAR_BORDER_TOP 103
#define TABLETOOLBAR_BORDER_BOTTOM 104
#define TABLETOOLBAR_APPEND_COLUMN 105
#define TABLETOOLBAR_APPEND_ROW 106
#define TABLETOOLBAR_DELETE_COLUMN 107
#define TABLETOOLBAR_DELETE_ROW 108
#define TABLETOOLBAR_DELETE_TABLE 109
#define TABLETOOLBAR_MULTICOLUMN 110
#define TABLETOOLBAR_ROTATE_CELL 111
#define TABLETOOLBAR_WIDTH_OF_COLUMN 112
#define TABLETOOLBAR_ALIGN_LEFT 113
#define TABLETOOLBAR_ALIGN_RIGHT 114
#define TABLETOOLBAR_ALIGN_CENTER 115
#define TABLETOOLBAR_LONG_COMBO 116
#define TABLETOOLBAR_LONG_NORMAL 117
#define TABLETOOLBAR_LONG_FIRST_HEAD 118
#define TABLETOOLBAR_LONG_HEAD 119
#define TABLETOOLBAR_LONG_FOOT 120
#define TABLETOOLBAR_LONG_LAST_FOOT 121
#define TABLETOOLBAR_LONG_NEW_PAGE 122
#define TABLETOOLBAR_ROTATE_TABLE 123
#define TABLETOOLBAR_LONG_TABLE 124
#define TABLETOOLBAR_NORMAL_TABLE 125
#define TABLE_LONG_NORMAL 0
#define TABLE_LONG_FIRST_HEAD 1
#define TABLE_LONG_HEAD 2
#define TABLE_LONG_FOOT 3
#define TABLE_LONG_LAST_FOOT 4
#define TABLE_LONG_NEW_PAGE 5

#define CHARTOOLBAR 3
#define CHARTOOLBAR_FAMILY 100
#define CHARTOOLBAR_SERIES 101
#define CHARTOOLBAR_SHAPE 102
#define CHARTOOLBAR_SIZE 103
#define CHARTOOLBAR_MISC 104
#define CHARTOOLBAR_COLOR 105
#define CHARTOOLBAR_APPLY 106


class KLyXToolBarReceiver : public QObject
{
  Q_OBJECT

public:
  KLyXToolBarReceiver( LyXView* view ) { _view = view; }

public slots:
/* normal toolbar */
  void fileNew();	// Rocher 981124
  void fileNewTmplt();	// Rocher 981124
  void open();
  void write();
  void previewCustom();	// Rocher 981124
  void previewUpdate(); // Rocher 981124
  void print();
  void cut();
  void copy();
  void paste();
  void emph();
  void noun();
  void free();
  void footmelt();
  void marginmelt();
  void depth();
  void tex();
  void mathmode();
  void figure();
  void table();
  void layoutComboActivated( int );

  /* math toolbar */
  void squareroot();
  void fraction();
  void sum();
  void integral();
  void exponent();
  void index();
  void delimiter();
  void decoration();
  void function();
  void spacing();
  void matrix();
  void equation();
  void greek();
  void boperators();
  void brelations();
  void arrows();
  void varsize();
  void misc();

  /* table toolbar */ 
  void tableStyleComboActivated(int);
  void tableLongComboActivated(int);
  void tableUpdate(int);

  /* char toolbar */ 
  void charComboIgnore(int);
  void charUpdate();

private:
  LyXView* _view;
};

#endif
