// -*- c++ -*-
/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef KBIBLIOMAINVIEW_H
#define KBIBLIOMAINVIEW_H

#include <qsplitter.h>
#include <qvbox.h>

class QTextView;
class QDomElement;
class QListViewItem;

class KBiblioDoc;
class KBiblioShell;
class BibEntryListView;


class KBiblioMainView : public QSplitter
{
    Q_OBJECT
public:
    KBiblioMainView( KBiblioShell *shell, QWidget *parent, const char *name = 0);
    ~KBiblioMainView();
    
public slots:
    void newDocument();
    void newEntry();
    void copySelected();
    void editSelected();
    void deleteSelected();
    void setSelected( QDomElement entry );
    void displaySelected( QListViewItem* item );
    
private:
    void setup();
    
    KBiblioDoc *mDocument;
    KBiblioShell *mShell;
    
    BibEntryListView *mListView;
    QTextView *mEntryView;
};

#endif

