/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef BIBENTRYFIELDVIEWS_H
#define BIBENTRYFIELDVIEWS_H

#include <qobject.h>
#include <qwidget.h>
#include <kdialogbase.h>

class QDomElement;
class BibLined;
class QMultiLineEdit;
class QPushButton;
class QLabel;

class EntryManipulator;
class KBiblioShell;

class BibEntryFieldView : public QObject
{
  Q_OBJECT
 public:
  BibEntryFieldView ( QDomElement entry, const QString &fieldName, KBiblioShell *shell, QWidget *parent=0, const char *name=0 );

  virtual ~BibEntryFieldView ();

 public slots:
  virtual void storeData();
  virtual void setFocus();

 signals:
  void returnPressed();
  void hasChanged();

 protected:
  EntryManipulator *mManipulator;

  QDomElement mEntry;
  QString mFieldName;
  KBiblioShell *mShell;
};


class StringFieldView : public BibEntryFieldView
{
  Q_OBJECT
 public:
  StringFieldView ( QDomElement entry, const QString &fieldName, KBiblioShell *shell, QGridLayout* gridLayout, int row, QWidget *parent=0, const char *name=0 );

  virtual ~StringFieldView ();

 public slots:
  virtual void storeData();
  virtual void setFocus();

 private:
  BibLined *mLineEdit;
};


class TextDialogMainWidget : public QWidget
{
  Q_OBJECT
 public:
    TextDialogMainWidget( QString *text, const QString &fieldDescr, QWidget *parent, const char *name=0 );
    ~TextDialogMainWidget();

    QString text() const;

 private:
    QMultiLineEdit *meText;
};


class TextDialog : public KDialogBase
{
  Q_OBJECT
 public:
    TextDialog( QString *text, const QString &dialogTitle, const QString &fieldDescr, QWidget *parent, const char *name=0 );
    ~TextDialog();

 protected slots:
    virtual void slotOk();

 private:
    QString *mText;
    TextDialogMainWidget *mTextWidget;
};


class TextFieldView : public BibEntryFieldView
{
  Q_OBJECT
 public:
  TextFieldView ( QDomElement entry, const QString &fieldName, KBiblioShell *shell, QGridLayout* gridLayout, int row, QWidget *parent=0, const char *name=0 );

  virtual ~TextFieldView ();

 public slots:
  void editText();
  void displayData();

 private:
  QLabel *mTextLine;
  QPushButton *mEditPush;
};



#endif
