/***************************************************************************
                          kashlistviewitem.cpp  -  description
                             -------------------
    begin                : Son Nov 21 15:23:42 CET 1999
    copyright            : (C) 1999 by Stephan Kahnt
    email                : stephan.kahnt@ipk.fhg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// standard include
#include <iostream>

// include files for Qt
#include <qtextstream.h>

// include files for KDE

// application specific includes
#include "kashlistviewitem.h"
#include "resource.h"

extern QDate stringToDate( const QString& dateString );

KashListViewItem::KashListViewItem( QListView* parent, long aTransId ) :
  QListViewItem( parent ), id( aTransId ) {
}

long KashListViewItem::transId() {
  return id;
}

QString KashListViewItem::key ( int column, bool ascending ) const {
  QString strRet;
  if ( column == DATE_IDX ) {
    QDate epoch( 1980, 1, 1 );
    QTextOStream textOStr( &strRet );
    textOStr.width( 8 );
    textOStr << epoch.daysTo( date );
  }
  else {
    strRet = QListViewItem::key( column, ascending );
  }
  return strRet;
}

double KashListViewItem::amount() {
  return am;
}

void KashListViewItem::setText( int column, const QString & text ) {
  if ( !text.isEmpty() ) {
    switch( column ) {
    case DATE_IDX:
      date = stringToDate( text );
      break;
      ;;
    case AMOUNT_IDX:
      am = text.toDouble();
      break;
      ;;
    }
  }
  QListViewItem::setText( column, text );
}
