  /*

  knetfilter v 2.0.0

  Copyright (C) 2000 Luigi Genoni
  		     venom@DarkStar.sns.it
  */
  

#include <qlayout.h>
#include <qmultilinedit.h>
#include <qkeycode.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qstring.h>
#include <qstrlist.h>
#include <strings.h>

#include "knat.h"


// connecting created object 
void knetfilter::setupConnect() {

  KApplication::connect(&addp,SIGNAL(processExited(KProcess *)),
			this,SLOT(addDone_tcp()));
  KApplication::connect(&addp2,SIGNAL(processExited(KProcess *)),
			this,SLOT(addDone_udp()));
  KApplication::connect(&addp3,SIGNAL(processExited(KProcess *)),
			this,SLOT(addDone_icmp()));
  KApplication::connect(&delp,SIGNAL(processExited(KProcess *)),
			this,SLOT(delDone_tcp()));
  KApplication::connect(&delp2,SIGNAL(processExited(KProcess *)),
			this,SLOT(delDone_udp()));
  KApplication::connect(&delp3,SIGNAL(processExited(KProcess *)),
			this,SLOT(delDone_icmp()));
  KApplication::connect(&save,SIGNAL(processExited(KProcess *)),
			this,SLOT(saveDone()));
  KApplication::connect(&load,SIGNAL(processExited(KProcess *)),
			this,SLOT(loadDone()));
  KApplication::connect(&stop,SIGNAL(processExited(KProcess *)),
			this,SLOT(stopDone()));

  KApplication::connect(&masqon,SIGNAL(processExited(KProcess *)),
			this,SLOT(masqonDone()));
  KApplication::connect(&masqoff,SIGNAL(processExited(KProcess *)),
			this,SLOT(masqoffDone()));


  KApplication::connect(&natrules,SIGNAL(receivedStdout(KProcess *, char *, int)), 
  			this,SLOT(setnatRules(KProcess *, char*, int))); 
  KApplication::connect(&natrules,SIGNAL(receivedStderr(KProcess *, char *, int)), 
  			this,SLOT(setnatRules(KProcess *, char*, int))); 

  KApplication::connect(&natpolrules,SIGNAL(processExited(KProcess *)),
			this,SLOT(natpolRulesDone()));  
  KApplication::connect(&natpolrules,SIGNAL(receivedStdout(KProcess *, char *, int)), 
			this,SLOT(setnatpolRules(KProcess *, char*, int))); 
  KApplication::connect(&natpolrules,SIGNAL(receivedStderr(KProcess *, char *, int)), 
			this,SLOT(setnatpolRules(KProcess *, char*, int))); 
  KApplication::connect(&stop_nat,SIGNAL(processExited(KProcess *)),
			this,SLOT(stop_natDone()));  
  
  KApplication::connect(&polrules,SIGNAL(processExited(KProcess *)),
			this,SLOT(polRulesDone()));
  KApplication::connect(&polrules,SIGNAL(receivedStdout(KProcess *, char *, int)), 
			this,SLOT(setpolRules(KProcess *, char*, int))); 
  KApplication::connect(&polrules,SIGNAL(receivedStderr(KProcess *, char *, int)), 
			this,SLOT(setpolRules(KProcess *, char*, int))); 


  KApplication::connect(&addmangle,SIGNAL(receivedStdout(KProcess *, char *, int)),
			this,SLOT(setmangleRules(KProcess *, char *, int)));
  KApplication::connect(&addmangle,SIGNAL(receivedStderr(KProcess *, char *, int)),
			this,SLOT(setmangleRules(KProcess *, char *, int)));

  KApplication::connect(&delmangle,SIGNAL(receivedStdout(KProcess *, char *, int)),
			this,SLOT(setmangleRules(KProcess *, char *, int)));
  KApplication::connect(&delmangle,SIGNAL(receivedStderr(KProcess *, char *, int)),
			this,SLOT(setmangleRules(KProcess *, char *, int)));

  KApplication::connect(&manglepolrules,SIGNAL(processExited(KProcess *)),
			this, SLOT(manglepolRulesDone()));
  KApplication::connect(&manglepolrules,SIGNAL(receivedStdout(KProcess *, char *, int)),
			this,SLOT(setmanglepolRules(KProcess *, char *, int)));
  KApplication::connect(&manglepolrules,SIGNAL(receivedStderr(KProcess *, char *, int)),
			this,SLOT(setmanglepolRules(KProcess *, char *, int)));
  KApplication::connect(&stop_mangle,SIGNAL(processExited(KProcess *)),
			this,SLOT(stop_mangleDone()));  
  


  KApplication::connect(&rules,SIGNAL(processExited(KProcess *)),
  			this,SLOT(listRulesDone()));
  KApplication::connect(&rules,SIGNAL(receivedStdout(KProcess *, char *, int)),
  			this,SLOT(listRules(KProcess *, char *, int)));
  KApplication::connect(&rules,SIGNAL(receivedStderr(KProcess *, char *, int)),
  			this,SLOT(listRules(KProcess *, char *, int)));

  KApplication::connect(&tcpdump,SIGNAL(receivedStdout(KProcess *, char *, int)),
  			this,SLOT(listDump(KProcess *, char *, int)));
  KApplication::connect(&tcpdump,SIGNAL(receivedStderr(KProcess *, char *, int)),
 			this,SLOT(listDump(KProcess *, char *, int)));


  KApplication::connect(&fetchIp,SIGNAL(processExited(KProcess *)),
  			this,SLOT(probeInterfaceDone()));
  KApplication::connect(&fetchIp,SIGNAL(receivedStdout(KProcess *,char *, int)),
  			this,SLOT(probeInterface(KProcess *, char *, int)));
  KApplication::connect(&fetchIp,SIGNAL(receivedStderr(KProcess *,char *, int)),
  			this,SLOT(probeInterface(KProcess *, char *, int)));
  KApplication::connect(&fetchNetmask,SIGNAL(processExited(KProcess *)),
  			this,SLOT(probeInterfaceDone()));
  KApplication::connect(&fetchNetmask,SIGNAL(receivedStdout(KProcess *,char *, int)),
  			this,SLOT(probeInterface2(KProcess *, char *, int)));
  KApplication::connect(&fetchNetmask,SIGNAL(receivedStderr(KProcess *,char *, int)),
  			this,SLOT(probeInterface2(KProcess *, char *, int)));

  KApplication::connect(&entries,SIGNAL(receivedStdout(KProcess *,char *, int)),
  			this,SLOT(userEntries(KProcess *,char *, int)));
  KApplication::connect(&entries,SIGNAL(receivedStderr(KProcess *,char *, int)),
  			this,SLOT(userEntries(KProcess *,char *, int)));
  KApplication::connect(&entries,SIGNAL(processExited(KProcess *)),
  			this,SLOT(userEntriesDone()));

};


// quitting
void knetfilter::closeEvent (QCloseEvent *) {

  kapp->quit();

};


// check for masquerade modules
void knetfilter::checkMasquerade() {

  ip_masquerade = fopen("/proc/net/ip_conntrack", "r");

};

