#include <iostream.h>
#include "StringToken.h"
#include "WebParser.h"
#include "webServer.h"
#include "ircDefine.h"
#include "ircApp.h"

WebCmdTab WebParser::cmdTab[]={
    {"GET",              WebParser::cmdGet },
    {"Connection",       WebParser::cmdConnection },
    {"User-Agent",       WebParser::cmdUserAgent  },
    {"Host",             WebParser::cmdHost       },
    {"Accept",           WebParser::cmdAccept     },
    {NULL,        NULL}
};

WebParser::WebParser(QObject* Parent, const char* Name):
  QObject(Parent, Name)
{
  webClient = (WebClient*)Parent;
}

// return 0 -> socket->parseLine
// return 1 -> ok
int WebParser::parseLine(const char* txt)
{
  StringToken token(txt," ");
  QString cmd, rest; 

#ifdef EDEBUG
  cout << txt << endl;
#endif

  cmd  = token.nextToken(" :");
  rest = token.toEnd();
  if (rest.isNull())
     return 1;

  for (int i=0;cmdTab[i].name!=NULL;i++){
    if (!stricmp(cmd, cmdTab[i].name)){
       return (this->*(cmdTab[i].func))(rest);
    }
  }
  return 0;
}

int WebParser::cmdGet(const char* txt)
{
  StringToken tt(txt);
  webClient->methode  = "GET";
  webClient->path     = tt.nextToken();
  webClient->protocol = tt.nextToken();
  return 1;
}

int WebParser::cmdConnection(const char* txt)
{
  StringToken tt(txt);
  webClient->connection = tt.nextToken(" :");
  return 1;
}

int WebParser::cmdUserAgent(const char* txt)
{
  StringToken tt(txt);
  webClient->userAgent = tt.nextToken(" :");
  return 1;
}

int WebParser::cmdHost(const char* txt)
{
  StringToken tt(txt);
  return 1;
}

int WebParser::cmdAccept(const char* txt)
{
  StringToken tt(txt);
  return 1;
}
