#include <iostream.h>
#include "StringToken.h"
#include "socks.moc"
#include "socks.h"

void Socks::init()
{
  mLogin  = "";
  mPasswd = "";
}

Socks::Socks() : ClientSocket()
{
  init();
}

Socks::Socks(const char* host, int port) : ClientSocket(host, port)
{
  init();
}

Socks::~Socks()
{
}

int Socks::sendName()
{
  int n;
  QString s="";
  if (!mLogin.isEmpty())
     s += mLogin;
  if (!mPasswd.isEmpty())
     s += " "+mPasswd;
  n = ::write(sd, s.data(), s.length()+1);
  if (n!=(int)s.length()+1){
     Close();
     return -1;
  }
  return 1;
}

int Socks::sendDst()
{
  char c[sizeof(SOCKS_STRUCT)];
  int  n;

  c[0] = mDst.version;
  c[1] = mDst.cmd;
  bcopy(&mDst.port, c+2, sizeof(mDst.port));
  bcopy(&mDst.host, c+2+sizeof(mDst.port), sizeof(mDst.host));

  n = ::write(sd, c, sizeof(SOCKS_STRUCT));
  if (n!=sizeof(SOCKS_STRUCT)){
     Close();
     return -1;
  }
  return 1;
}

int Socks::getDst()
{
#ifdef EDEBUG
  cout << "Socks::getDst()"<<endl;
#endif
  int     length =sizeof(SOCKS_STRUCT);
  QString s(length);
  int  n = readData(s, length);
  if (n<1)
     return n;
  
  char* c=s.data();
  mDst.version = c[0];
  mDst.cmd     = c[1];
  bcopy(c+2, &mDst.port, sizeof(mDst.port));
  bcopy(c+2+sizeof(mDst.port), &mDst.host, sizeof(mDst.host));

  cout << (int)mDst.version<<":"<<(int)mDst.cmd<<":"<<endl;

  switch ((int)mDst.cmd) {
  case SOCKS_FAIL:
  case SOCKS_NO_IDENTD:
  case SOCKS_BAD_ID:
    emit signError();
    return -1;
    break;
  }
  return 1;
}


void Socks::setSockServer(const char* host, int port)
{
#ifdef EDEBUG
  cout << "Socks::setSockServer():"<<host<<":"<<port<<endl;
#endif
  peerPort=port;
  inAddr.forHost(host);
}

void Socks::setUserName(const char* login, const char* passwd)
{
  if (login)
     mLogin  = login;
  if (passwd)
     mPasswd = passwd;
}

void Socks::setParameter(const char* arg)
{
  StringToken st(arg, " :");
  QString h=st.nextToken();
  QString p=st.nextToken();
  if (!h.isEmpty() && !p.isEmpty())
     setSockServer(h, p.toInt());
  QString l=st.nextToken();
  QString w=st.nextToken();
  setUserName(l, w);
}


int Socks::ROpen(IrcServer* is)
{
  return ROpen(is->Host(), is->Port().toInt());
}

int Socks::ROpen(const char* host, int port)
{
#ifdef EDEBUG
  cout << "Socks::ROpen():"<<host<<":"<<port<<endl;
#endif
  // Connect to socks daemond
  int status=ClientSocket::Open();
  if (status<1)
     return status;
  if (!dstInAddr.forHost(host)){
     Close();
     return -1;
  }

  // Send destination
  mDst.version = SOCKS_VERSION;
  mDst.cmd     = SOCKS_CONNECT;
  mDst.port    = htons(port);
  mDst.host    = dstInAddr.getAddress();
  
  status=sendDst();
  if (status<1)
     return status;

  status=sendName();
  if (status<1)
     return status;

  return 1;
}

InetAddress& Socks::getDstInetAddress()
{
  return dstInAddr;
}

