#include <iostream.h>
#include <qpopmenu.h>
#include <qtstream.h> 
#include <qfile.h> 
#include <qlist.h>
#include "StringToken.h"
#include "ircPopup.h"
#include "ircPopup.moc"
#include "fileReader.h"
#include "ircApp.h"

PopupClue::PopupClue(const char* Name)
{
  pu = new QPopupMenu(NULL, Name);
  connect(pu,
	  SIGNAL(activated (int)),
	  this,
	  SLOT  (slotAction(int)));
  action = new QDict<char>(20, FALSE, TRUE);
  action->setAutoDelete(TRUE);
}

PopupClue::~PopupClue()
{
  delete pu;
  delete action;
}

int PopupClue::add(const char* Name, const char* Value, int Id)
{
  QString nr;
  nr.setNum(Id);
  action->insert(nr, qstrdup(Value));
  return pu->insertItem(Name, Id);
}

int PopupClue::add(const char* Name, QPopupMenu* Pu, int Id)
{
  if (!Pu){
    return -1;
  }
    
  return pu->insertItem(Name, Pu, Id);
}

QPopupMenu* PopupClue::popup()
{
  return pu;
}

void PopupClue::slotAction(int Idx)
{
  QString nr;
  nr.setNum(Idx);
  QString a;
  if (a=action->find(nr))
     emit signAction(a);
}


void IrcPopup::init()
{
  path  = NULL;
  popup = new QDict<PopupClue>(20, FALSE, TRUE);
  popup->setAutoDelete(TRUE);
  list.setAutoDelete(TRUE);
}

IrcPopup::IrcPopup()
{
  init();
}

IrcPopup::IrcPopup(const char* Entry, const char* Path)
{
  init();
  entry = Entry;
  path  = ircapp->readPathEntry(entry, Path);
  load();
}

IrcPopup::~IrcPopup()
{
  delete popup;
}

int IrcPopup::load(const char* File)
{  
  QString tmp=path;
  if (File)
     tmp=File;
  QFile f(tmp);
  if (!f.open(IO_ReadOnly))
      return 0;
  path = tmp;
  QTextStream ts(&f); 
  QString s;
  PopupClue* pc=NULL;
  popup->clear();
  list.clear();
  while (!ts.eof()){
    s = ts.readLine();  
    s = s.stripWhiteSpace();
    if (s.isEmpty())
       continue;
    if (s[0]=='['){
       StringToken t(s);
       QString p=t.nextToken(" []");
       if (stricmp(p, "popup")){
	  pc=NULL;
	  continue;
       }
       if (list.count())
          list.append("");
       QString n=t.nextToken();
       popup->insert(n, pc = new PopupClue(n));
       connect(pc,
	       SIGNAL (signAction(const char*)),
	       this,
	       SLOT   (slotPopup(const char*)));
    }
    else if (!pc)
       continue;
    list.append(s);
  }
  QString item;
  pc = NULL;
  int i=0;
  for (item=list.first();item;item=list.next()){
      StringToken t(item);
      QString p, n;
      if (item[0]=='['){
	 p=t.nextToken(" []");
	 n=t.nextToken();
	 pc = popup->find(n);
      }
      else if (pc){
	 p=t.nextToken(":");
	 n=t.toEnd    (" :");
	 if (!p || !n)
	    continue;
	 if (!stricmp(p,"Popup")){
	    n=n.stripWhiteSpace();
	    PopupClue* c=popup->find(n);
	    if (!c)
	       continue;
	    pc->add(n, c->popup(), i);
	 }
	 else{
	    pc->add(p, n, i);
	 }
	 i++;
      }
  }
  slotUpdateData();
  return 1;
}

int IrcPopup::save(const char* File)
{
  FileReader fr(&list, entry, path);
  if (!fr.save(File))
     return 0;
  path = fr.getPath();
  return 1;
}



QPopupMenu* IrcPopup::find(const char* Name)
{
  PopupClue* pc=popup->find(Name);
  if (!pc)
     return NULL;
  return pc->popup();
}

void IrcPopup::slotPopup(const char* Action)
{
  emit signPopup(Action);
}

void IrcPopup::slotUpdateData()
{
  emit signUpdateData();
}

QString IrcPopup::getPath()
{
  return path;
}

QStrIList* IrcPopup::getList()
{
  return &list;
}

void IrcPopup::clear()
{
  popup->clear();
  list.clear();
}





