#ifndef __IRCHTML_H__
#define __IRCHTML_H__

#include <stdlib.h>
#include <unistd.h> 

#include <qfile.h>
#include <qwidget.h>
#include <html.h>
#include <htmlview.h>
#include <qlayout.h>
#include "htmlContent.h"

class IrcHtml : public QWidget
{
  Q_OBJECT
protected:
  QFrame*      window;
  KHTMLWidget* htmlw;
  QScrollBar*  sbVer;
  QScrollBar*  sbHor;
  int     textFSize;
  int     msgFSize;
  int     actionFSize;
  int     infoFSize;
  int     errorFSize;
  QString textFName;
  QString msgFName;
  QString actionFName;
  QString infoFName;
  QString errorFName;
  int     fontBase;
  QString standardFont;
  QString fixedFont;
  QColor  bgColor;
  QColor  textColor;
  QColor  infoColor;
  QColor  msgColor;
  QColor  actionColor;
  QColor  errorColor;
  
  QFile   log;
  bool    setLog;

  QList<HtmlContent> contentList;
  int currentContent;

  QColor  color;
  QString fontName;
  int     fontSize;

  int     oldVerMaxValue;

  QString bgImage;
  QString bgsColor;
private:
  void Init(const char* Name);
protected:
    void resizeEvent(QResizeEvent *);
signals:
    void popupMenu(const char*, const QPoint&);
public slots:
    void slotWrite      (int Type, const char* Txt, bool Parsen=TRUE);
    void slotURLSelected(const char *_url, int _button );

    void slotNextBuffer(const char*);
    void slotPrevBuffer(const char*);
    void slotBackward  ();
    void slotForward   ();
    void slotSetFlag    (int Type, bool state);
protected slots:
    void slotScrollVert        (int );
    void slotScrollHorz        (int );
    void slotResized           (const QSize & );
    void slotDocumentChanged   ();
    void slotTextSelected      (bool);
    void slotSetColor   (const QColor &col, int Type);
    void slotSetFontSize(int size, int Type);
    void slotSetFontName(const char* text, int Type);
    void slotSetBgImage (const char*);
public:
  QString htmlFilter(const char* Txt);
  QColor  getColor  (int nr);
  IrcHtml(QWidget *parent=NULL, const char *name=NULL);
  ~IrcHtml();
  KHTMLWidget* htmlWidget();
};

#endif

