#ifndef __IRCDIALOG_H__
#define __IRCDIALOG_H__

#include <qbttngrp.h>
#include <qframe.h>
#include <qgrpbox.h>
#include <qlabel.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qdialog.h>
#include <qdatetm.h>
#include <qtimer.h>
#include <qlcdnum.h>
#include <qdict.h>
#include "ircClient.h"


class IrcDialog : public QDialog
{
  Q_OBJECT
protected:
  QString TOEntry;
  QString MaxEntry;
  QString CurEntry;
  QString Caption;
  QString Text;
  QString Command;
  int     curCount;
protected:
  void createDialog();
public:
  IrcDialog(IrcClient* Client, QDict<char>& Property, bool Modal=TRUE, 
	    QWidget *parent=NULL, const char *name=NULL);
  IrcDialog(IrcClient* Client, 
	    const char* Timeout, 
	    const char* MaxEntry,
	    const char* CurEntry,
	    const char* Caption,
	    const char* Text,
	    const char* Command,
	    bool Modal=TRUE, 
	    QWidget *parent=NULL, 
	    const char *name=NULL);
  ~IrcDialog();
protected:
  QTimer*     timer;
  IrcClient*  client;
  QLCDNumber* lcd;
  int         timeout;
  int         interval;
private slots:
  void slotTimeout();
  void slotOk();
  void slotCancel();
  void slotIgnore();
};

#endif


