#ifndef  __IRCCLIENT_H__
#define  __IRCCLIENT_H__

#include <qdir.h>
#include <qfiledlg.h>
#include <qlist.h>
#include <qstrlist.h>
#include <qdict.h>
#include <qsocknot.h>
#include "ircDefine.h"
#include "clientCore.h"
#include "clientConfig.h"
#include "IrcSocket.h"
#include "ircChannel.h"
#include "ircPrivMsg.h"
#include "dccChat.h"
#include "dccFile.h"
#include "ircAlias.h"
#include "MsgParser.h"
#include "CmdParser.h"
#include "ircMode.h"
#include "dccFileDialog.h"
#include "mediaDialog.h"
#include "ircPopup.h"
#include "ircBell.h"
#include "optPrefDialog.h"
#include "clientSetupTab.h"
#ifdef TCL
#include "tclCmd.h"
#endif
#include "onUserListPage.h"
#include "webServer.h"
#include "channelDialog.h"
#include "opActionDialog.h"
#include "whoisDialog.h"
#include "ircDefine.h"

class IrcClient : public ClientCore, public ClientConfig
{
  Q_OBJECT
  friend class MsgParser;
  friend class CmdParser;
public:
  IrcClient();
  ~IrcClient();
protected:
  int startActionTimer;
public:
  MediaDialog*       mediaDlg;
  DCCFileDialog*     dccFileDlg;
  IrcAlias*          alias;
  QDict<IrcChannel>* channel;
  QDict<IrcPrivMsg>* privMsg;
  QDict<DCCChat>*    dccChat;
  QDict<DCCFile>*    dccFile;
  IrcSocket          socket;
  QString            cmdChar;
  MsgParser*         msgParser;
  CmdParser*         cmdParser;
  QSocketNotifier*   sn;
  IrcMode            mode;
  QDict<IrcBell>     bell;
  QDict<IrcPopup>    popup;
  QStrIList          startAction;
  QStrIList          isonList;
  QStrIList          onList;
  QStrIList          ctcpReplyList;
  QDict<IrcCore>     timerList;
  int                state;
#ifdef TCL
  TclCmd*            tclCmd;
#endif
  QDict<IrcUser>*    whoisCache;

  QDict<char>*       mediaPlayer;
  OptPrefDialog*     optPrefDlg;
  FriendList*        friendList;
  BanList*           banList;
  IgnoreList*        ignList;
  WebServer*         webServer;
  IrcSetup*          clientSetup;
  QDict<QWidget>*    dlgList;
private:
  void Init();
protected:
  void doIson();
public slots:
  void slotCommand      (const char* Name, const char* Cmd);
  void slotMsgParse  (int sd);
  void slotInputParse(const char* Txt);
  void slotWriteOnActive(int Type, const char* Msg, bool Parsen=TRUE);

  virtual void slotTimeout();
  void slotLagging      (const char*);
  void slotConnect   (IrcCore*);
  void slotDisconnect(IrcServer*);
  void slotConnected   (IrcServer*);
  void slotDisconnected();

  void slotCtcpReply(IrcCore*);
  void slotIsOn     (IrcCore*);

  void slotSocketText(const char* txt);
public:
  virtual QString cmdSubstitution(const char* Txt);
  IrcSocket&  getSocket();
  void addNick   (const char* n);
  void setCurNick(const char* n);

  void addServer   (const char* s);
  void delServer   (const char* s);
  void setCurServer(const char* s);
  IrcServer* getServer(const char* s);

  int  addChannel(const char* Channel, const char* Key=0L, int flag=MDI_SHOW);
  int  delChannel(const char* Channel, bool emitted=true);
  int  setMode   (const char* txt);

  int  addPrivMsg(const char* user, int flag=MDI_ICONIFY);
  int  delPrivMsg(const char* user, bool emitted=true);

  int  addDCCChat(const char* user, const char* arg=NULL, int flag=MDI_ICONIFY);
  int  delDCCChat(const char* user, bool emitted=true);

  int  addDCCFile(const char* user, const char* arg, int flag=MDI_ICONIFY);
  int  delDCCFile(const char* user, bool emitted=true);

  void initAll();
  QString cmdFilter(const char* Txt, int* Type);
  bool isIgnored(const char* Who, const char* flag);

  int  onStarting(const char* txt);

  IrcUser* getIrcUser(const char* nick, int sw=0); // 0->nur nick!user@host, 1-> auch server
  void Sleep         (ulong second);
  QString  makeBan   (const char*, int flag=-1);
  WhoisDialog* getWhoisDialog(){
     return ((WhoisDialog*)dlgList->find("WhoisDialog"));
  }
signals:
  void signCurNick(const char* nick);
  void signAddNick(const char* nick);
  void signCurServer(IrcServer*  s);
  void signAddServer(IrcServer*  s);
  void signDelServer(const char* s);
  void signWriteOnActive(int Type, const char* Msg, bool Parsen=TRUE);

  void signAddChannel   (const char* Chan, const char* Key, int flag);
  void signDelChannel   (IrcChannel*);
  void signConnect     (IrcServer*);
  void signConnected   (IrcServer*);
  void signDisconnect  (IrcServer*);
  void signDisconnected(IrcServer*);
  void signMode(const char* txt);
  void signStarting();
  void signLagging (const char*);

  void signAddPrivMsg(const char* user, int flag);
  void signDelPrivMsg(IrcPrivMsg*);
  void signAddDCCChat(const char* user, int flag);
  void signDelDCCChat(DCCChat*);
  void signAddDCCFile(const char* ident, int flag);
  void signDelDCCFile(DCCFile*);

  void signAddOutputPage(const char*, int flag, bool detached, const char* pix=0L);
  void signDelOutputPage(const char*);
  void signWritePage    (const char*, int Type, const char* Msg, bool Parsen=TRUE);

public:
  QString addOutputPage(const char* name, int flag=MDI_DETACHED|MDI_SHOW, 
			bool detach=false, const char* pix=0L);
  void delOutputPage(const char* name, bool emitted=true);
  void slotWritePage(const char* name, int Type, const char* Msg, bool Parsen=true);
};

#endif





