#ifndef __IRCAPP_H__
#define __IRCAPP_H__

#include "kapp.h"
#include "remoteNetscape.h"

#define KEIRC_VERSION    "0.3"

#define ircapp IrcApp::ircApplication()

class IrcApp : public KApplication
{
public:
  static QString  home;
  static QString  keircHome;
  static QString  entryGroup;
  static KConfig* config;
  RemoteNetscape  remoteNetscape;
  QString localHost;
public:
  IrcApp(int& argc, char** argv );
  ~IrcApp();
  static IrcApp* ircApplication(){
     return (IrcApp*)KApp;
  }
  QString readPathEntry (const char* Entry, const char* PathDefault);
  QString readEntry     (const char* Entry, const char* Default);
  int     readNumEntry  (const char* Entry, int Default);
  void    writeEntry(const char* Entry, const char* Value);
  void    writeEntry(const char* Entry, int Value);
  void    writeEntry(const char* Entry, const QColor& Value);
  int     browseInit();
  void    browse(const char*);
  void    browse(const char* cmd, const char* arg);
};

#endif
