#include <iostream.h>
#include "htmlContent.h"
#include "htmlContent.moc"

HtmlContent::HtmlContent(KHTMLWidget* htmlw, int size)
{
  prev = 0L;
  bgImage="";
  bgColor="";
  this->htmlw = htmlw;
  this->size  = size;
  curSize     = -1;
  buffer.setAutoDelete(true);
}

void HtmlContent::write(const char* txt)
{
#ifdef EDEBUG
  cout << "HtmlContent::write:"<<txt<<endl;
#endif
  if (curSize<0){
     start();
  }
  if (curSize < size){
     curSize++;
     buffer.append(txt);
     htmlw->write(txt);
  }
  else{
     emit signNextBuffer(txt);
  }
}

void HtmlContent::writeBuffer(const char* txt)
{
#ifdef EDEBUG
  cout << "HtmlContent::writeBuffer:"<<txt<<endl;
#endif
  curSize++;
  buffer.append(txt);
}

void HtmlContent::start(const char* bgImg, const char* bgClr)
{
#ifdef EDEBUG
  cout << "HtmlContent::start:"<<endl;
#endif
  if (bgClr && strlen(bgClr)>0)
     bgColor=bgClr;
  if (bgImg && strlen(bgImg)>0)
     bgImage=bgImg;
  buffer.clear();
  curSize = 0;
  htmlw->begin();
  htmlw->parse();
  if (!bgImage.isEmpty())
    htmlw->write("<HTML><BODY background=file:"+bgImage+">");
  else if (!bgColor.isEmpty())
    htmlw->write("<HTML><BODY bgcolor="+bgColor+">");
  else
    htmlw->write("<HTML><BODY>");
  if (!prev->list().isEmpty()){
     QString s;
     QStrList buffer=prev->list();
     for (s=buffer.at(size-10);s;s=buffer.next())
         htmlw->write(s);
  }
}

void HtmlContent::showHtml(bool showPrev)
{
#ifdef EDEBUG
  cout << "HtmlContent::showHtml:"<<endl;
#endif
  htmlw->begin();
  htmlw->parse();

  if (!bgImage.isEmpty())
    htmlw->write("<HTML><BODY background=file:"+bgImage+">");
  else if (!bgColor.isEmpty())
    htmlw->write("<HTML><BODY bgcolor="+bgColor+">");
  else
    htmlw->write("<HTML><BODY>");

  QString s;
  if (!prev->list().isEmpty() && showPrev){
     QStrList buffer=prev->list();
     for (s=buffer.at(size-10);s;s=buffer.next())
         htmlw->write(s);
  }
  for (s=buffer.first();s;s=buffer.next())
      htmlw->write(s);
}

void  HtmlContent::setBgImage(const char* bgImg)
{
    bgColor="";
    bgImage=bgImg;
    showHtml(true);
}

void  HtmlContent::setBgColor(const char* bgClr)
{
    bgImage="";
    bgColor=bgClr;
    showHtml(true);
}

void HtmlContent::setPrev(HtmlContent* p)
{
  prev = p;
}

QStrList& HtmlContent::list()
{
  return buffer;
}




