#ifndef __FILELISTBOX_H__
#define __FILELISTBOX_H__

#include <qdir.h>
#include <qcombo.h>
#include <qstrlist.h>
#include <qlistbox.h>
#include <qlayout.h>
#include "ktablistbox.h"

// FileFilterBox
class FileFilterBox : public QComboBox
{
  Q_OBJECT
protected:
  void init(const char* Filter);
public:
  FileFilterBox(QWidget* parent, const char* Name=0, const char* Filter="*");
  FileFilterBox(bool, QWidget* parent, const char* Name=0, const char* Filter="*");
  virtual ~FileFilterBox(){}

  void setFilter    (const char*);
  void setFilterList(QStrList& list);
};

// FileDirBox
class FileDirBox : public QComboBox
{
  Q_OBJECT
protected:
  QDir dir;
  QString curDir;
public:
  FileDirBox (QWidget* parent, const char* name=0, const char* Dir=0);
  ~FileDirBox();
  void setPath   (const char* path);
  void setFilter (int f){dir.setFilter (f);}
  void setSorting(int f){dir.setSorting(f);}
  QString getPath(){return curDir;}
signals:
  void signActivated(const char*);
protected slots:
  void slotActivated(int);
};

// FileListBox
class FileListBox : public KTabListBox
{
  Q_OBJECT
protected:
  QString curDir;
  QString curFilter;
public:
  FileListBox(QWidget* parent, const char* name=0, int column=2);
  ~FileListBox(){};
public slots:
  void slotFilterActivated(const char*);
  void slotDirActivated(const char*);
};

// FileBox
class FileBox : public QWidget
{
  Q_OBJECT
protected:
  QVBoxLayout*   topLayout;
  FileFilterBox* filterBox;
  FileDirBox*    dirBox;
  FileListBox*   listBox;
  QFrame*        frame;
protected:
  virtual void resizeEvent(QResizeEvent* e);
public:
  FileBox(QWidget* parent, const char* name=NULL, const char* filter="*", const char* dir=NULL);
  ~FileBox(){}
  QString selectedFile();
  QString fileSize();
  QString  selectedDir(){return dirBox->currentText();}
  void setDir(const char* dir){dirBox->setPath(dir);}
  void refresh();
  void setFilterList(QStrList& list){filterBox->setFilterList(list);}
  FileFilterBox* getFilterBox(){return filterBox;}
  FileDirBox*    getDirBox(){return dirBox;}
  FileListBox*   getListBox(){return listBox;}
};

#endif



