#ifndef __DCCFILE_H__
#define __DCCFILE_H__

#include <qdatetime.h> 
#include "dccClient.h"
#include <qfile.h>

#define DCC_INCOMING    0
#define DCC_OUTGOING    1

class DCCFile : public DCCClient
{
  Q_OBJECT
protected:
  uint size;
  uint curSize;
  int  block;
  QFile file;
  ulong timer;
protected:
  void Init();
  void dccIncoming();
  void dccOutgoing();
  void transferCompleted(ulong speed, ulong remain);
public:
  DCCFile(const char* User, const char* file, const char* ip, const char* port, const char* size, 
	  QObject* Parent,  const char* Name=NULL);
  DCCFile(const char* User, const char* file, QObject* Parent,  const char* Name=NULL);
  ~DCCFile();
  virtual QString cmdSubstitution(const char* Txt);
signals:
  void signValue(int curSize, ulong speed, ulong timeRemain);
public slots:
  virtual void slotServe   (IrcCore*);
  virtual void slotMsgParse(int);
  virtual void slotDisconnected();
  virtual void slotConnected   ();
  void slotInputParse(const char* Txt);
};

#endif
