#ifndef __CLIENT_CONFIG_H__
#define __CLIENT_CONFIG_H__

#include <qobject.h>
#include <qstring.h>
#include <qtstream.h>
#include <qfile.h>
#include <qfileinf.h>
#include "fileReader.h"
#include "ircServer.h"

class ClientConfig;

typedef int (ClientConfig::*readFunc)(const char*);
typedef struct ReadTabTag {
  const char* name;
  readFunc    func;
} ReadTab;


class ClientConfig
{
protected:
  static ReadTab  readTab[];
  QString entry;
  QString path;
public:
  QStrIList nick;
  QStrIList user;
  QStrList  ircname;
  QDict<IrcServer>*  server;
  QDictIterator<IrcServer>* itServer;

  IrcServer* curServer;
  QString curNick;
  QString curUser;
  QString curIrcname;
protected:
  int  parseConfig(const char* Txt);
  void readNick       (const char* Line);
  void readCurrentNick(const char* Line);
  void readUser       (const char* Line);
  void readCurrentUser(const char* Line);
  void readIrcname       (const char* Line);
  void readCurrentIrcname(const char* Line);
  void readServer       (const char* Line);
  void readCurrentServer(const char* Line);
public:
  ClientConfig ();
  ~ClientConfig();
  QString    currentNick();
  IrcServer* currentServer();
  int  loadConfig(const char* File=0);
  int  saveConfig(const char* File=0);
};

#endif



