#ifndef __CHANNELMODE_H__
#define __CHANNELMODE_H__

#include <qlist.h>
#include <qobject.h>
#include "ircMode.h"
#include "ircBan.h"

class ChannelMode : public IrcMode
{
  Q_OBJECT
protected:
  QDict<char>*    modeVar;     // limit, key
  QList<IrcBan>*  modeBan; 
public:
  ChannelMode();
  ~ChannelMode();
  virtual QString addMode(const char* mode, const char* param=NULL);
  virtual QString delMode(const char* mode, const char* param=NULL);
  QString key();
  QString limit();
  QList<IrcBan>* banList();
signals:
  void signAddMode(char c, const char* param);
  void signDelMode(char c, const char* param);
};

#endif
