#ifndef __IRCSOCKET_H__
#define __IRCSOCKET_H__

#include "ircServer.h"
#include "ClientSocket.h"
#include "socks.h"

class IrcSocket;

typedef int (IrcSocket::*sendFunc)(const char*);
typedef struct SendTabTag {
  const char* name;
  sendFunc    func;
} SendTab;


class IrcSocket : public Socks
{
  Q_OBJECT
protected:
   static SendTab  sendTab[];
public:
  // Konstruktor
  IrcSocket();
  IrcSocket(IrcServer* server);
  IrcSocket(const char* host, int port);
  ~IrcSocket();
  // Member funktion
  // Connection Registration
  int Open(IrcServer* server);
  int Open(const char* host, int port);
  int parseLine (const char* txt);
  int sendPass  (const char* txt);
  int sendNick  (const char* txt);
  int sendUser  (const char* txt);
  int sendOper  (const char* txt);
  int sendQuit  (const char* txt);
  int sendSQuit (const char* txt);
  
  // Channel operations
  int sendJoin  (const char* txt);
  int sendPart  (const char* txt);
  int sendMode  (const char* txt);
  int sendTopic (const char* txt);
  int sendNames (const char* txt);
  int sendList  (const char* txt);
  int sendInvite(const char* txt);
  int sendKick  (const char* txt);
  
  // Server queries and commands
  int sendVersion(const char* txt);
  int sendStats  (const char* txt);
  int sendLinks  (const char* txt);
  int sendTime   (const char* txt);
  int sendConnect(const char* txt);
  int sendTrace  (const char* txt);
  int sendAdmin  (const char* txt);
  int sendInfo   (const char* txt);

  // Sending messages
  int sendPrivmsg(const char* txt);
  int sendNotice (const char* txt);

  // User based query
  int sendWho    (const char* txt);
  int sendWhois  (const char* txt);
  int sendWhowas (const char* txt);

  // Miscellaneous messages
  int sendKill   (const char* txt);
  int sendPing   (const char* txt);
  int sendPong   (const char* txt);

  // Optionals
  int sendAway   (const char* txt);
  int sendRehash (const char* txt);
  int sendRestart(const char* txt);
  int sendSummon (const char* txt);
  int sendUsers  (const char* txt);
  int sendWallops(const char* txt);
  int sendUserhost(const char* txt);
  int sendIson   (const char* txt);

  // Others
  int sendRaw      (const char* txt);
  int sendCtcp     (const char* txt);
  int sendCtcpReply(const char* txt);
};

#endif




