#ifndef __CMDPARSER_H__
#define __CMDPARSER_H__

#include <qobject.h>
#include <qstring.h>

class IrcClient;
class CmdParser;

typedef int (CmdParser::*cmdFunc)(const char* from, const char* txt);
typedef struct CmdTabTag {
  const char* name;
  cmdFunc     func;
} CmdTab;

class CmdParser : public QObject
{
  Q_OBJECT
protected:
  static CmdTab cmdTab [];
  IrcClient* client;
public:
  // Konstructor
  CmdParser(QObject* Parent, const char* Name=0);
  ~CmdParser(){};
  // Member Funktionen
  int parseLine (const char* from, const char* txt);
protected:
  int cmdCtcp   (const char* from, const char* txt);
  int cmdDCC    (const char* from, const char* txt);
  int cmdPrivMsg(const char* from, const char* txt);
  int cmdNotice (const char* from, const char* txt);
  int cmdPart   (const char* from, const char* txt);
  int cmdBrowser(const char* from, const char* txt);
  int cmdAddPage(const char* from, const char* txt);
  int cmdDelPage(const char* from, const char* txt);
  int cmdAddBan (const char* from, const char* txt);
  int cmdDelBan (const char* from, const char* txt);
  int cmdAddFriend (const char* from, const char* txt);
  int cmdDelFriend (const char* from, const char* txt);
  int cmdAddIgnore (const char* from, const char* txt);
  int cmdDelIgnore (const char* from, const char* txt);
  int cmdTcl    (const char* from, const char* txt);
  int cmdShow   (const char* from, const char* txt);
  int cmdServer (const char* from, const char* txt);
  int cmdLoad   (const char* from, const char* txt);
};

#endif







