#include <stdlib.h>
#include <iostream.h>
#include <qpushbt.h>
#include <qframe.h>
#include "kmsgbox.h"
#include "StringToken.h"
#include "ircDefine.h"
#include "lineDialog.h"
#include "ircClient.h"
#include "channelDialog.h"
#include "ircApp.h"

class IrcClient;

ChannelDialog::ChannelDialog(IrcClient* client, QWidget *parent, const char *name ) : 
  QDialog(parent, name, true)
{
#ifdef EDEBUG
  cout << "ChannelDialog Konstruktor"<<endl;
#endif
  mClient = client;

  horLayout  = new QHBoxLayout(this, 10);
  lVerLayout = new QVBoxLayout(5);
  horLayout->addLayout(lVerLayout,5);

  createChannelBox();
  lVerLayout->addSpacing(30);

  rVerLayout = new QVBoxLayout(0);
  horLayout->addLayout(rVerLayout,1);
  createButton();

  horLayout->activate();

  readConfig();
  setCaption("Preference Channels");
}

ChannelDialog::~ChannelDialog()
{
#ifdef EDEBUG
  cout << "Destruktor ChannelDialog" << endl;
#endif
}


void ChannelDialog::createChannelBox()
{
#ifdef EDEBUG
  cout << "ChannelDialog::createChannelBox" << endl;
#endif

  mChannelEdit = new QLineEdit(this);
  lVerLayout->addWidget(mChannelEdit);
  mChannelEdit->setFixedHeight(24);

  QFrame* chanFrame = new QFrame(this);
  chanFrame->setLineWidth(2);
  chanFrame->setFrameStyle(QFrame::Panel|QFrame::Sunken);

  lVerLayout->addWidget(chanFrame);

  QVBoxLayout* vbox = new QVBoxLayout(chanFrame, 3);;

  mChannelBox   = new KTabListBox(chanFrame, "channelBox", 1);
  vbox->addWidget(mChannelBox);
  mChannelBox->setColumn(0, "Channel");
  mChannelBox->setColumnWidth(0, 75);
  mChannelBox->setSeparator  (':');
  vbox->activate();
}

void ChannelDialog::createButton()
{
#ifdef EDEBUG
  cout << "ChannelDialog::createBotton" << endl;
#endif
  QPushButton* btn;

  btn = new QPushButton(" Add ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotAdd()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);
  btn = new QPushButton(" Delete ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotDelete()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  rVerLayout->addSpacing(10);

  btn = new QPushButton(" Join ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotJoin()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  rVerLayout->addSpacing(10);
  btn = new QPushButton(" Ok ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotOk()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  btn = new QPushButton(" Cancel ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (reject()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  rVerLayout->addStretch(10);
}

void ChannelDialog::readConfig()
{
#ifdef EDEBUG
  cout << "ChannelDialog::readConfig" << endl;
#endif
  KConfig* config=ircapp->config;

  mChannelBox->clear();
  QStrList list;
  list.setAutoDelete(true);

  int n=config->readListEntry("ChannelList", list, mChannelBox->separator());
  if (n>0)
     mChannelBox->appendStrList(&list);
}

bool ChannelDialog::checkItem(QString f)
{
  for (uint i=0;i<mChannelBox->count();i++){
     QString t=mChannelBox->text(i, 0);
     if (!stricmp(f, t)){
       KMsgBox::message(this, "Add Dialog", "This item "+t+ " is already existed", 
			KMsgBox::INFORMATION, "OK");
       return true;
     }
  }
  return false;
}

void ChannelDialog::slotAdd()
{
  QString s = mChannelEdit->text();
  if (s.isEmpty())
     return;

  if (checkItem(s))
     return;
  mChannelBox->appendItem(s);
  mChannelBox->setCurrentItem(-1);
}

void ChannelDialog::slotJoin()
{
  QString s="";
  int idx = mChannelBox->currentItem();
  if (idx<0)
     s = mChannelEdit->text();
  else
     s = mChannelBox->text(idx, 0);
  if (s.isEmpty())
     reject();
  
  mClient->slotInputParse(QString("/JOIN "+s));
  accept();			  
}

void ChannelDialog::slotDelete()
{
  int idx = mChannelBox->currentItem();
  if (idx>=0)
     mChannelBox->removeItem(idx);
}

void ChannelDialog::slotOk()
{
  KConfig* config=ircapp->config;

  QStrList list;
  list.setAutoDelete(true);
  QString s;
  for (uint i=0;i<mChannelBox->count();i++){
     QString s = mChannelBox->text(i, 0);
     list.append(s);
  }
  if (mChannelBox->count()>0){
     config->writeEntry("ChannelList", list, mChannelBox->separator());
  }
  accept();
}

void ChannelDialog::show()
{
  QPoint p=pos();
  move(p);
  QDialog::show();
}

#include "channelDialog.moc"




