/***************************************************************************
    ksqlplusdlg.h  -  SQL*Plus executable name setting dialog interface

    begin                : Mon Apr 24 2000
    copyright            : (C) 2000 by Yury Lebedev
    email                : yurylebedev@mail.ru
    home page            : http://devel-home.kde.org/~ksqlplus
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSQLPLUSDLG_H
#define KSQLPLUSDLG_H

// platform configuration stuff
#if defined(HAVE_CONFIG_H) && !defined(CONFIG_H)
#define CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qstring.h>
#include <qwidget.h>
#include <qdialog.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qcombobox.h>

// include files for KDE
#include <kprocess.h>

/**
 * Dialog class for setting up the SQL*Plus executable name and
 * RSH/SSH parameters.
 *
 * @author Yury Lebedev
 **/
class KSqlPlusDlg : public QDialog
{
  Q_OBJECT

private:
  /** Choice of local SQL*Plus */
  QRadioButton* localRadio;
  /** Choice of remote SQL*Plus */
  QRadioButton* remoteRadio;

  /** Remote SQL*Plus: shell */
  QComboBox* shellCombo;
  /** Remote SQL*Plus: user */
  QLineEdit* userEdit;
  /** Remote SQL*Plus: host */
  QLineEdit* hostEdit;
  /** Remote SQL*Plus: remote ORACLE_HOME */
  QLineEdit* oracleHomeEdit;
  /** Remote SQL*Plus: remote ORACLE_SID */
  QLineEdit* oracleSidEdit;
  /** Remote SQL*Plus: remote NLS_LANG */
  QLineEdit* nlsLangEdit;

  /** path to local SQL*Plus process based on ORACLE_HOME variable */
  QString localSqlplusPath;

public:
  /** Constructs dialog and its internal widgets. */
  KSqlPlusDlg(QWidget* parent = 0, const char* name = 0);
  /** Destructor */
  ~KSqlPlusDlg();

  /** User has choosed local SQL*Plus or remote one.
    * 0 is usage of local SQL*Plus. */
  int localRemote();
  /** Set initial select for local/remote SQL*Plus */
  void setLocalRemote(int localRemote, bool writeConfig = true);

  /** Return remote host name */
  const char* remoteHost() { return hostEdit->text(); }

  /** Restore initial parameters */
  void restore() { readOptions(); }

  /** Set up arguments for SQL*Plus starting */
  void setupSqlplus(KProcess& proc, const char* connectString);

protected:
  /** Restore the parameters from application's config */
  void readOptions();
  /** Save parameters to the application's config */
  void saveOptions();

protected slots: // Protected slots
  /** Slot for 'remote SQL*Plus' radio button toggling */
  void remoteRadioToggled(bool on);
  /** Check data and accept dialog */
  void ok();
};

#endif
